/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.ibatis.spring;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlMapClientFactoryBean
extends org.springframework.orm.ibatis.SqlMapClientFactoryBean {
    private SqlExecutor sqlExecutor;

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        SqlMapClient c = this.getObject();
        if (this.sqlExecutor != null && c instanceof SqlMapClientImpl) {
            SqlMapClientImpl client = (SqlMapClientImpl)c;
            SqlMapExecutorDelegate delegate = client.getDelegate();
            try {
                ReflectUtil.setFieldValue(delegate, "sqlExecutor", SqlExecutor.class, this.sqlExecutor);
                System.out.println("[iBATIS] success set ibatis SqlMapClient.sqlExecutor = " + this.sqlExecutor.getClass().getName());
            }
            catch (Exception e) {
                System.err.println("[iBATIS] error,cannot set ibatis SqlMapClient.sqlExecutor = " + this.sqlExecutor.getClass().getName() + " cause:" + e);
            }
        }
    }

    static class ReflectUtil {
        private static final Log logger = LogFactory.getLog(ReflectUtil.class);

        ReflectUtil() {
        }

        public static void setFieldValue(Object target, String fname, Class ftype, Object fvalue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            if (target == null || fname == null || "".equals(fname) || fvalue != null && !ftype.isAssignableFrom(fvalue.getClass())) {
                return;
            }
            Class<?> clazz = target.getClass();
            try {
                Method method = clazz.getDeclaredMethod("set" + Character.toUpperCase(fname.charAt(0)) + fname.substring(1), ftype);
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                method.invoke(target, fvalue);
            }
            catch (Exception me) {
                Field field = clazz.getDeclaredField(fname);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(target, fvalue);
            }
        }
    }
}

