/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.mail;

import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.springframework.mail.MailMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.Assert;

public class SimpleMailMessageUtils {
    public static HtmlMimeMessagePreparator toHtmlMsg(SimpleMailMessage msg) {
        return SimpleMailMessageUtils.toHtmlMsg(msg, null);
    }

    public static HtmlMimeMessagePreparator toHtmlMsg(SimpleMailMessage msg, String fromPersonal) {
        return new HtmlMimeMessagePreparator(msg, fromPersonal);
    }

    public static class HtmlMimeMessagePreparator
    implements MimeMessagePreparator {
        private SimpleMailMessage simpleMailMessage;
        private String fromPersonal;

        public HtmlMimeMessagePreparator(SimpleMailMessage simpleMailMessage) {
            this(simpleMailMessage, null);
        }

        public HtmlMimeMessagePreparator(SimpleMailMessage simpleMailMessage, String fromPersonal) {
            this.setSimpleMailMessage(simpleMailMessage);
            this.fromPersonal = fromPersonal;
        }

        public SimpleMailMessage getSimpleMailMessage() {
            return this.simpleMailMessage;
        }

        public void setSimpleMailMessage(SimpleMailMessage simpleMailMessage) {
            Assert.notNull((Object)simpleMailMessage, (String)"simpleMailMessage must be not null");
            this.simpleMailMessage = simpleMailMessage;
        }

        public String getFromPersonal() {
            return this.fromPersonal;
        }

        public void setFromPersonal(String fromPersonal) {
            this.fromPersonal = fromPersonal;
        }

        public void prepare(MimeMessage mimeMessage) throws Exception {
            this.simpleMailMessage.copyTo((MailMessage)new MimeMailMessage(mimeMessage));
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, mimeMessage.getEncoding());
            helper.setText(this.simpleMailMessage.getText(), true);
            if (StringUtils.isNotEmpty((String)this.fromPersonal)) {
                mimeMessage.setFrom((Address)new InternetAddress(this.simpleMailMessage.getFrom(), this.fromPersonal));
            }
        }
    }
}

