/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.page;

import cn.org.rapid_framework.page.PageRequest;
import cn.org.rapid_framework.page.PageUtils;
import cn.org.rapid_framework.util.page.PageQuery;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page<T>
implements Serializable,
Iterable<T> {
    protected List<T> result;
    protected int pageSize;
    protected int pageNumber;
    protected int totalCount = 0;

    public Page(PageRequest p, int totalCount) {
        this(p.getPageNumber(), p.getPageSize(), totalCount);
    }

    public Page(PageQuery p, int totalCount) {
        this(p.getPage(), p.getPageSize(), totalCount);
    }

    public Page(int pageNumber, int pageSize, int totalCount) {
        this(pageNumber, pageSize, totalCount, new ArrayList(0));
    }

    public Page(int pageNumber, int pageSize, int totalCount, List<T> result) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        this.pageSize = pageSize;
        this.pageNumber = PageUtils.computePageNumber(pageNumber, pageSize, totalCount);
        this.totalCount = totalCount;
        this.setResult(result);
    }

    public void setResult(List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("'result' must be not null");
        }
        this.result = elements;
    }

    public List<T> getResult() {
        return this.result;
    }

    public boolean isFirstPage() {
        return this.getThisPageNumber() == 1;
    }

    public boolean isLastPage() {
        return this.getThisPageNumber() >= this.getLastPageNumber();
    }

    public boolean isHasNextPage() {
        return this.getLastPageNumber() > this.getThisPageNumber();
    }

    public boolean isHasPreviousPage() {
        return this.getThisPageNumber() > 1;
    }

    public int getLastPageNumber() {
        return PageUtils.computeLastPageNumber(this.totalCount, this.pageSize);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getThisPageFirstElementNumber() {
        return (this.getThisPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getThisPageLastElementNumber() {
        int fullPage = this.getThisPageFirstElementNumber() + this.getPageSize() - 1;
        return this.getTotalCount() < fullPage ? this.getTotalCount() : fullPage;
    }

    public int getNextPageNumber() {
        return this.getThisPageNumber() + 1;
    }

    public int getPreviousPageNumber() {
        return this.getThisPageNumber() - 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getThisPageNumber() {
        return this.pageNumber;
    }

    public Integer[] getLinkPageNumbers() {
        return this.linkPageNumbers(7);
    }

    public Integer[] linkPageNumbers(int count) {
        return PageUtils.generateLinkPageNumbers(this.getThisPageNumber(), this.getLastPageNumber(), count);
    }

    public int getFirstResult() {
        return PageUtils.getFirstResult(this.pageNumber, this.pageSize);
    }

    @Override
    public Iterator<T> iterator() {
        return this.result == null ? Collections.emptyList().iterator() : this.result.iterator();
    }
}

