/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.page;

import cn.org.rapid_framework.page.SortInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRequest<T>
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 10;
    @Deprecated
    private T filters;
    private int pageNumber;
    private int pageSize = 10;
    private String sortColumns;

    public PageRequest() {
    }

    @Deprecated
    public PageRequest(T filters) {
        this.setFilters(filters);
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, (Object)null);
    }

    @Deprecated
    public PageRequest(int pageNumber, int pageSize, T filters) {
        this(pageNumber, pageSize, filters, null);
    }

    public PageRequest(int pageNumber, int pageSize, String sortColumns) {
        this(pageNumber, pageSize, null, sortColumns);
    }

    @Deprecated
    public PageRequest(int pageNumber, int pageSize, T filters, String sortColumns) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.setFilters(filters);
        this.setSortColumns(sortColumns);
    }

    @Deprecated
    public T getFilters() {
        return this.filters;
    }

    @Deprecated
    public void setFilters(T filters) {
        this.filters = filters;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(String sortColumns) {
        this.checkSortColumnsSqlInjection(sortColumns);
        if (sortColumns != null && sortColumns.length() > 200) {
            throw new IllegalArgumentException("sortColumns.length() <= 200 must be true");
        }
        this.sortColumns = sortColumns;
    }

    public List<SortInfo> getSortInfos() {
        return Collections.unmodifiableList(SortInfo.parseSortColumns(this.sortColumns));
    }

    private void checkSortColumnsSqlInjection(String sortColumns) {
        if (sortColumns == null) {
            return;
        }
        if (sortColumns.indexOf("'") >= 0 || sortColumns.indexOf("\\") >= 0) {
            throw new IllegalArgumentException("sortColumns:" + sortColumns + " has SQL Injection risk");
        }
    }
}

