/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.pipeline;

import cn.org.rapid_framework.pipeline.PipeException;
import cn.org.rapid_framework.pipeline.Pipeline;
import cn.org.rapid_framework.util.StringTokenizerUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityPipeline
implements Pipeline {
    private VelocityEngine engine;
    private int bufferSize = 4096;

    public VelocityPipeline() {
    }

    public VelocityPipeline(VelocityEngine engine) {
        this.setVelocityEngine(engine);
    }

    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.engine = engine;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Writer pipeline(String[] pipeTemplates, Map model, Writer writer) throws PipeException {
        VelocityContext context = new VelocityContext(model);
        return this._pipeline(pipeTemplates, (Context)context, writer);
    }

    private Writer _pipeline(String[] pipeTemplates, Context context, Writer writer) throws PipeException {
        try {
            for (int i = 0; i < pipeTemplates.length; ++i) {
                String templateName = pipeTemplates[i];
                boolean isLastTemplate = i == pipeTemplates.length - 1;
                try {
                    Template template = this.engine.getTemplate(templateName);
                    if (isLastTemplate) {
                        template.merge(context, writer);
                        continue;
                    }
                    StringWriter tempOutput = new StringWriter(this.bufferSize);
                    template.merge(context, (Writer)tempOutput);
                    context.put("pipeline_content", (Object)((Object)tempOutput).toString());
                    continue;
                }
                catch (Exception e) {
                    this.handleException(e, templateName, isLastTemplate);
                }
            }
            return writer;
        }
        catch (Exception e) {
            throw new PipeException("process Velocity template occer exception,pipeTemplates:" + StringUtils.join((Object[])pipeTemplates, (String)" | "));
        }
    }

    public void handleException(Exception e, String templateName, boolean isLastTemplate) throws Exception {
        throw e;
    }

    public Writer pipeline(String[] pipeTemplates, Object model, Writer writer) throws PipeException {
        if (model instanceof Context) {
            return this._pipeline(pipeTemplates, (Context)model, writer);
        }
        throw new UnsupportedOperationException("velocity model instance must be Context or Map object");
    }

    public Writer pipeline(String pipeTemplates, Map model, Writer writer) throws PipeException {
        return this.pipeline(StringTokenizerUtils.split(pipeTemplates, ",| "), model, writer);
    }

    public Writer pipeline(String pipeTemplates, Object model, Writer writer) throws PipeException {
        if (model instanceof Context) {
            return this._pipeline(StringTokenizerUtils.split(pipeTemplates, ",| "), (Context)model, writer);
        }
        throw new UnsupportedOperationException("velocity model instance must be Context or Map object");
    }
}

