/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.test.hsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.ResourceUtils;

public class HSQLMemDataSourceUtils {
    static long hsqlDbIdSequence = 0L;

    public static DataSource getDataSource(Class initScripts, String encoding) {
        String resource = "classpath:" + initScripts.getName().replace('.', '/') + ".sql";
        try {
            File file = ResourceUtils.getFile((String)resource);
            return HSQLMemDataSourceUtils.getDataSource(file, encoding);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("sql file not found,file:" + resource, e);
        }
    }

    public static DataSource getDataSource(String initScripts) {
        return HSQLMemDataSourceUtils.getDataSource(new StringReader(initScripts));
    }

    public static DataSource getDataSource(Resource initScripts, String encoding) {
        DataSource dataSource;
        InputStreamReader input = null;
        try {
            input = new InputStreamReader(initScripts.getInputStream(), encoding);
            dataSource = HSQLMemDataSourceUtils.getDataSource(input);
            Object var5_5 = null;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("get datasource occer Exception:" + e, e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IOUtils.closeQuietly((Reader)input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)input);
        return dataSource;
    }

    public static DataSource getDataSource(File initScripts, String encoding) {
        DataSource dataSource;
        System.out.println("execute hsql db scripts from file:" + initScripts.getAbsolutePath());
        InputStreamReader input = null;
        try {
            input = new InputStreamReader((InputStream)new FileInputStream(initScripts), encoding);
            dataSource = HSQLMemDataSourceUtils.getDataSource(input);
            Object var5_5 = null;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("get datasource occer IOException:" + e, e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)input);
        return dataSource;
    }

    public static DataSource getDataSource(Reader initScripts) {
        DataSource ds = HSQLMemDataSourceUtils.getDataSource();
        try {
            HSQLMemDataSourceUtils.executeSqlScripts(initScripts, ds);
        }
        catch (Exception e) {
            throw new IllegalStateException("execute sql error", e);
        }
        return ds;
    }

    public static synchronized DataSource getDataSource() {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setDriverClassName("org.hsqldb.jdbcDriver");
        ds.setUrl("jdbc:hsqldb:mem:memDB" + System.currentTimeMillis() + "" + hsqlDbIdSequence++);
        ds.setUsername("sa");
        ds.setPassword("");
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlScripts(Reader initScripts, DataSource ds) throws SQLException, IOException {
        Connection conn = ds.getConnection();
        try {
            String sql = IOUtils.toString((Reader)initScripts);
            StringTokenizer tokenizer = new StringTokenizer(sql, ";");
            System.out.println("Execute HSQL DB DataSource with sql:");
            while (tokenizer.hasMoreTokens()) {
                String tokenSql = tokenizer.nextToken().trim();
                if ("".equals(tokenSql)) continue;
                System.out.println(tokenSql);
                try {
                    Statement stat = conn.createStatement();
                    stat.execute(tokenSql);
                    stat.close();
                }
                catch (SQLException e) {
                    throw new SQLException("execute sql error:" + e + " error sql:\n" + tokenSql + " cause:" + e);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }
}

