/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.filter;

import cn.org.rapid_framework.web.util.FilterConfigUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class PerformanceFilter
extends OncePerRequestFilter
implements Filter {
    int threshold = 3000;
    boolean includeQueryString = false;
    private static final Log log = LogFactory.getLog(PerformanceFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String requestString = this.dumpRequest((ServletRequest)request);
        Throwable failed = null;
        long start = System.currentTimeMillis();
        try {
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Throwable e) {
                failed = e;
                PerformanceFilter.rethrowThrowable(failed);
                Object var10_8 = null;
                long duration = System.currentTimeMillis() - start;
                if (failed != null) {
                    log.error((Object)(requestString + ",F," + duration + "ms"));
                    return;
                }
                if (duration > (long)this.threshold) {
                    log.warn((Object)(requestString + ",Y," + duration + "ms"));
                    return;
                }
                if (!log.isInfoEnabled()) return;
                log.info((Object)(requestString + ",Y," + duration + "ms"));
                return;
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            long duration = System.currentTimeMillis() - start;
            if (failed != null) {
                log.error((Object)(requestString + ",F," + duration + "ms"));
                throw throwable;
            }
            if (duration > (long)this.threshold) {
                log.warn((Object)(requestString + ",Y," + duration + "ms"));
                throw throwable;
            }
            if (!log.isInfoEnabled()) throw throwable;
            log.info((Object)(requestString + ",Y," + duration + "ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        if (failed != null) {
            log.error((Object)(requestString + ",F," + duration + "ms"));
            return;
        }
        if (duration > (long)this.threshold) {
            log.warn((Object)(requestString + ",Y," + duration + "ms"));
            return;
        }
        if (!log.isInfoEnabled()) return;
        log.info((Object)(requestString + ",Y," + duration + "ms"));
    }

    private static void rethrowThrowable(Throwable failed) throws Error, IOException, ServletException {
        if (failed != null) {
            if (failed instanceof Error) {
                throw (Error)failed;
            }
            if (failed instanceof RuntimeException) {
                throw (RuntimeException)failed;
            }
            if (failed instanceof IOException) {
                throw (IOException)failed;
            }
            if (failed instanceof ServletException) {
                throw (ServletException)failed;
            }
            throw new RuntimeException(failed);
        }
    }

    public void initFilterBean() throws ServletException {
        this.threshold = FilterConfigUtils.getIntParameter(this.getFilterConfig(), "threshold", this.threshold);
        this.includeQueryString = FilterConfigUtils.getBooleanParameter(this.getFilterConfig(), "includeQueryString", this.includeQueryString);
        log.info((Object)("PerformanceFilter started with threshold:" + this.threshold + "ms includeQueryString:" + this.includeQueryString));
    }

    protected String dumpRequest(ServletRequest request) {
        String queryString;
        HttpServletRequest req = (HttpServletRequest)request;
        StringBuffer buffer = new StringBuffer(req.getMethod());
        buffer.append("__").append(req.getRequestURI());
        if (this.includeQueryString && StringUtils.isNotBlank((String)(queryString = req.getQueryString()))) {
            buffer.append("?").append(queryString);
        }
        return buffer.toString();
    }
}

