/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.flex.messaging.services;

import cn.org.rapid_framework.flex.messaging.annotation.RemotingObject;
import flex.messaging.Destination;
import flex.messaging.config.ConfigMap;
import flex.messaging.services.AbstractBootstrapService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceException;
import flex.messaging.services.remoting.RemotingDestination;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringRemotingDestinationBootstrapService
extends AbstractBootstrapService {
    public static final String DEFAULT_INCLUDE_END_WITH_BEANS = "FlexService";
    private String destChannel;
    private String destSecurityConstraint;
    private String destScope;
    private String destAdapter;
    private String destFactory;
    private String serviceId;
    private String includeEndsWithBeans;

    public void initialize(String id, ConfigMap properties) {
        this.serviceId = properties.getPropertyAsString("service-id", "remoting-service");
        this.destFactory = properties.getPropertyAsString("dest-factory", "spring");
        this.destAdapter = properties.getProperty("dest-adapter");
        this.destScope = properties.getProperty("dest-scope");
        this.destSecurityConstraint = properties.getProperty("dest-security-constraint");
        this.destChannel = properties.getPropertyAsString("dest-channel", "my-amf");
        this.includeEndsWithBeans = properties.getPropertyAsString("includeEndsWithBeans", DEFAULT_INCLUDE_END_WITH_BEANS);
        Service remotingService = this.broker.getService(this.serviceId);
        if (remotingService == null) {
            throw this.createServiceException("not found Service with serviceId:" + this.serviceId);
        }
        this.createSpringDestinations(remotingService);
    }

    private ServiceException createServiceException(String message) {
        ServiceException ex = new ServiceException();
        ex.setMessage(message);
        return ex;
    }

    private void createSpringDestinations(Service remotingService) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.broker.getServletContext());
        ArrayList<String> addedBeanNames = new ArrayList<String>();
        for (String beanName : wac.getBeanDefinitionNames()) {
            boolean isCreateSpringDestination;
            Class type = wac.getType(beanName);
            boolean bl = isCreateSpringDestination = type.isAnnotationPresent(RemotingObject.class) || beanName.endsWith(this.includeEndsWithBeans) || this.isCreateDestination(beanName, type);
            if (!isCreateSpringDestination) continue;
            this.createSpringDestination(remotingService, beanName);
            addedBeanNames.add(beanName);
        }
        System.out.println("[Auto Export Spring to BlazeDS RemotingDestination],beanNames=" + addedBeanNames);
    }

    protected boolean isCreateDestination(String beanName, Class type) {
        return false;
    }

    protected void createSpringDestination(Service service, String destinationId) {
        RemotingDestination destination = (RemotingDestination)service.createDestination(destinationId);
        destination.setSource(destinationId);
        destination.setFactory(this.destFactory);
        if (this.destAdapter != null) {
            destination.createAdapter(this.destAdapter);
        }
        if (this.destScope != null) {
            destination.setScope(this.destScope);
        }
        if (this.destSecurityConstraint != null) {
            destination.setSecurityConstraint(this.destSecurityConstraint);
        }
        if (this.destChannel != null) {
            destination.addChannel(this.destChannel);
        }
        service.addDestination((Destination)destination);
    }

    public void start() {
    }

    public void stop() {
    }
}

