/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.jdbc.sqlgenerator;

import cn.org.rapid_framework.jdbc.sqlgenerator.SqlGenerator;
import cn.org.rapid_framework.jdbc.sqlgenerator.metadata.Column;
import cn.org.rapid_framework.jdbc.sqlgenerator.metadata.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringNamedSqlGenerator
implements SqlGenerator {
    Table table;

    public SpringNamedSqlGenerator(Table table) {
        this.table = table;
    }

    public List<Column> getColumns() {
        return this.table.getColumns();
    }

    public String getTableName() {
        return this.table.getTableName();
    }

    public List<Column> getPrimaryKeyColumns() {
        return this.table.getPrimaryKeyColumns();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public boolean isMultiPrimaryKey() {
        return this.getPrimaryKeyColumns().size() > 1;
    }

    public boolean isSinglePrimaryKey() {
        return this.getPrimaryKeyColumns().size() == 1;
    }

    @Override
    public String getInsertSql() {
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(this.getTableName()).append(" (");
        ArrayList<String> insertColumns = new ArrayList<String>(this.getColumns().size());
        ArrayList<String> insertPlaceholderColumns = new ArrayList<String>(this.getColumns().size());
        for (int i = 0; i < this.getColumns().size(); ++i) {
            Column c = this.getColumns().get(i);
            if (!c.isInsertable()) continue;
            insertColumns.add(c.getSqlName());
            insertPlaceholderColumns.add(this.getColumnPlaceholder(c));
        }
        sb.append(StringUtils.join(insertColumns.iterator(), (String)","));
        sb.append(" ) VALUES ( ");
        sb.append(StringUtils.join(insertPlaceholderColumns.iterator(), (String)","));
        sb.append(" ) ");
        return sb.toString();
    }

    @Override
    public String getDeleteByPkSql() {
        if (this.isMultiPrimaryKey()) {
            return this.getDeleteByMultiPkSql();
        }
        if (this.isSinglePrimaryKey()) {
            return this.getDeleteBySinglePkSql();
        }
        throw new IllegalStateException("not found primary key on table:" + this.table.getTableName());
    }

    @Override
    public String getSelectByPkSql() {
        if (this.isMultiPrimaryKey()) {
            return this.getSelectByMultiPkSql();
        }
        if (this.isSinglePrimaryKey()) {
            return this.getSelectBySinglePkSql();
        }
        throw new IllegalStateException("not found primary key on table:" + this.table.getTableName());
    }

    @Override
    public String getUpdateByPkSql() {
        if (this.getPrimaryKeyColumns().size() == 0) {
            throw new IllegalStateException("not found primary key on table:" + this.table.getTableName());
        }
        StringBuilder sb = new StringBuilder("UPDATE ").append(this.getTableName()).append(" SET ");
        sb.append(StringUtils.join(this.getUpdateColumns().iterator(), (String)","));
        sb.append(" WHERE ");
        for (int i = 0; i < this.getPrimaryKeyColumns().size(); ++i) {
            Column c = this.getPrimaryKeyColumns().get(i);
            sb.append(c.getSqlName() + " = " + this.getColumnPlaceholder(c));
            if (i >= this.getPrimaryKeyColumns().size() - 1) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private List getUpdateColumns() {
        List<Column> columns = this.getColumns();
        ArrayList<String> updateColumns = new ArrayList<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            Column c = columns.get(i);
            if (!c.isUpdatable() || c.isPrimaryKey()) continue;
            updateColumns.add(c.getSqlName() + " = " + this.getColumnPlaceholder(c));
        }
        return updateColumns;
    }

    public String getDeleteByMultiPkSql() {
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(this.getTableName());
        sb.append(" WHERE ");
        List<Column> primaryKeyColumns = this.getPrimaryKeyColumns();
        for (int i = 0; i < primaryKeyColumns.size(); ++i) {
            Column c = primaryKeyColumns.get(i);
            sb.append(c.getSqlName() + " = " + this.getColumnPlaceholder(c));
            if (i >= primaryKeyColumns.size() - 1) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    public String getDeleteBySinglePkSql() {
        this.checkIsSinglePrimaryKey();
        List<Column> primaryKeyColumns = this.getPrimaryKeyColumns();
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(this.getTableName());
        sb.append(" WHERE ");
        sb.append(this.getSinglePrimaryKeyWhere());
        return sb.toString();
    }

    public String getSelectByMultiPkSql() {
        StringBuilder sb = new StringBuilder("SELECT " + this.getColumnsSql() + " FROM " + this.getTableName() + " WHERE ");
        List<Column> primaryKeyColumns = this.getPrimaryKeyColumns();
        for (int i = 0; i < primaryKeyColumns.size(); ++i) {
            Column c = primaryKeyColumns.get(i);
            sb.append(c.getSqlName() + " = " + this.getColumnPlaceholder(c));
            if (i >= primaryKeyColumns.size() - 1) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    public String getSelectBySinglePkSql() {
        this.checkIsSinglePrimaryKey();
        List<Column> primaryKeyColumns = this.getPrimaryKeyColumns();
        StringBuilder sb = new StringBuilder("SELECT " + this.getColumnsSql() + " FROM " + this.getTableName() + " WHERE ");
        sb.append(this.getSinglePrimaryKeyWhere());
        return sb.toString();
    }

    @Override
    public String getColumnsSql() {
        return this.getColumnsSql(null);
    }

    @Override
    public String getColumnsSql(String columnPrefix) {
        String realPrefix = StringUtils.isEmpty((String)columnPrefix) ? "" : columnPrefix + ".";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getColumns().size(); ++i) {
            Column c = this.getColumns().get(i);
            sb.append(realPrefix + c.getSqlName() + " " + c.getPropertyName());
            if (i >= this.getColumns().size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected String getColumnPlaceholder(Column c) {
        return ":" + c.getPropertyName();
    }

    protected String getSinglePrimaryKeyWhere() {
        Column c = this.getPrimaryKeyColumns().get(0);
        return c.getSqlName() + " = ?";
    }

    private void checkIsSinglePrimaryKey() {
        if (this.getPrimaryKeyColumns().size() != 1) {
            throw new IllegalStateException("expected single primary key on table:" + this.getTableName() + ",but was primary keys:" + this.getPrimaryKeyColumns());
        }
    }
}

