/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.spring.web.servlet.mvc.support;

import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.support.AbstractControllerUrlHandlerMapping;

public class ControllerClassNameHandlerMapping
extends AbstractControllerUrlHandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    private String pathPrefix;
    private String basePackage;

    public void setPathPrefix(String prefixPath) {
        this.pathPrefix = prefixPath;
        if (StringUtils.hasLength((String)this.pathPrefix)) {
            if (!this.pathPrefix.startsWith("/")) {
                this.pathPrefix = "/" + this.pathPrefix;
            }
            if (this.pathPrefix.endsWith("/")) {
                this.pathPrefix = this.pathPrefix.substring(0, this.pathPrefix.length() - 1);
            }
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        if (StringUtils.hasLength((String)this.basePackage) && !this.basePackage.endsWith(".")) {
            this.basePackage = this.basePackage + ".";
        }
    }

    protected String[] buildUrlsForHandler(String beanName, Class beanClass) {
        return this.generatePathMappings(beanClass);
    }

    protected String[] generatePathMappings(Class beanClass) {
        String path;
        StringBuffer pathMapping = this.buildPathPrefix(beanClass);
        String className = ClassUtils.getShortName((Class)beanClass);
        String string = path = className.endsWith(CONTROLLER_SUFFIX) ? className.substring(0, className.indexOf(CONTROLLER_SUFFIX)) : className;
        if (path.length() > 0) {
            pathMapping.append(path);
        }
        if (this.isMultiActionControllerType(beanClass)) {
            return new String[]{pathMapping.toString(), pathMapping.toString() + "/*"};
        }
        return new String[]{pathMapping.toString() + "*"};
    }

    private StringBuffer buildPathPrefix(Class beanClass) {
        String packageName;
        StringBuffer pathMapping = new StringBuffer();
        if (this.pathPrefix != null) {
            pathMapping.append(this.pathPrefix);
            pathMapping.append("/");
        } else {
            pathMapping.append("/");
        }
        if (this.basePackage != null && (packageName = ClassUtils.getPackageName((Class)beanClass)).startsWith(this.basePackage)) {
            String subPackage = packageName.substring(this.basePackage.length()).replace('.', '/');
            pathMapping.append(subPackage.toLowerCase());
            pathMapping.append("/");
        }
        return pathMapping;
    }
}

