/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.test.util;

import java.util.concurrent.CountDownLatch;

public class MultiThreadTestUtils {
    private MultiThreadTestUtils() {
    }

    public static long executeAndWait(int threadCount, Runnable task) throws InterruptedException {
        CountDownLatch doneSignal = MultiThreadTestUtils.execute(threadCount, task);
        long startTime = System.currentTimeMillis();
        doneSignal.await();
        return System.currentTimeMillis() - startTime;
    }

    public static CountDownLatch execute(int threadCount, final Runnable task) {
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch startedSignal = new CountDownLatch(threadCount);
        final CountDownLatch doneSignal = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    startedSignal.countDown();
                    try {
                        startSignal.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        task.run();
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            t.start();
        }
        try {
            startedSignal.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        startSignal.countDown();
        return doneSignal;
    }
}

