/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.concurrent.async;

import cn.org.rapid_framework.util.concurrent.async.AsyncToken;
import cn.org.rapid_framework.util.concurrent.async.AsyncTokenFactory;
import cn.org.rapid_framework.util.concurrent.async.IResponder;
import cn.org.rapid_framework.util.concurrent.async.UncaughtExceptionHandler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsyncTokenFactory
implements AsyncTokenFactory {
    private String tokenGroup = "default";
    private String tokenName;
    private List<IResponder> responders = new ArrayList<IResponder>();
    private UncaughtExceptionHandler uncaughtExceptionHandler;

    public String getTokenGroup() {
        return this.tokenGroup;
    }

    public void setTokenGroup(String tokenGroup) {
        this.tokenGroup = tokenGroup;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public List<IResponder> getResponders() {
        return this.responders;
    }

    public void setResponders(List<IResponder> responders) {
        Assert.notNull(responders, (String)"responders must be not null");
        this.responders = responders;
    }

    public void addResponder(IResponder r) {
        this.responders.add(r);
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public AsyncToken newToken() {
        AsyncToken t = new AsyncToken();
        t.setTokenGroup(this.tokenGroup);
        t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        t.setTokenName(this.tokenName);
        for (IResponder r : this.responders) {
            t.addResponder(r);
        }
        return t;
    }
}

