/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.session;

import cn.org.rapid_framework.web.session.store.SessionStore;
import cn.org.rapid_framework.web.session.wrapper.HttpServletRequestSessionWrapper;
import cn.org.rapid_framework.web.session.wrapper.HttpSessionSessionStoreWrapper;
import cn.org.rapid_framework.web.util.CookieUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpSessionStoreFilter
extends OncePerRequestFilter
implements Filter {
    private static Log log = LogFactory.getLog(HttpSessionStoreFilter.class);
    private String sessionIdCookieName = "_rapid_session_id";
    private String cookieDomain = null;
    SessionStore sessionStore;

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.sessionStore = this.lookSessionStore();
    }

    protected SessionStore lookSessionStore() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        SessionStore store = (SessionStore)wac.getBean("sessionStore", SessionStore.class);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using '" + store.getClass().getSimpleName() + "' SessionStore for HttpSessionStoreFilter"));
        }
        return store;
    }

    public void setSessionIdCookieName(String sessionIdCookieName) {
        this.sessionIdCookieName = sessionIdCookieName;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Cookie sessionIdCookie = this.getOrGenerateSessionId(request, response);
        String sessionId = sessionIdCookie.getValue();
        HttpSession rawSession = request.getSession();
        Map sessionData = this.loadSessionData(sessionId, rawSession);
        try {
            HttpSessionSessionStoreWrapper sessionWrapper = new HttpSessionSessionStoreWrapper(rawSession, this.sessionStore, sessionId, sessionData);
            chain.doFilter((ServletRequest)new HttpServletRequestSessionWrapper(request, sessionWrapper), (ServletResponse)response);
        }
        finally {
            try {
                this.sessionStore.saveSession(sessionId, sessionData, rawSession.getMaxInactiveInterval());
            }
            catch (Exception e) {
                log.warn((Object)("save session data error,cause:" + e), (Throwable)e);
            }
        }
    }

    private Map loadSessionData(String sessionId, HttpSession rawSession) {
        Map sessionData = null;
        try {
            sessionData = this.sessionStore.getSession(sessionId, rawSession.getMaxInactiveInterval());
        }
        catch (Exception e) {
            sessionData = new HashMap();
            log.warn((Object)("load session data error,cause:" + e), (Throwable)e);
        }
        return sessionData;
    }

    private Cookie getOrGenerateSessionId(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Cookie> cookieMap = CookieUtils.toMap(request.getCookies());
        Cookie sessionIdCookie = cookieMap.get(this.sessionIdCookieName);
        if (sessionIdCookie == null || org.apache.commons.lang.StringUtils.isEmpty((String)sessionIdCookie.getValue())) {
            sessionIdCookie = this.generateCookie(request, response);
        } else {
            sessionIdCookie.setMaxAge(request.getSession().getMaxInactiveInterval() * 60 * 60 * 1000);
        }
        return sessionIdCookie;
    }

    private Cookie generateCookie(HttpServletRequest request, HttpServletResponse response) {
        String sid = null;
        if (org.apache.commons.lang.StringUtils.isBlank(sid)) {
            sid = this.generateUUID();
        }
        Cookie sessionIdCookie = new Cookie(this.sessionIdCookieName, sid);
        if (this.cookieDomain != null) {
            sessionIdCookie.setDomain(this.cookieDomain);
        }
        sessionIdCookie.setPath(request.getContextPath());
        sessionIdCookie.setMaxAge(request.getSession().getMaxInactiveInterval());
        response.addCookie(sessionIdCookie);
        return sessionIdCookie;
    }

    private String generateUUID() {
        String uuid = UUID.randomUUID().toString();
        return StringUtils.replace((String)uuid, (String)"-", (String)"");
    }
}

