/*
 * Decompiled with CFR 0.152.
 */
package com.siit.image.wscommon.tools;

import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ObjToXml {
    private static Logger log = Logger.getLogger((String)"com.siit.image.wscommon.tools.ObjToXml");

    public static String toXml(Params params) throws Exception {
        log.info((Object)"OBJ >>> XML \u5f00\u59cb!");
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("params");
        Element safetyElement = root.addElement("safety");
        Safety safety = params.getSafety();
        safetyElement.addElement("clientcode").setText(safety.getClientcode());
        safetyElement.addElement("servicecode").setText(safety.getServicecode());
        safetyElement.addElement("time").setText(safety.getTime());
        safetyElement.addElement("ticket").setText(safety.getTicket());
        Element serverbodyElement = root.addElement("serverbody");
        Serverbody serverbody = params.getServerbody();
        serverbodyElement.addElement("servername").setText(serverbody.getServername());
        serverbodyElement.addElement("servertype").setText(serverbody.getServertype());
        Element servernameElement = serverbodyElement.addElement(serverbody.getServername());
        List<Service> serviceList = serverbody.getServices();
        ObjToXml.reflectXml(servernameElement, serviceList);
        OutputFormat format = OutputFormat.createCompactFormat();
        StringWriter writer = new StringWriter();
        XMLWriter output = new XMLWriter((Writer)writer, format);
        try {
            output.write(doc);
            writer.close();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        log.info((Object)("OBJ >>> XML \u7ed3\u675f\uff0cXML=" + writer.toString()));
        return writer.toString();
    }

    private static void reflectXml(Element servernameElement, List serviceList) {
        if (serviceList != null && serviceList.size() > 0) {
            for (Service service : serviceList) {
                Element serviceElement = servernameElement.addElement("service");
                Field[] fields = service.getClass().getFields();
                int i = 0;
                while (i < fields.length) {
                    String fieldName = fields[i].getName();
                    try {
                        Object fieldValue = fields[i].get(service);
                        if (fieldValue != null) {
                            serviceElement.addElement(fieldName).setText(fieldValue.toString());
                        } else {
                            serviceElement.addElement(fieldName).setText("");
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        }
    }
}

