/*
 * Decompiled with CFR 0.152.
 */
package com.siit.image.wscommon.tools;

import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlToObj {
    private static Logger log = Logger.getLogger(XmlToObj.class);

    public static Params toObj(String xml) throws Exception {
        log.info((Object)("XML >>> OBJ \u5f00\u59cb, XML=" + xml));
        Document doc = DocumentHelper.parseText((String)xml);
        Element rootElt = doc.getRootElement();
        Params params = new Params();
        Element safetyElement = rootElt.element("safety");
        String clientcode = safetyElement.elementTextTrim("clientcode");
        String servicecode = safetyElement.elementTextTrim("servicecode");
        String time = safetyElement.elementTextTrim("time");
        String ticket = safetyElement.elementTextTrim("ticket");
        Safety safety = new Safety();
        safety.setClientcode(clientcode);
        safety.setServicecode(servicecode);
        safety.setTime(time);
        safety.setTicket(ticket);
        params.setSafety(safety);
        Element serverbodyElement = rootElt.element("serverbody");
        String servername = serverbodyElement.elementTextTrim("servername");
        String servertype = serverbodyElement.elementTextTrim("servertype");
        Serverbody serverbody = new Serverbody();
        serverbody.setServername(servername);
        serverbody.setServertype(servertype);
        params.setServerbody(serverbody);
        Element servernameElement = serverbodyElement.element(servername);
        String oneStr = String.valueOf(servername.charAt(0));
        String otherStr = servername.substring(1, servername.length());
        String servernameClass = "com.siit.image.wscommon.obj." + oneStr.toUpperCase() + otherStr;
        Iterator serviceIter = servernameElement.elementIterator("service");
        ArrayList<Service> serviceList = new ArrayList<Service>();
        while (serviceIter.hasNext()) {
            Element recordEle = (Element)serviceIter.next();
            Class<?> classType = Class.forName(servernameClass);
            Service service = (Service)classType.newInstance();
            Field[] fields = service.getClass().getFields();
            int i = 0;
            while (i < fields.length) {
                String fieldName = fields[i].getName();
                Element element = recordEle.element(fieldName);
                if (element != null) {
                    fields[i].set(service, element.getText());
                } else {
                    log.info((Object)("XML\u7f3a\u5c11\u53c2\u6570:" + fieldName));
                }
                ++i;
            }
            serviceList.add(service);
        }
        serverbody.setServices(serviceList);
        log.info((Object)"XML >>> OBJ \u5b8c\u6210");
        return params;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><params><safety><clientcode>FK</clientcode><servicecode>ImageCenter</servicecode><time>20141111111111</time><ticket>1234</ticket></safety><serverbody><servername>createImagePath</servername><servertype>1</servertype><createImagePath><service><serviceid>1</serviceid><barcode>HTFFFASDAS</barcode><evaluation>1</evaluation><type>1</type><CanDownPrint>1</CanDownPrint><commentType>1</commentType><imageop>0</imageop><userid>zhangsan</userid><accountdate>2014-01-01</accountdate><showother>1</showother></service><service><serviceid>2</serviceid><barcode>FFFF</barcode><evaluation>1</evaluation><type>1</type><CanDownPrint>1</CanDownPrint><commentType>1</commentType><imageop>0</imageop><userid>zhangsan</userid><accountdate>2014-01-01</accountdate><showother>1</showother><showother2>1</showother2></service></createImagePath></serverbody></params>";
        try {
            Params params = XmlToObj.toObj(xml);
            System.out.println(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

