/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.util.DomHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.views.xslt.AbstractAdapterElement;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.apache.struts2.views.xslt.SimpleTextNode;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class StringAdapter
extends AbstractAdapterElement {
    private Logger log = LogManager.getLogger(this.getClass());
    boolean parseStringAsXML;

    public StringAdapter() {
    }

    public StringAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, String value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    protected String getStringValue() {
        return this.getPropertyValue().toString();
    }

    @Override
    protected List<Node> buildChildAdapters() {
        Node node;
        if (this.getParseStringAsXML()) {
            this.log.debug("parsing string as xml: {}", (Object)this.getStringValue());
            node = DomHelper.parse(new InputSource(new StringReader(this.getStringValue())));
            node = this.getAdapterFactory().proxyNode(this, node);
        } else {
            this.log.debug("using string as is: {}", (Object)this.getStringValue());
            node = new SimpleTextNode(this.getAdapterFactory(), this, "text", this.getStringValue());
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(node);
        return children;
    }

    public boolean getParseStringAsXML() {
        return this.parseStringAsXML;
    }

    public void setParseStringAsXML(boolean parseStringAsXML) {
        this.parseStringAsXML = parseStringAsXML;
    }
}

