/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh;

import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshHost;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshHostDisposedException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SshSessionPool {
    private static final long PURGE_INTERVAL = 10000L;
    private Map myPool = new HashMap();
    private Timer myTimer = new Timer(true);

    public SshSessionPool() {
        this.myTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = SshSessionPool.this.myPool;
                synchronized (map) {
                    ArrayList hosts = new ArrayList(SshSessionPool.this.myPool.values());
                    Iterator hostsIterator = hosts.iterator();
                    while (hostsIterator.hasNext()) {
                        SshHost host = (SshHost)hostsIterator.next();
                        if (host.purge()) {
                            SshSessionPool.this.myPool.remove(host.getKey());
                        }
                        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSH pool, purged: " + host);
                    }
                }
            }
        }, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map map = this.myPool;
        synchronized (map) {
            ArrayList hosts = new ArrayList(this.myPool.values());
            Iterator hostsIterator = hosts.iterator();
            while (hostsIterator.hasNext()) {
                SshHost host = (SshHost)hostsIterator.next();
                try {
                    host.lock();
                    host.setDisposed(true);
                    this.myPool.remove(host.getKey());
                }
                finally {
                    host.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshSession openSession(String host, int port, String userName, char[] privateKey, char[] passphrase, char[] password, ServerHostKeyVerifier verifier, int connectTimeout) throws IOException {
        SshHost sshHost = new SshHost(host, port);
        sshHost.setCredentials(userName, privateKey, passphrase, password);
        sshHost.setConnectionTimeout(connectTimeout);
        sshHost.setHostVerifier(verifier);
        SshSession session = null;
        while (session == null) {
            Map map = this.myPool;
            synchronized (map) {
                if (!this.myPool.containsKey(sshHost.getKey())) {
                    this.myPool.put(sshHost.getKey(), sshHost);
                } else {
                    sshHost = (SshHost)this.myPool.get(sshHost.getKey());
                }
            }
            try {
                session = sshHost.openSession();
                break;
            }
            catch (SshHostDisposedException e) {
            }
        }
        return session;
    }
}

