/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;

public class DefaultSVNHostOptions
implements ISVNHostOptions {
    private final SVNCompositeConfigFile myServersFile;
    private final SVNURL myURL;

    public DefaultSVNHostOptions(SVNCompositeConfigFile serversFile, SVNURL url) {
        this.myServersFile = serversFile;
        this.myURL = url;
    }

    private SVNCompositeConfigFile getServersFile() {
        return this.myServersFile;
    }

    public String getHost() {
        return this.myURL.getHost();
    }

    public String getProtocol() {
        return this.myURL.getProtocol();
    }

    public Collection getAuthTypes() {
        ArrayList<String> schemes = new ArrayList<String>();
        Map hostProperties = this.getHostProperties();
        String authTypes = (String)hostProperties.get("http-auth-types");
        if (authTypes == null || "".equals(authTypes.trim())) {
            return schemes;
        }
        StringTokenizer tokens = new StringTokenizer(authTypes, ";");
        while (tokens.hasMoreTokens()) {
            String scheme = tokens.nextToken();
            if (schemes.contains(scheme)) continue;
            schemes.add(scheme);
        }
        return schemes;
    }

    private String getAuthStorageEnabledOption() {
        Map properties = this.getHostProperties();
        return (String)properties.get("store-auth-creds");
    }

    protected boolean hasAuthStorageEnabledOption() {
        return this.getAuthStorageEnabledOption() != null;
    }

    public boolean isAuthStorageEnabled() {
        String storeAuthCreds = this.getAuthStorageEnabledOption();
        if (storeAuthCreds == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storeAuthCreds) || "on".equalsIgnoreCase(storeAuthCreds) || "true".equalsIgnoreCase(storeAuthCreds);
    }

    public boolean isStorePasswords() {
        boolean store = true;
        Map properties = this.getHostProperties();
        String storePasswords = (String)properties.get("store-passwords");
        if (storePasswords == null) {
            return store;
        }
        return "yes".equalsIgnoreCase(storePasswords) || "on".equalsIgnoreCase(storePasswords) || "true".equalsIgnoreCase(storePasswords);
    }

    private String getStorePlainTextPasswordOption() {
        Map properties = this.getHostProperties();
        return (String)properties.get("store-plaintext-passwords");
    }

    public boolean hasStorePlainTextPasswordsOption() {
        return this.getStorePlainTextPasswordOption() != null;
    }

    public boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
        String storePlainTextPasswords = this.getStorePlainTextPasswordOption();
        if (storePlainTextPasswords == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPasswords) || "on".equalsIgnoreCase(storePlainTextPasswords) || "true".equalsIgnoreCase(storePlainTextPasswords);
    }

    public boolean isStoreSSLClientCertificatePassphrases() {
        Map properties = this.getHostProperties();
        String storeCertPassphrases = (String)properties.get("store-ssl-client-cert-pp");
        if (storeCertPassphrases == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(storeCertPassphrases) || "on".equalsIgnoreCase(storeCertPassphrases) || "true".equalsIgnoreCase(storeCertPassphrases);
    }

    private String getStorePlainTextPassphraseOption() {
        Map properties = this.getHostProperties();
        return (String)properties.get("store-ssl-client-cert-pp-plaintext");
    }

    protected boolean hasStorePlainTextPassphrasesOption() {
        String storePlainTextPassphrases = this.getStorePlainTextPassphraseOption();
        return storePlainTextPassphrases != null;
    }

    public boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
        String storePlainTextPassphrases = this.getStorePlainTextPassphraseOption();
        if (storePlainTextPassphrases == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPassphrases) || "on".equalsIgnoreCase(storePlainTextPassphrases) || "true".equalsIgnoreCase(storePlainTextPassphrases);
    }

    public String getUserName() {
        Map properties = this.getHostProperties();
        String userName = (String)properties.get("username");
        return userName;
    }

    public String getSSLClientCertFile() {
        Map properties = this.getHostProperties();
        return (String)properties.get("ssl-client-cert-file");
    }

    public String getSSLClientCertPassword() {
        Map properties = this.getHostProperties();
        return (String)properties.get("ssl-client-cert-password");
    }

    public boolean trustDefaultSSLCertificateAuthority() {
        Map properties = this.getHostProperties();
        return !"no".equalsIgnoreCase((String)properties.get("ssl-trust-default-ca"));
    }

    public File[] getSSLAuthorityFiles() {
        Map properties = this.getHostProperties();
        String sslAuthorityFilePaths = (String)properties.get("ssl-authority-files");
        ArrayList<File> trustStorages = new ArrayList<File>();
        if (sslAuthorityFilePaths != null) {
            StringTokenizer files = new StringTokenizer(sslAuthorityFilePaths, ";");
            while (files.hasMoreTokens()) {
                String fileName = files.nextToken();
                fileName = fileName == null ? null : fileName.trim();
                if (fileName == null || "".equals(fileName)) continue;
                trustStorages.add(new File(fileName));
            }
        }
        return trustStorages.toArray(new File[trustStorages.size()]);
    }

    public String getProxyHost() {
        return this.getProxyOption("http-proxy-host", "http.proxyHost");
    }

    public String getProxyPort() {
        return this.getProxyOption("http-proxy-port", "http.proxyPort");
    }

    public String getProxyUserName() {
        return this.getProxyOption("http-proxy-username", null);
    }

    public String getProxyPassword() {
        return this.getProxyOption("http-proxy-password", null);
    }

    private String getProxyOption(String optionName, String systemProperty) {
        String host = this.getHost();
        Map properties = this.getHostProperties();
        String value = (String)properties.get(optionName);
        if ((value == null || "".equals(value.trim())) && systemProperty != null) {
            value = System.getProperty(systemProperty);
        }
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        if (DefaultSVNHostOptions.hostExceptedFromProxy(host, properties)) {
            return null;
        }
        return value;
    }

    private static boolean hostExceptedFromProxy(String host, Map properties) {
        String proxyExceptions = (String)properties.get("http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches(exception, host)) continue;
                return true;
            }
        }
        return false;
    }

    public int getReadTimeout() {
        String protocol = this.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            Map properties = this.getHostProperties();
            String timeout = (String)properties.get("http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    public int getConnectTimeout() {
        String protocol = this.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 60000;
        }
        return 0;
    }

    private Map getHostProperties() {
        Map properties = this.getServersFile().getProperties("global");
        String groupName = this.getGroupName(this.getServersFile().getProperties("groups"));
        if (groupName != null) {
            Map hostProps = this.getServersFile().getProperties(groupName);
            properties.putAll(hostProps);
        }
        return properties;
    }

    private String getGroupName(Map groups) {
        Iterator names = groups.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String pattern = (String)groups.get(name);
            StringTokenizer tokens = new StringTokenizer(pattern, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!DefaultSVNOptions.matches(token = token.trim(), this.getHost())) continue;
                return name;
            }
        }
        return null;
    }
}

