/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.ISVNReusableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNRemoteDiffEditor
implements ISVNReusableEditor {
    protected SVNRepository myRepos;
    protected long myRevision1;
    protected long myRevision2;
    protected File myTarget;
    protected SVNAdminArea myAdminArea;
    protected boolean myIsDryRun;
    protected SVNDeltaProcessor myDeltaProcessor;
    protected ISVNEventHandler myEventHandler;
    protected ISVNEventHandler myCancelHandler;
    protected AbstractDiffCallback myDiffCallback;
    protected SVNDirectoryInfo myCurrentDirectory;
    protected SVNFileInfo myCurrentFile;
    protected File myTempDirectory;
    protected Collection myTempFiles;
    protected Map myDeletedPaths;
    private boolean myIsUseGlobalTmp;

    public SVNRemoteDiffEditor(SVNAdminArea adminArea, File target, AbstractDiffCallback callback, SVNRepository repos, long revision1, long revision2, boolean dryRun, ISVNEventHandler handler, ISVNEventHandler cancelHandler) {
        this.myAdminArea = adminArea;
        this.myTarget = target;
        this.myDiffCallback = callback;
        this.myRepos = repos;
        this.myRevision1 = revision1;
        this.myRevision2 = revision2;
        this.myEventHandler = handler;
        this.myCancelHandler = cancelHandler;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myIsDryRun = dryRun;
        this.myDeletedPaths = new SVNHashMap();
    }

    public void reset(long revision1, long revision2) {
        this.myRevision1 = revision1;
        this.myRevision2 = revision2;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myRevision2 = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(null, "", false);
        this.myCurrentDirectory.loadFromRepository(revision);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            return;
        }
        SVNNodeKind nodeKind = this.myRepos.checkPath(path, this.myRevision1);
        SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myWCFile, true);
        this.deleteEntry(path, nodeKind, dir);
    }

    protected void deleteEntry(String path, SVNNodeKind nodeKind, SVNAdminArea dir) throws SVNException {
        SVNStatusType type = SVNStatusType.INAPPLICABLE;
        SVNEventAction action = SVNEventAction.SKIP;
        SVNEventAction expectedAction = SVNEventAction.UPDATE_DELETE;
        boolean[] isTreeConflicted = new boolean[]{false};
        if (this.myAdminArea == null || dir != null) {
            if (nodeKind == SVNNodeKind.FILE) {
                SVNFileInfo file = new SVNFileInfo(path, false);
                file.loadFromRepository(this.myRevision1);
                String baseType = file.myBaseProperties.getStringValue("svn:mime-type");
                type = this.getDiffCallback().fileDeleted(path, file.myBaseFile, null, baseType, null, file.myBaseProperties, isTreeConflicted);
            } else if (nodeKind == SVNNodeKind.DIR) {
                type = this.getDiffCallback().directoryDeleted(path, isTreeConflicted);
            }
            if (type != SVNStatusType.MISSING && type != SVNStatusType.OBSTRUCTED && !isTreeConflicted[0]) {
                action = SVNEventAction.UPDATE_DELETE;
                if (this.myIsDryRun) {
                    this.getDiffCallback().addDeletedPath(path);
                }
            }
        }
        action = isTreeConflicted[0] ? SVNEventAction.TREE_CONFLICT : action;
        this.addDeletedPath(path, nodeKind, type, action, expectedAction, isTreeConflicted[0]);
    }

    protected void addDeletedPath(String path, SVNNodeKind nodeKind, SVNStatusType type, SVNEventAction action, SVNEventAction expectedAction, boolean isTreeConflicted) {
        if (this.myEventHandler != null) {
            File deletedFile = new File(this.myTarget, path);
            KindActionState kas = new KindActionState();
            kas.myAction = action;
            kas.myKind = nodeKind;
            kas.myStatus = type;
            kas.myExpectedAction = expectedAction;
            kas.myIsTreeConflicted = isTreeConflicted;
            this.myDeletedPaths.put(deletedFile, kas);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNDirectoryInfo parentDir = this.myCurrentDirectory;
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myBaseProperties = new SVNProperties();
        if (parentDir.myIsSkip || parentDir.myIsTreeConflicted) {
            this.myCurrentDirectory.myIsSkip = true;
            return;
        }
        boolean[] isTreeConflicted = new boolean[]{false};
        SVNStatusType type = this.getDiffCallback().directoryAdded(path, this.myRevision2, isTreeConflicted);
        this.myCurrentDirectory.myIsTreeConflicted = isTreeConflicted[0];
        if (this.myEventHandler != null) {
            SVNEventAction action = SVNEventAction.UPDATE_ADD;
            SVNNodeKind kind = SVNNodeKind.DIR;
            KindActionState kas = (KindActionState)this.myDeletedPaths.get(this.myCurrentDirectory.myWCFile);
            if (kas != null) {
                kind = kas.myKind;
                type = kas.myStatus;
                this.myDeletedPaths.remove(this.myCurrentDirectory.myWCFile);
            }
            if (this.myCurrentDirectory.myIsTreeConflicted) {
                action = SVNEventAction.TREE_CONFLICT;
            } else if (kas != null) {
                action = kas.myAction == SVNEventAction.UPDATE_DELETE ? SVNEventAction.UPDATE_REPLACE : kas.myAction;
            } else if (type == SVNStatusType.MISSING || type == SVNStatusType.OBSTRUCTED) {
                action = SVNEventAction.SKIP;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, kind, null, -1L, type, type, null, action, SVNEventAction.UPDATE_ADD, null, null);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        SVNDirectoryInfo parentDir = this.myCurrentDirectory;
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, false);
        if (parentDir.myIsSkip || parentDir.myIsTreeConflicted) {
            this.myCurrentDirectory.myIsSkip = true;
            return;
        }
        this.myCurrentDirectory.loadFromRepository(revision);
        boolean[] isTreeConflicted = new boolean[]{false};
        this.getDiffCallback().directoryOpened(path, revision, isTreeConflicted);
        this.myCurrentDirectory.myIsTreeConflicted = isTreeConflicted[0];
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirectory.myIsSkip) {
            return;
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        SVNEventAction expectedAction;
        if (this.myCurrentDirectory.myIsSkip) {
            this.myCurrentDirectory = this.myCurrentDirectory.myParent;
            return;
        }
        SVNStatusType type = SVNStatusType.UNKNOWN;
        SVNEventAction action = expectedAction = SVNEventAction.UPDATE_UPDATE;
        if (this.myIsDryRun) {
            this.getDiffCallback().clearDeletedPaths();
        }
        SVNAdminArea dir = null;
        if (!this.myCurrentDirectory.myPropertyDiff.isEmpty()) {
            try {
                dir = this.retrieve(this.myCurrentDirectory.myWCFile, this.myIsDryRun);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    if (!this.myCurrentDirectory.myIsAdded && this.myEventHandler != null) {
                        action = this.myCurrentDirectory.myIsTreeConflicted ? SVNEventAction.TREE_CONFLICT : SVNEventAction.SKIP;
                        SVNEvent event = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, null, action, expectedAction, null, null);
                        this.myEventHandler.handleEvent(event, -1.0);
                    }
                    this.myCurrentDirectory = this.myCurrentDirectory.myParent;
                    return;
                }
                throw e;
            }
            if (!this.myIsDryRun || dir != null) {
                boolean[] isTreeConflicted = new boolean[]{false};
                type = this.getDiffCallback().propertiesChanged(this.myCurrentDirectory.myRepositoryPath, this.myCurrentDirectory.myBaseProperties, this.myCurrentDirectory.myPropertyDiff, isTreeConflicted);
                if (isTreeConflicted[0]) {
                    this.myCurrentDirectory.myIsTreeConflicted = true;
                }
            }
        }
        this.getDiffCallback().directoryClosed(this.myCurrentDirectory.myRepositoryPath, null);
        if (type == SVNStatusType.UNKNOWN) {
            action = SVNEventAction.UPDATE_NONE;
        }
        if (!this.myCurrentDirectory.myIsAdded && this.myEventHandler != null) {
            Iterator deletedPathsIter = this.myDeletedPaths.keySet().iterator();
            while (deletedPathsIter.hasNext()) {
                File deletedPath = (File)deletedPathsIter.next();
                KindActionState kas = (KindActionState)this.myDeletedPaths.get(deletedPath);
                SVNEvent event = SVNEventFactory.createSVNEvent(deletedPath, kas.myKind, null, -1L, kas.myStatus, kas.myStatus, SVNStatusType.INAPPLICABLE, kas.myAction, kas.myExpectedAction, null, null);
                this.myEventHandler.handleEvent(event, -1.0);
                deletedPathsIter.remove();
            }
            action = this.myCurrentDirectory.myIsTreeConflicted ? SVNEventAction.TREE_CONFLICT : action;
            SVNEvent event = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, SVNNodeKind.DIR, null, -1L, SVNStatusType.INAPPLICABLE, type, SVNStatusType.INAPPLICABLE, action, expectedAction, null, null);
            this.myEventHandler.handleEvent(event, -1.0);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(path, true);
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            this.myCurrentFile.myIsSkip = true;
            return;
        }
        this.myCurrentFile.myBaseProperties = new SVNProperties();
        this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", this.myIsUseGlobalTmp);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(path, false);
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            this.myCurrentFile.myIsSkip = true;
            return;
        }
        this.myCurrentFile.loadFromRepository(revision);
    }

    public void changeFileProperty(String commitPath, String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        SVNAdminArea dir = null;
        try {
            dir = this.retrieveParent(this.myCurrentFile.myWCFile, true);
        }
        catch (SVNException e) {
            dir = null;
        }
        this.myCurrentFile.myFile = this.createTempFile(dir, SVNPathUtil.tail(commitPath));
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFile.myIsSkip) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        boolean[] isTreeConflicted = new boolean[]{false};
        this.closeFile(commitPath, this.myCurrentFile.myIsAdded, this.myCurrentFile.myWCFile, this.myCurrentFile.myFile, this.myCurrentFile.myPropertyDiff, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myBaseFile, isTreeConflicted);
        this.myCurrentFile.myIsTreeConflicted = isTreeConflicted[0];
    }

    protected void closeFile(String commitPath, boolean added, File wcFile, File file, SVNProperties propertyDiff, SVNProperties baseProperties, File baseFile, boolean[] isTreeConflicted) throws SVNException {
        SVNEventAction expectedAction = added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        SVNStatusType[] type = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
        try {
            this.retrieveParent(wcFile, this.myIsDryRun);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                if (this.myEventHandler != null) {
                    SVNEvent event = SVNEventFactory.createSVNEvent(wcFile, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.UNKNOWN, null, SVNEventAction.SKIP, expectedAction, null, null);
                    this.myEventHandler.handleEvent(event, -1.0);
                }
                return;
            }
            throw e;
        }
        if (file != null || !propertyDiff.isEmpty()) {
            String baseMimeType = baseProperties.getStringValue("svn:mime-type");
            String mimeType = propertyDiff.getStringValue("svn:mime-type");
            type = added ? this.getDiffCallback().fileAdded(commitPath, file != null ? baseFile : null, file, 0L, this.myRevision2, baseMimeType, mimeType, baseProperties, propertyDiff, isTreeConflicted) : this.getDiffCallback().fileChanged(commitPath, file != null ? baseFile : null, file, this.myRevision1, this.myRevision2, baseMimeType, mimeType, baseProperties, propertyDiff, isTreeConflicted);
        }
        if (this.myEventHandler != null) {
            SVNNodeKind kind = SVNNodeKind.FILE;
            KindActionState kas = (KindActionState)this.myDeletedPaths.get(wcFile);
            if (kas != null) {
                this.myDeletedPaths.remove(wcFile);
                kind = kas.myKind;
                type[0] = type[1] = kas.myStatus;
            }
            SVNEventAction action = isTreeConflicted != null && isTreeConflicted.length > 0 && isTreeConflicted[0] ? SVNEventAction.TREE_CONFLICT : (kas != null ? (kas.myAction == SVNEventAction.UPDATE_DELETE && added ? SVNEventAction.UPDATE_REPLACE : kas.myAction) : (type[0] == SVNStatusType.MISSING || type[0] == SVNStatusType.OBSTRUCTED ? SVNEventAction.SKIP : (added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE)));
            SVNEvent event = SVNEventFactory.createSVNEvent(wcFile, kind, null, -1L, type[0], type[1], null, action, expectedAction, null, null);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
        if (this.myCurrentDirectory.myWCFile != null) {
            File dir = new File(this.myCurrentDirectory.myWCFile, SVNPathUtil.tail(path));
            SVNEvent event = SVNEventFactory.createSVNEvent(dir, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNEventAction.SKIP, SVNEventAction.SKIP, null, null);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public void absentFile(String path) throws SVNException {
        if (this.myCurrentDirectory.myWCFile != null) {
            File file = new File(this.myCurrentDirectory.myWCFile, SVNPathUtil.tail(path));
            SVNEvent event = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNEventAction.SKIP, SVNEventAction.SKIP, null, null);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public void cleanup() throws SVNException {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
            this.myTempDirectory = null;
        }
        if (this.myTempFiles != null) {
            Iterator files = this.myTempFiles.iterator();
            while (files.hasNext()) {
                SVNFileUtil.deleteFile((File)files.next());
            }
        }
    }

    protected SVNAdminArea retrieve(File path, boolean lenient) throws SVNException {
        if (this.myAdminArea == null) {
            return null;
        }
        try {
            return this.myAdminArea.getWCAccess().retrieve(path);
        }
        catch (SVNException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected SVNAdminArea retrieveParent(File path, boolean lenient) throws SVNException {
        if (this.myAdminArea == null) {
            return null;
        }
        return this.retrieve(path.getParentFile(), lenient);
    }

    protected AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    protected File getTempDirectory() throws SVNException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    protected File createTempFile(SVNAdminArea dir, String name) throws SVNException {
        if (dir != null && dir.isLocked()) {
            File tmpFile = dir.getBaseFile(name, true);
            if (this.myTempFiles == null) {
                this.myTempFiles = new SVNHashSet();
            }
            this.myTempFiles.add(tmpFile);
            return tmpFile;
        }
        return SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", this.myIsUseGlobalTmp);
    }

    protected SVNFileInfo createFileInfo(String path, boolean added) {
        return new SVNFileInfo(path, added);
    }

    protected void setIsConflicted(boolean[] isConflictedResult, boolean isConflicted) {
        if (isConflictedResult != null && isConflictedResult.length > 0) {
            isConflictedResult[0] = isConflicted;
        }
    }

    public void setUseGlobalTmp(boolean global) {
        this.myIsUseGlobalTmp = global;
    }

    protected class KindActionState {
        protected SVNNodeKind myKind;
        protected SVNEventAction myAction;
        protected SVNEventAction myExpectedAction;
        protected SVNStatusType myStatus;
        protected boolean myIsTreeConflicted;

        protected KindActionState() {
        }
    }

    protected class SVNFileInfo {
        protected String myRepositoryPath;
        protected File myWCFile;
        protected boolean myIsAdded;
        protected boolean myIsSkip;
        protected boolean myIsTreeConflicted;
        protected File myFile;
        protected File myBaseFile;
        protected SVNProperties myBaseProperties;
        protected SVNProperties myPropertyDiff;

        public SVNFileInfo(String path, boolean added) {
            this.myRepositoryPath = path;
            this.myIsAdded = added;
            this.myWCFile = SVNRemoteDiffEditor.this.myTarget != null ? new File(SVNRemoteDiffEditor.this.myTarget, path) : null;
            this.myPropertyDiff = new SVNProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFromRepository(long revision) throws SVNException {
            this.myBaseFile = SVNFileUtil.createUniqueFile(SVNRemoteDiffEditor.this.getTempDirectory(), ".diff", ".tmp", SVNRemoteDiffEditor.this.myIsUseGlobalTmp);
            OutputStream os = null;
            this.myBaseProperties = new SVNProperties();
            try {
                os = SVNFileUtil.openFileForWriting(this.myBaseFile);
                SVNRemoteDiffEditor.this.myRepos.getFile(this.myRepositoryPath, revision, this.myBaseProperties, new SVNCancellableOutputStream(os, SVNRemoteDiffEditor.this.myCancelHandler));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
        }
    }

    protected class SVNDirectoryInfo {
        protected boolean myIsAdded;
        protected boolean myIsSkip;
        protected boolean myIsTreeConflicted;
        protected String myRepositoryPath;
        protected File myWCFile;
        protected SVNProperties myBaseProperties;
        protected SVNProperties myPropertyDiff;
        protected SVNDirectoryInfo myParent;

        public SVNDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
            this.myParent = parent;
            this.myRepositoryPath = path;
            this.myWCFile = SVNRemoteDiffEditor.this.myTarget != null ? new File(SVNRemoteDiffEditor.this.myTarget, path) : null;
            this.myIsAdded = added;
            this.myPropertyDiff = new SVNProperties();
        }

        public void loadFromRepository(long baseRevision) throws SVNException {
            this.myBaseProperties = new SVNProperties();
            SVNRemoteDiffEditor.this.myRepos.getDir(this.myRepositoryPath, baseRevision, this.myBaseProperties, (ISVNDirEntryHandler)null);
        }
    }
}

