/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNNotifyPrinter
implements ISVNEventHandler {
    private SVNCommandEnvironment myEnvironment;
    private boolean myIsInExternal;
    private boolean myIsChangesReceived;
    private boolean myIsDeltaSent;
    private boolean myIsCheckout;
    private boolean myIsExport;
    private boolean myIsSuppressLastLine;
    private int myTextConflicts = 0;
    private int myPropConflicts = 0;
    private int myTreeConflicts = 0;
    private int mySkippedPaths = 0;
    private int myExternalTextConflicts = 0;
    private int myExternalPropConflicts = 0;
    private int myExternalTreeConflicts = 0;
    private int myExternalSkippedPaths = 0;
    private boolean myHasLockingError;

    public SVNNotifyPrinter(SVNCommandEnvironment env) {
        this(env, false, false, false);
    }

    public SVNNotifyPrinter(SVNCommandEnvironment env, boolean isCheckout, boolean isExport, boolean suppressLastLine) {
        this.myEnvironment = env;
        this.myIsCheckout = isCheckout;
        this.myIsExport = isExport;
        this.myIsSuppressLastLine = suppressLastLine;
    }

    public boolean hasLockingErrors() {
        return this.myHasLockingError;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        File file = event.getFile();
        String path = null;
        if (file != null) {
            path = this.myEnvironment.getRelativePath(file);
            path = SVNCommandUtil.getLocalPath(path);
        }
        PrintStream out = this.myEnvironment.getOut();
        StringBuffer buffer = new StringBuffer();
        if (event.getAction() == SVNEventAction.STATUS_EXTERNAL) {
            buffer.append("\nPerforming status on external item at '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.STATUS_COMPLETED) {
            String revStr = Long.toString(event.getRevision());
            buffer.append("Status against revision: " + SVNFormatUtil.formatString((String)revStr, (int)6, (boolean)false) + "\n");
        } else if (event.getAction() == SVNEventAction.SKIP) {
            if (event.getErrorMessage() != null && event.getExpectedAction() == SVNEventAction.UPDATE_EXTERNAL) {
                this.myEnvironment.getErr().println(event.getErrorMessage());
            }
            if (this.myIsInExternal) {
                ++this.myExternalSkippedPaths;
            } else {
                ++this.mySkippedPaths;
            }
            if (event.getContentsStatus() == SVNStatusType.MISSING) {
                buffer.append("Skipped missing target: '" + path + "'\n");
            } else {
                buffer.append("Skipped '" + path + "'\n");
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_DELETE) {
            this.myIsChangesReceived = true;
            buffer.append("D    " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_REPLACE) {
            this.myIsChangesReceived = true;
            buffer.append("R    " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_ADD) {
            this.myIsChangesReceived = true;
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                if (this.myIsInExternal) {
                    ++this.myExternalTextConflicts;
                } else {
                    ++this.myTextConflicts;
                }
                buffer.append("C    " + path + "\n");
            } else {
                buffer.append("A    " + path + "\n");
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_EXISTS) {
            this.myIsChangesReceived = true;
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                if (this.myIsInExternal) {
                    ++this.myExternalTextConflicts;
                } else {
                    ++this.myTextConflicts;
                }
                buffer.append('C');
            } else {
                buffer.append('E');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                if (this.myIsInExternal) {
                    ++this.myExternalPropConflicts;
                } else {
                    ++this.myPropConflicts;
                }
                buffer.append('C');
            } else if (event.getPropertiesStatus() == SVNStatusType.MERGED) {
                buffer.append('G');
            } else {
                buffer.append(' ');
            }
            buffer.append("   " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_UPDATE) {
            SVNStatusType propStatus = event.getPropertiesStatus();
            if (event.getNodeKind() == SVNNodeKind.DIR && (propStatus == SVNStatusType.INAPPLICABLE || propStatus == SVNStatusType.UNKNOWN || propStatus == SVNStatusType.UNCHANGED)) {
                return;
            }
            if (event.getNodeKind() == SVNNodeKind.FILE) {
                if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                    if (this.myIsInExternal) {
                        ++this.myExternalTextConflicts;
                    } else {
                        ++this.myTextConflicts;
                    }
                    buffer.append('C');
                } else if (event.getContentsStatus() == SVNStatusType.MERGED) {
                    buffer.append('G');
                } else if (event.getContentsStatus() == SVNStatusType.CHANGED) {
                    buffer.append('U');
                } else {
                    buffer.append(' ');
                }
            } else {
                buffer.append(' ');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                if (this.myIsInExternal) {
                    ++this.myExternalPropConflicts;
                } else {
                    ++this.myPropConflicts;
                }
                buffer.append('C');
            } else if (event.getPropertiesStatus() == SVNStatusType.MERGED) {
                buffer.append('G');
            } else if (event.getPropertiesStatus() == SVNStatusType.CHANGED) {
                buffer.append('U');
            } else {
                buffer.append(' ');
            }
            if (buffer.toString().trim().length() > 0) {
                this.myIsChangesReceived = true;
            }
            if (event.getLockStatus() == SVNStatusType.LOCK_UNLOCKED) {
                buffer.append('B');
            } else {
                buffer.append(' ');
            }
            if (buffer.toString().trim().length() == 0) {
                return;
            }
            buffer.append("  " + path + "\n");
        } else if (event.getAction() == SVNEventAction.MERGE_BEGIN) {
            SVNMergeRange range = event.getMergeRange();
            if (range == null) {
                buffer.append("--- Merging differences between repository URLs into '" + path + "':\n");
            } else {
                long end;
                long start = range.getStartRevision();
                if (start == (end = range.getEndRevision()) || start == end - 1L) {
                    buffer.append("--- Merging r" + end + " into '" + path + "':\n");
                } else if (start - 1L == end) {
                    buffer.append("--- Reverse-merging r" + start + " into '" + path + "':\n");
                } else if (start < end) {
                    buffer.append("--- Merging r" + (start + 1L) + " through r" + end + " into '" + path + "':\n");
                } else {
                    buffer.append("--- Reverse-merging r" + start + " through r" + (end + 1L) + " into '" + path + "':\n");
                }
            }
        } else if (event.getAction() == SVNEventAction.FOREIGN_MERGE_BEGIN) {
            SVNMergeRange range = event.getMergeRange();
            if (range == null) {
                buffer.append("--- Merging differences between foreign repository URLs into '" + path + "':\n");
            } else {
                long end;
                long start = range.getStartRevision();
                if (start == (end = range.getEndRevision()) || start == end - 1L) {
                    buffer.append("--- Merging (from foreign repository) r" + end + " into '" + path + "':\n");
                } else if (start - 1L == end) {
                    buffer.append("--- Reverse-merging (from foreign repository) r" + start + " into '" + path + "':\n");
                } else if (start < end) {
                    buffer.append("--- Merging (from foreign repository) r" + (start + 1L) + " through r" + end + " into '" + path + "':\n");
                } else {
                    buffer.append("--- Reverse-merging (from foreign repository) r" + start + " through r" + (end + 1L) + " into '" + path + "':\n");
                }
            }
        } else if (event.getAction() == SVNEventAction.TREE_CONFLICT) {
            if (this.myIsInExternal) {
                ++this.myExternalTreeConflicts;
            } else {
                ++this.myTreeConflicts;
            }
            buffer.append("   C ");
            buffer.append(path);
            buffer.append("\n");
        } else if (event.getAction() == SVNEventAction.RESTORE) {
            buffer.append("Restored '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.RESTORE) {
            buffer.append("Restored '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL) {
            this.myIsInExternal = true;
            buffer.append("\nFetching external item into '" + path + "'\n");
        } else {
            if (event.getAction() == SVNEventAction.FAILED_EXTERNAL) {
                if (this.myIsInExternal) {
                    this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                    this.myIsInExternal = false;
                    this.myExternalPropConflicts = 0;
                    this.myExternalSkippedPaths = 0;
                    this.myExternalTextConflicts = 0;
                    this.myExternalTreeConflicts = 0;
                    return;
                }
                SVNErrorMessage warnMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.BASE, (String)"Error handling externals definition for ''{0}'':", (Object)path);
                this.myEnvironment.handleWarning(warnMessage, new SVNErrorCode[]{warnMessage.getErrorCode()}, this.myEnvironment.isQuiet());
                this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                return;
            }
            if (event.getAction() == SVNEventAction.UPDATE_COMPLETED) {
                if (!this.myIsSuppressLastLine) {
                    long rev = event.getRevision();
                    if (rev >= 0L) {
                        if (this.myIsExport) {
                            buffer.append(this.myIsInExternal ? "Exported external at revision " + rev + ".\n" : "Exported revision " + rev + ".\n");
                        } else if (this.myIsCheckout) {
                            buffer.append(this.myIsInExternal ? "Checked out external at revision " + rev + ".\n" : "Checked out revision " + rev + ".\n");
                        } else if (this.myIsChangesReceived) {
                            buffer.append(this.myIsInExternal ? "Updated external to revision " + rev + ".\n" : "Updated to revision " + rev + ".\n");
                        } else {
                            buffer.append(this.myIsInExternal ? "External at revision " + rev + ".\n" : "At revision " + rev + ".\n");
                        }
                    } else if (this.myIsExport) {
                        buffer.append(this.myIsInExternal ? "External export complete.\n" : "Export complete.\n");
                    } else if (this.myIsCheckout) {
                        buffer.append(this.myIsInExternal ? "External checkout complete.\n" : "Checkout complete.\n");
                    } else {
                        buffer.append(this.myIsInExternal ? "External update complete.\n" : "Update complete.\n");
                    }
                }
                this.printConflictStatus(buffer);
                if (this.myIsInExternal) {
                    buffer.append('\n');
                    this.myIsInExternal = false;
                    this.myExternalPropConflicts = 0;
                    this.myExternalSkippedPaths = 0;
                    this.myExternalTextConflicts = 0;
                    this.myExternalTreeConflicts = 0;
                } else {
                    this.myPropConflicts = 0;
                    this.mySkippedPaths = 0;
                    this.myTextConflicts = 0;
                    this.myTreeConflicts = 0;
                }
            } else if (event.getAction() == SVNEventAction.MERGE_COMPLETE) {
                this.printConflictStatus(buffer);
                this.myTextConflicts = 0;
                this.myPropConflicts = 0;
                this.myTreeConflicts = 0;
                this.mySkippedPaths = 0;
            } else if (event.getAction() == SVNEventAction.COMMIT_MODIFIED) {
                buffer.append("Sending        " + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
                if (SVNProperty.isBinaryMimeType((String)event.getMimeType())) {
                    buffer.append("Adding  (bin)  " + path + "\n");
                } else {
                    buffer.append("Adding         " + path + "\n");
                }
            } else if (event.getAction() == SVNEventAction.COMMIT_DELETED) {
                buffer.append("Deleting       " + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_REPLACED) {
                buffer.append("Replacing      " + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
                if (!this.myIsDeltaSent) {
                    this.myIsDeltaSent = true;
                    buffer.append("Transmitting file data ");
                }
                buffer.append('.');
            } else if (event.getAction() == SVNEventAction.ADD) {
                if (SVNProperty.isBinaryMimeType((String)event.getMimeType())) {
                    buffer.append("A  (bin)  " + path + "\n");
                } else {
                    buffer.append("A         " + path + "\n");
                }
            } else if (event.getAction() == SVNEventAction.DELETE) {
                buffer.append("D         " + path + "\n");
            } else if (event.getAction() == SVNEventAction.REVERT) {
                buffer.append("Reverted '" + path + "'\n");
            } else if (event.getAction() == SVNEventAction.FAILED_REVERT) {
                buffer.append("Failed to revert '" + path + "' -- try updating instead.\n");
            } else if (event.getAction() == SVNEventAction.LOCKED) {
                buffer.append("'" + path + "' locked by user '" + event.getLock().getOwner() + "'.\n");
            } else if (event.getAction() == SVNEventAction.UNLOCKED) {
                buffer.append("'" + path + "' unlocked.\n");
            } else {
                if (event.getAction() == SVNEventAction.LOCK_FAILED || event.getAction() == SVNEventAction.UNLOCK_FAILED) {
                    this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                    this.myHasLockingError = true;
                    return;
                }
                if (event.getAction() == SVNEventAction.RESOLVED) {
                    buffer.append("Resolved conflicted state of '" + path + "'\n");
                } else if (event.getAction() == SVNEventAction.CHANGELIST_SET) {
                    buffer.append("Path '" + path + "' is now a member of changelist '" + event.getChangelistName() + "'.\n");
                } else if (event.getAction() == SVNEventAction.CHANGELIST_CLEAR) {
                    buffer.append("Path '" + path + "' is no longer a member of a changelist.\n");
                } else if (event.getAction() == SVNEventAction.CHANGELIST_MOVED) {
                    this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                    return;
                }
            }
        }
        if (buffer.length() > 0) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.CLIENT, buffer.toString());
            out.print(buffer);
        }
    }

    public void checkCancelled() throws SVNCancelException {
        this.myEnvironment.checkCancelled();
    }

    private void printConflictStatus(StringBuffer buffer) {
        int textConflicts = 0;
        int propConflicts = 0;
        int treeConflicts = 0;
        int skippedPaths = 0;
        String header = null;
        if (this.myIsInExternal) {
            header = "Summary of conflicts in external item:\n";
            textConflicts = this.myExternalTextConflicts;
            propConflicts = this.myExternalPropConflicts;
            treeConflicts = this.myExternalTreeConflicts;
            skippedPaths = this.myExternalSkippedPaths;
        } else {
            header = "Summary of conflicts:\n";
            textConflicts = this.myTextConflicts;
            propConflicts = this.myPropConflicts;
            treeConflicts = this.myTreeConflicts;
            skippedPaths = this.mySkippedPaths;
        }
        if (textConflicts > 0 || propConflicts > 0 || treeConflicts > 0 || skippedPaths > 0) {
            buffer.append(header);
        }
        if (textConflicts > 0) {
            buffer.append("  Text conflicts: ");
            buffer.append(textConflicts);
            buffer.append("\n");
        }
        if (propConflicts > 0) {
            buffer.append("  Property conflicts: ");
            buffer.append(propConflicts);
            buffer.append("\n");
        }
        if (treeConflicts > 0) {
            buffer.append("  Tree conflicts: ");
            buffer.append(treeConflicts);
            buffer.append("\n");
        }
        if (skippedPaths > 0) {
            buffer.append("  Skipped paths: ");
            buffer.append(skippedPaths);
            buffer.append("\n");
        }
    }
}

