/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNStatusPrinter;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNStatusCommand
extends SVNXMLCommand
implements ISVNStatusHandler {
    private SVNStatusPrinter myStatusPrinter;
    private Map myStatusCache;

    public SVNStatusCommand() {
        super("status", new String[]{"stat", "st"});
    }

    protected Collection createSupportedOptions() {
        ArrayList<SVNOption> options = new ArrayList<SVNOption>();
        options.add(SVNOption.UPDATE);
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NO_IGNORE);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        List<String> targets = new ArrayList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        this.myStatusPrinter = new SVNStatusPrinter(this.getSVNEnvironment());
        SVNStatusClient client = this.getSVNEnvironment().getClientManager().getStatusClient();
        if (!this.getSVNEnvironment().isXML()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if (this.getSVNEnvironment().isXML()) {
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("status");
            }
        } else if (this.getSVNEnvironment().isIncremental()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'incremental' option only valid in XML mode");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
        Iterator ts = targets.iterator();
        while (ts.hasNext()) {
            String target = (String)ts.next();
            SVNPath commandTarget = new SVNPath(target);
            if (this.getSVNEnvironment().isXML()) {
                StringBuffer xmlBuffer = this.openXMLTag("target", 1, "path", SVNCommandUtil.getLocalPath(target), null);
                this.getSVNEnvironment().getOut().print(xmlBuffer);
            }
            try {
                long rev = client.doStatus(commandTarget.getFile(), SVNRevision.HEAD, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isUpdate(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isNoIgnore(), false, (ISVNStatusHandler)this, changeLists);
                if (!this.getSVNEnvironment().isXML()) continue;
                StringBuffer xmlBuffer = new StringBuffer();
                if (rev >= 0L) {
                    xmlBuffer = this.openXMLTag("against", 4, "revision", Long.toString(rev), xmlBuffer);
                }
                xmlBuffer = this.closeXMLTag("target", xmlBuffer);
                this.getSVNEnvironment().getOut().print(xmlBuffer);
            }
            catch (SVNException e) {
                this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.WC_NOT_DIRECTORY}, this.getSVNEnvironment().isQuiet());
            }
        }
        if (this.myStatusCache != null) {
            Iterator changelists = this.myStatusCache.keySet().iterator();
            while (changelists.hasNext()) {
                String changelist = (String)changelists.next();
                Map statuses = (Map)this.myStatusCache.get(changelist);
                this.getSVNEnvironment().getOut().println("\n--- Changelist '" + changelist + "':");
                Iterator paths = statuses.keySet().iterator();
                while (paths.hasNext()) {
                    String path = (String)paths.next();
                    SVNStatus status = (SVNStatus)statuses.get(path);
                    this.myStatusPrinter.printStatus(path, status, this.getSVNEnvironment().isVerbose() || this.getSVNEnvironment().isUpdate(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isQuiet(), this.getSVNEnvironment().isUpdate());
                }
            }
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("status");
        }
    }

    public void handleStatus(SVNStatus status) throws SVNException {
        String path = this.getSVNEnvironment().getRelativePath(status.getFile());
        path = SVNCommandUtil.getLocalPath(path);
        if (status != null && status.getChangelistName() != null) {
            if (this.myStatusCache == null) {
                this.myStatusCache = new TreeMap();
            }
            if (!this.myStatusCache.containsKey(status.getChangelistName())) {
                this.myStatusCache.put(status.getChangelistName(), new LinkedHashMap());
            }
            ((Map)this.myStatusCache.get(status.getChangelistName())).put(path, status);
            return;
        }
        if (this.getSVNEnvironment().isXML()) {
            if (status.getContentsStatus() == SVNStatusType.STATUS_NONE && status.getRemoteContentsStatus() == SVNStatusType.STATUS_NONE) {
                return;
            }
            StringBuffer xmlBuffer = this.printXMLStatus(status, path);
            this.getSVNEnvironment().getOut().print(xmlBuffer);
        } else {
            this.myStatusPrinter.printStatus(path, status, this.getSVNEnvironment().isVerbose() || this.getSVNEnvironment().isUpdate(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isQuiet(), this.getSVNEnvironment().isUpdate());
        }
    }

    protected StringBuffer printXMLStatus(SVNStatus status, String path) {
        StringBuffer xmlBuffer = this.openXMLTag("entry", 1, "path", path, null);
        LinkedHashMap<String, String> xmlMap = new LinkedHashMap<String, String>();
        xmlMap.put("props", status.getPropertiesStatus().toString());
        xmlMap.put("item", status.getContentsStatus().toString());
        if (status.isLocked()) {
            xmlMap.put("wc-locked", "true");
        }
        if (status.isCopied()) {
            xmlMap.put("copied", "true");
        }
        if (status.isSwitched()) {
            xmlMap.put("switched", "true");
        }
        if (status.isFileExternal()) {
            xmlMap.put("file-external", "true");
        }
        if (status.getEntry() != null && !status.isCopied()) {
            xmlMap.put("revision", status.getRevision().toString());
        }
        if (status.getTreeConflict() != null) {
            xmlMap.put("tree-conflicted", "true");
        }
        xmlBuffer = this.openXMLTag("wc-status", 1, xmlMap, xmlBuffer);
        if (status.getEntry() != null && status.getCommittedRevision().isValid()) {
            xmlBuffer = this.openXMLTag("commit", 1, "revision", status.getCommittedRevision().toString(), xmlBuffer);
            xmlBuffer = this.openCDataTag("author", status.getAuthor(), xmlBuffer);
            if (status.getCommittedDate() != null) {
                xmlBuffer = this.openCDataTag("date", ((SVNDate)status.getCommittedDate()).format(), xmlBuffer);
            }
            xmlBuffer = this.closeXMLTag("commit", xmlBuffer);
        }
        if (status.getEntry() != null && status.getLocalLock() != null) {
            xmlBuffer = this.openXMLTag("lock", 1, null, xmlBuffer);
            xmlBuffer = this.openCDataTag("token", status.getLocalLock().getID(), xmlBuffer);
            xmlBuffer = this.openCDataTag("owner", status.getLocalLock().getOwner(), xmlBuffer);
            xmlBuffer = this.openCDataTag("comment", status.getLocalLock().getComment(), xmlBuffer);
            xmlBuffer = this.openCDataTag("created", ((SVNDate)status.getLocalLock().getCreationDate()).format(), xmlBuffer);
            xmlBuffer = this.closeXMLTag("lock", xmlBuffer);
        }
        xmlBuffer = this.closeXMLTag("wc-status", xmlBuffer);
        if (status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE || status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteLock() != null) {
            xmlMap.put("props", status.getRemotePropertiesStatus().toString());
            xmlMap.put("item", status.getRemoteContentsStatus().toString());
            xmlBuffer = this.openXMLTag("repos-status", 1, xmlMap, xmlBuffer);
            if (status.getRemoteLock() != null) {
                xmlBuffer = this.openXMLTag("lock", 1, null, xmlBuffer);
                xmlBuffer = this.openCDataTag("token", status.getRemoteLock().getID(), xmlBuffer);
                xmlBuffer = this.openCDataTag("owner", status.getRemoteLock().getOwner(), xmlBuffer);
                xmlBuffer = this.openCDataTag("comment", status.getRemoteLock().getComment(), xmlBuffer);
                xmlBuffer = this.openCDataTag("created", ((SVNDate)status.getRemoteLock().getCreationDate()).format(), xmlBuffer);
                if (status.getRemoteLock().getExpirationDate() != null) {
                    xmlBuffer = this.openCDataTag("expires", ((SVNDate)status.getRemoteLock().getExpirationDate()).format(), xmlBuffer);
                }
                xmlBuffer = this.closeXMLTag("lock", xmlBuffer);
            }
            xmlBuffer = this.closeXMLTag("repos-status", xmlBuffer);
        }
        xmlBuffer = this.closeXMLTag("entry", xmlBuffer);
        return xmlBuffer;
    }
}

