/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.wc.SVNPropertyData;

public abstract class SVNXMLCommand
extends SVNCommand {
    protected SVNXMLCommand(String name, String[] aliases) {
        super(name, aliases);
    }

    protected void printXMLHeader(String header) {
        StringBuffer xmlBuffer = new StringBuffer();
        SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer, (boolean)false);
        SVNXMLUtil.openXMLTag(null, (String)header, (int)1, null, (StringBuffer)xmlBuffer);
        this.getSVNEnvironment().getOut().print(xmlBuffer.toString());
    }

    protected void printXMLFooter(String header) {
        StringBuffer xmlBuffer = new StringBuffer();
        SVNXMLUtil.closeXMLTag(null, (String)header, (StringBuffer)xmlBuffer);
        this.getSVNEnvironment().getOut().print(xmlBuffer.toString());
    }

    protected StringBuffer openCDataTag(String tagName, String cdata, StringBuffer target) {
        return SVNXMLUtil.openCDataTag(null, (String)tagName, (String)cdata, (StringBuffer)target);
    }

    protected StringBuffer openXMLTag(String tagName, int style, String attr, String value, StringBuffer target) {
        return SVNXMLUtil.openXMLTag(null, (String)tagName, (int)(style | 8), (String)attr, (String)value, (StringBuffer)target);
    }

    protected StringBuffer openXMLTag(String tagName, int style, Map attributes, StringBuffer target) {
        return SVNXMLUtil.openXMLTag(null, (String)tagName, (int)(style | 8), (Map)attributes, (StringBuffer)target);
    }

    protected StringBuffer closeXMLTag(String tagName, StringBuffer target) {
        return SVNXMLUtil.closeXMLTag(null, (String)tagName, (StringBuffer)target);
    }

    protected StringBuffer printXMLPropHash(StringBuffer buffer, SVNProperties propHash, boolean namesOnly) {
        if (propHash != null && !propHash.isEmpty()) {
            buffer = buffer == null ? new StringBuffer() : buffer;
            Iterator propNames = propHash.nameSet().iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                SVNPropertyValue propVal = propHash.getSVNPropertyValue(propName);
                if (namesOnly) {
                    buffer = this.openXMLTag("property", 4, "name", propName, buffer);
                    continue;
                }
                buffer = this.addXMLProp(new SVNPropertyData(propName, propVal, null), buffer);
            }
        }
        return buffer;
    }

    protected StringBuffer addXMLProp(SVNPropertyData property, StringBuffer xmlBuffer) {
        String value = property.getValue().getString();
        value = value == null ? "" : value;
        boolean isXMLSafe = true;
        if (property.getValue().isBinary()) {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                value = decoder.decode(ByteBuffer.wrap(property.getValue().getBytes())).toString();
            }
            catch (CharacterCodingException e) {
                isXMLSafe = false;
            }
        }
        if (value != null && isXMLSafe) {
            isXMLSafe = SVNEncodingUtil.isXMLSafe((String)value);
        }
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        attrs.put("name", property.getName());
        if (!isXMLSafe) {
            attrs.put("encoding", "base64");
            if (value != null) {
                try {
                    value = SVNBase64.byteArrayToBase64((byte[])value.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    value = SVNBase64.byteArrayToBase64((byte[])value.getBytes());
                }
            } else {
                value = SVNBase64.byteArrayToBase64((byte[])property.getValue().getBytes());
            }
        }
        value = SVNEncodingUtil.xmlEncodeCDATA((String)value);
        xmlBuffer = this.openXMLTag("property", 2, attrs, xmlBuffer);
        xmlBuffer.append(value);
        xmlBuffer = this.closeXMLTag("property", xmlBuffer);
        return xmlBuffer;
    }
}

