/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminRecoverCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminRecoverCommand() {
        super("recover", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.WAIT);
        return options;
    }

    public void run() throws SVNException {
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        client.setEventHandler((ISVNEventHandler)this);
        client.doRecover(this.getLocalRepository());
        this.getEnvironment().getOut().println();
        this.getEnvironment().getOut().println("Recovery completed.");
        long youngestRevision = client.getYoungestRevision(this.getLocalRepository());
        String message = "The latest repos revision is {0}.";
        message = MessageFormat.format(message, String.valueOf(youngestRevision));
        this.getEnvironment().getOut().println(message);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event.getAction() == SVNAdminEventAction.RECOVERY_STARTED) {
            this.getEnvironment().getOut().println("Repository lock acquired.");
            this.getEnvironment().getOut().println("Please wait; recovering the repository may take some time...");
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

