/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TreeDragSourceEffect(Tree tree) {
        super(tree);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            int n = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
            if (OS.SendMessage(this.control.handle, n, 0L, sHDRAGIMAGE) != 0L) {
                dragSourceEvent.offsetX = (this.control.getStyle() & 0x8000000) != 0 ? sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x : sHDRAGIMAGE.ptOffset.x;
                dragSourceEvent.offsetY = sHDRAGIMAGE.ptOffset.y;
                long l = sHDRAGIMAGE.hbmpDragImage;
                if (l != 0L) {
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(l, BITMAP.sizeof, bITMAP);
                    int n2 = bITMAP.bmWidth;
                    int n3 = bITMAP.bmHeight;
                    long l2 = OS.GetDC(0L);
                    long l3 = OS.CreateCompatibleDC(l2);
                    long l4 = OS.SelectObject(l3, l);
                    long l5 = OS.CreateCompatibleDC(l2);
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n2;
                    bITMAPINFOHEADER.biHeight = -n3;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)32;
                    bITMAPINFOHEADER.biCompression = 0;
                    byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    long[] lArray = new long[1];
                    long l6 = OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
                    if (l6 == 0L) {
                        SWT.error(2);
                    }
                    long l7 = OS.SelectObject(l5, l6);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(l6, BITMAP.sizeof, bITMAP2);
                    int n4 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(l5, 0, 0, n2, n3, l3, 0, 0, 0xCC0020);
                    byte[] byArray2 = new byte[n4];
                    OS.MoveMemory(byArray2, bITMAP2.bmBits, n4);
                    PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    ImageData imageData = new ImageData(n2, n3, bITMAP.bmBitsPixel, paletteData, bITMAP.bmWidthBytes, byArray2);
                    if (sHDRAGIMAGE.crColorKey == -1) {
                        byte[] byArray3 = new byte[n2 * n3];
                        int n5 = bITMAP2.bmWidthBytes - n2 * 4;
                        int n6 = 0;
                        int n7 = 3;
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                byArray3[n6++] = byArray2[n7];
                                n7 += 4;
                            }
                            n7 += n5;
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        imageData.transparentPixel = sHDRAGIMAGE.crColorKey << 8;
                    }
                    this.dragSourceImage = new Image((Device)this.control.getDisplay(), imageData);
                    OS.SelectObject(l5, l7);
                    OS.DeleteDC(l5);
                    OS.DeleteObject(l6);
                    OS.SelectObject(l3, l4);
                    OS.DeleteDC(l3);
                    OS.ReleaseDC(0L, l2);
                    OS.DeleteObject(l);
                    return this.dragSourceImage;
                }
            }
            return null;
        }
        Tree tree = (Tree)this.control;
        if (tree.isListening(40) || tree.isListening(42)) {
            return null;
        }
        TreeItem[] treeItemArray = tree.getSelection();
        if (treeItemArray.length == 0) {
            return null;
        }
        long l = OS.SendMessage(tree.handle, 4360, 0L, 0L);
        if (l != 0L) {
            int n = Math.min(treeItemArray.length, 10);
            Rectangle rectangle = treeItemArray[0].getBounds(0);
            for (int i = 1; i < n; ++i) {
                rectangle = rectangle.union(treeItemArray[i].getBounds(0));
            }
            long l8 = OS.GetDC(tree.handle);
            long l9 = OS.CreateCompatibleDC(l8);
            long l10 = OS.CreateCompatibleBitmap(l8, rectangle.width, rectangle.height);
            long l11 = OS.SelectObject(l9, l10);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            long l12 = OS.GetStockObject(0);
            OS.FillRect(l9, rECT, l12);
            for (int i = 0; i < n; ++i) {
                TreeItem treeItem = treeItemArray[i];
                Rectangle rectangle2 = treeItem.getBounds(0);
                long l13 = OS.SendMessage(tree.handle, 4370, 0L, treeItem.handle);
                OS.ImageList_Draw(l13, 0, l9, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(l13);
            }
            OS.SelectObject(l9, l11);
            OS.DeleteDC(l9);
            OS.ReleaseDC(tree.handle, l8);
            Display display = tree.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, l10);
            return this.dragSourceImage;
        }
        return null;
    }
}

