/*
 * Decompiled with CFR 0.152.
 */
package qflag.ucstar.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import qflag.ucstar.util.Base64;

public class StringUtils {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static MessageDigest digest = null;
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String parseName(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.indexOf("@");
        if (atIndex <= 0) {
            return "";
        }
        return XMPPAddress.substring(0, atIndex);
    }

    public static String parseServer(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.indexOf("@");
        if (atIndex + 1 > XMPPAddress.length()) {
            return "";
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex > 0) {
            return XMPPAddress.substring(atIndex + 1, slashIndex);
        }
        return XMPPAddress.substring(atIndex + 1);
    }

    public static String parseResource(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex + 1 > XMPPAddress.length() || slashIndex < 0) {
            return "";
        }
        return XMPPAddress.substring(slashIndex + 1);
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }

    public static String escapeForXML(String string) {
        if (string == null) {
            return null;
        }
        int i = 0;
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        while (i < len) {
            char ch = input[i];
            if (ch <= '>') {
                if (ch == '<') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(LT_ENCODE);
                } else if (ch == '>') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(GT_ENCODE);
                } else if (ch == '&') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    if (!(len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';')) {
                        last = i + 1;
                        out.append(AMP_ENCODE);
                    }
                } else if (ch == '\"') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(QUOTE_ENCODE);
                }
            }
            ++i;
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static synchronized String hash(String data) {
        data = StringUtils.extractCharAndDigits(data);
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String getDigitalString(String _source) {
        char[] chars = _source.toCharArray();
        String result = "";
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c >= '\u0000' && c <= '\t') {
                result = String.valueOf(result) + c;
            }
            ++i;
        }
        return result;
    }

    public static String encodeHex(byte[] bytes) {
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i] & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toString(bytes[i] & 0xFF, 16));
            ++i;
        }
        return hex.toString();
    }

    public static String encodeBase64(String data) {
        byte[] bytes = null;
        try {
            bytes = data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return StringUtils.encodeBase64(bytes);
    }

    public static String encodeBase64(byte[] data) {
        return StringUtils.encodeBase64(data, false);
    }

    public static String encodeBase64(byte[] data, boolean lineBreaks) {
        return StringUtils.encodeBase64(data, 0, data.length, lineBreaks);
    }

    public static String encodeBase64(byte[] data, int offset, int len, boolean lineBreaks) {
        return Base64.encodeBytes(data, offset, len, lineBreaks ? 0 : 8);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode(data);
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        int i = 0;
        while (i < randBuffer.length) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
            ++i;
        }
        return new String(randBuffer);
    }

    private StringUtils() {
    }

    public static String extractCharAndDigits(String s) {
        if (s == null) {
            return "";
        }
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < c.length) {
            if (StringUtils.isChar(c[i]) || StringUtils.isDigit(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        if (sb.length() >= 80) {
            sb = new StringBuffer(sb.substring(0, 80));
        }
        return sb.toString();
    }

    public static boolean isChar(char c) {
        return Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        char x = c;
        return x >= '0' && x <= '9';
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.escapeForXML("abcd\"efg"));
    }
}

