/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.image.BufferedImage;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.device.twain.TwainIOMetadata;
import uk.co.mmscomputing.device.twain.TwainSource;

public class ADFTwainExample
implements ScannerListener {
    static ADFTwainExample app;
    Scanner scanner = Scanner.getDevice();
    int transferCount = 0;

    public ADFTwainExample(String[] stringArray) throws ScannerIOException {
        this.scanner.addListener(this);
        this.scanner.acquire();
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (type.equals(ScannerIOMetadata.ACQUIRED)) {
            BufferedImage bufferedImage = scannerIOMetadata.getImage();
            ++this.transferCount;
            System.out.println("Got image number: " + this.transferCount);
        } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
            TwainSource twainSource = ((TwainIOMetadata)scannerIOMetadata).getSource();
            String string = twainSource.getProductName();
            twainSource.setShowUI(false);
            try {
                twainSource.getCapability(4385, 2).setCurrentValue(90.0);
                twainSource.getCapability(4098).setCurrentValue(true);
                twainSource.getCapability(4103).setCurrentValue(true);
                twainSource.getCapability(1).setCurrentValue(this.transferCount);
                this.transferCount = twainSource.getCapability(1).intValue();
                System.out.println("set transferCount: " + this.transferCount);
            }
            catch (Exception exception) {
                System.out.println("CAP_FEEDERENABLED/CAP_AUTOFEED/CAP_XFERCOUNT: " + exception.getMessage());
            }
        } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            System.err.println(scannerIOMetadata.getStateStr() + " [" + scannerIOMetadata.getState() + "]");
            if (scannerIOMetadata.getLastState() == 4 && scannerIOMetadata.getState() == 3) {
                if (this.transferCount < 5) {
                    try {
                        this.scanner.acquire();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                } else {
                    System.exit(0);
                }
            }
        } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
            scannerIOMetadata.getException().printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            app = new ADFTwainExample(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

