/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.util.Hashtable;
import java.util.Vector;
import uk.co.mmscomputing.device.twain.TwainArray;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainContainer;
import uk.co.mmscomputing.device.twain.TwainEnumeration;
import uk.co.mmscomputing.device.twain.TwainFailureException;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainOneValue;
import uk.co.mmscomputing.device.twain.TwainRange;
import uk.co.mmscomputing.device.twain.TwainResultException;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainCapability
implements TwainConstants {
    protected TwainSource source;
    protected int cap;
    protected byte[] buf = new byte[jtwain.getPtrSize() == 4 ? 8 : 12];
    protected TwainContainer container;
    private static Hashtable caps = new Hashtable();

    TwainCapability(TwainSource twainSource, int n) throws TwainIOException {
        this.source = twainSource;
        this.cap = n;
        this.container = null;
        this.container = this.get();
    }

    TwainCapability(TwainSource twainSource, int n, int n2) throws TwainIOException {
        this.source = twainSource;
        this.cap = n;
        this.container = null;
        switch (n2) {
            case 1: {
                this.container = this.get();
                break;
            }
            case 2: {
                this.container = this.getCurrent();
                break;
            }
            case 3: {
                this.container = this.getDefault();
                break;
            }
            default: {
                this.container = this.get();
            }
        }
    }

    private TwainContainer get(int n, int n2) throws TwainIOException {
        jtwain.setINT16(this.buf, 0, this.cap);
        jtwain.setINT16(this.buf, 2, n2);
        this.source.call(1, 1, n, this.buf);
        int n3 = jtwain.getINT16(this.buf, 2);
        byte[] byArray = jtwain.ngetContainer(this.buf);
        switch (n3) {
            case 3: {
                return new TwainArray(this.cap, byArray);
            }
            case 4: {
                return new TwainEnumeration(this.cap, byArray);
            }
            case 5: {
                return new TwainOneValue(this.cap, byArray);
            }
            case 6: {
                return new TwainRange(this.cap, byArray);
            }
        }
        throw new TwainIOException(this.getClass().getName() + ".get:\n\tUnknown container type.");
    }

    private TwainContainer get(int n) throws TwainIOException {
        return this.get(n, -1);
    }

    public TwainContainer get() throws TwainIOException {
        this.container = this.get(1);
        return this.container;
    }

    public TwainContainer getCurrent() throws TwainIOException {
        return this.get(2);
    }

    public TwainContainer getDefault() throws TwainIOException {
        return this.get(3);
    }

    public int querySupport() throws TwainIOException {
        return this.get(8, 5).intValue();
    }

    public boolean querySupport(int n) {
        try {
            int n2 = this.get(8, 5).intValue();
            return (n2 & n) != 0;
        }
        catch (TwainIOException twainIOException) {
            System.out.println("3\b" + this.getClass().getName() + ".querySupport:\n\t" + twainIOException.getMessage());
            return false;
        }
    }

    public TwainContainer reset() throws TwainIOException {
        this.container = this.get(7);
        return this.container;
    }

    public TwainContainer set() throws TwainIOException {
        this.container = this.set(this.container);
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TwainContainer set(TwainContainer twainContainer) throws TwainIOException {
        int n = twainContainer.getType();
        byte[] byArray = twainContainer.getBytes();
        try {
            jtwain.setINT16(this.buf, 0, this.cap);
            jtwain.setINT16(this.buf, 2, n);
            jtwain.nsetContainer(this.buf, byArray);
            this.source.call(1, 1, 6, this.buf);
        }
        catch (TwainResultException.CheckStatus checkStatus) {
            twainContainer = this.get();
        }
        finally {
            jtwain.nfreeContainer(this.buf);
        }
        return twainContainer;
    }

    public Object[] getItems() {
        return this.container.getItems();
    }

    public boolean booleanValue() throws TwainIOException {
        return this.getCurrent().booleanValue();
    }

    public int intValue() throws TwainIOException {
        return this.getCurrent().intValue();
    }

    public double doubleValue() throws TwainIOException {
        return this.getCurrent().doubleValue();
    }

    public void setCurrentValue(boolean bl) throws TwainIOException {
        this.setCurrentValue(new Boolean(bl));
    }

    public void setCurrentValue(int n) throws TwainIOException {
        this.setCurrentValue(new Integer(n));
    }

    public void setCurrentValue(double d) throws TwainIOException {
        this.setCurrentValue(new Double(d));
    }

    public void setCurrentValue(Object object) throws TwainIOException {
        this.container.setCurrentValue(object);
        this.set();
    }

    public boolean booleanDefaultValue() throws TwainIOException {
        return this.getDefault().booleanDefaultValue();
    }

    public int intDefaultValue() throws TwainIOException {
        return this.getDefault().intDefaultValue();
    }

    public double doubleDefaultValue() throws TwainIOException {
        return this.getDefault().doubleDefaultValue();
    }

    public void setDefaultValue(boolean bl) throws TwainIOException {
        this.setDefaultValue(new Boolean(bl));
    }

    public void setDefaultValue(int n) throws TwainIOException {
        this.setDefaultValue(new Integer(n));
    }

    public void setDefaultValue(double d) throws TwainIOException {
        this.setDefaultValue(new Double(d));
    }

    public void setDefaultValue(Object object) throws TwainIOException {
        this.container.setDefaultValue(object);
        this.set();
    }

    protected String toString(String[] stringArray) {
        String string = this.getClass().getName() + "\n";
        Object[] objectArray = this.container.getItems();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = ((Number)objectArray[i]).intValue();
            string = string + stringArray[n] + "\n";
        }
        string = string + "\n" + this.container.toString();
        return string;
    }

    public String getName() {
        String string = TwainCapability.getCapName(this.cap);
        if (string == null) {
            return "Cap_0x" + Integer.toHexString(this.cap);
        }
        return string;
    }

    public String toString() {
        String string = this.getClass().getName() + "\n";
        string = string + "name         = " + this.getName() + "\n";
        string = string + this.container.toString();
        return string;
    }

    public static TwainCapability[] getCapabilities(TwainSource twainSource) throws TwainIOException {
        TwainCapability twainCapability = twainSource.getCapability(4101);
        Object[] objectArray = twainCapability.getItems();
        Vector<TwainCapability> vector = new Vector<TwainCapability>();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = ((Number)objectArray[i]).intValue();
            try {
                switch (n) {
                    case 256: {
                        vector.add(new Compression(twainSource));
                        break;
                    }
                    case 259: {
                        vector.add(new XferMech(twainSource));
                        break;
                    }
                    case 4364: {
                        vector.add(new ImageFileFormat(twainSource));
                        break;
                    }
                    default: {
                        vector.add(new TwainCapability(twainSource, n));
                        break;
                    }
                }
                continue;
            }
            catch (TwainFailureException.BadCap badCap) {
                continue;
            }
            catch (TwainFailureException.CapUnsupported capUnsupported) {
                continue;
            }
            catch (TwainIOException twainIOException) {
                String string = TwainCapability.getCapName(n);
                if (string == null) {
                    string = "Cap_0x" + Integer.toHexString(n) + "[" + Integer.toString(n) + "]";
                }
                System.out.println("3\b\n" + string + "\n\t" + twainIOException.toString());
            }
        }
        return vector.toArray(new TwainCapability[0]);
    }

    public static String getCapName(int n) {
        return (String)caps.get(new Integer(n));
    }

    static {
        caps.put(new Integer(1), "CAP_XFERCOUNT");
        caps.put(new Integer(256), "ICAP_COMPRESSION");
        caps.put(new Integer(257), "ICAP_PIXELTYPE");
        caps.put(new Integer(258), "ICAP_UNITS");
        caps.put(new Integer(259), "ICAP_XFERMECH");
        caps.put(new Integer(4096), "CAP_AUTHOR");
        caps.put(new Integer(4097), "CAP_CAPTION");
        caps.put(new Integer(4098), "CAP_FEEDERENABLED");
        caps.put(new Integer(4099), "CAP_FEEDERLOADED");
        caps.put(new Integer(4100), "CAP_TIMEDATE");
        caps.put(new Integer(4101), "CAP_SUPPORTEDCAPS");
        caps.put(new Integer(4102), "CAP_EXTENDEDCAPS");
        caps.put(new Integer(4103), "CAP_AUTOFEED");
        caps.put(new Integer(4104), "CAP_CLEARPAGE");
        caps.put(new Integer(4105), "CAP_FEEDPAGE");
        caps.put(new Integer(4106), "CAP_REWINDPAGE");
        caps.put(new Integer(4107), "CAP_INDICATORS");
        caps.put(new Integer(4108), "CAP_SUPPORTEDCAPSEXT");
        caps.put(new Integer(4109), "CAP_PAPERDETECTABLE");
        caps.put(new Integer(4110), "CAP_UICONTROLLABLE");
        caps.put(new Integer(4111), "CAP_DEVICEONLINE");
        caps.put(new Integer(4112), "CAP_AUTOSCAN");
        caps.put(new Integer(4113), "CAP_THUMBNAILSENABLED");
        caps.put(new Integer(4114), "CAP_DUPLEX");
        caps.put(new Integer(4115), "CAP_DUPLEXENABLED");
        caps.put(new Integer(4116), "CAP_ENABLEDSUIONLY");
        caps.put(new Integer(4117), "CAP_CUSTOMDSDATA");
        caps.put(new Integer(4118), "CAP_ENDORSER");
        caps.put(new Integer(4119), "CAP_JOBCONTROL");
        caps.put(new Integer(4120), "CAP_ALARMS");
        caps.put(new Integer(4121), "CAP_ALARMVOLUME");
        caps.put(new Integer(4122), "CAP_AUTOMATICCAPTURE");
        caps.put(new Integer(4123), "CAP_TIMEBEFOREFIRSTCAPTURE");
        caps.put(new Integer(4124), "CAP_TIMEBETWEENCAPTURES");
        caps.put(new Integer(4125), "CAP_CLEARBUFFERS");
        caps.put(new Integer(4126), "CAP_MAXBATCHBUFFERS");
        caps.put(new Integer(4127), "CAP_DEVICETIMEDATE");
        caps.put(new Integer(4128), "CAP_POWERSUPPLY");
        caps.put(new Integer(4129), "CAP_CAMERAPREVIEWUI");
        caps.put(new Integer(4130), "CAP_DEVICEEVENT");
        caps.put(new Integer(4131), "CAP_PAGEMULTIPLEACQUIRE");
        caps.put(new Integer(4132), "CAP_SERIALNUMBER");
        caps.put(new Integer(4133), "CAP_FILESYSTEM");
        caps.put(new Integer(4134), "CAP_PRINTER");
        caps.put(new Integer(4135), "CAP_PRINTERENABLED");
        caps.put(new Integer(4136), "CAP_PRINTERINDEX");
        caps.put(new Integer(4137), "CAP_PRINTERMODE");
        caps.put(new Integer(4138), "CAP_PRINTERSTRING");
        caps.put(new Integer(4139), "CAP_PRINTERSUFFIX");
        caps.put(new Integer(4140), "CAP_LANGUAGE");
        caps.put(new Integer(4141), "CAP_FEEDERALIGNMENT");
        caps.put(new Integer(4142), "CAP_FEEDERORDER");
        caps.put(new Integer(4143), "CAP_PAPERBINDING");
        caps.put(new Integer(4144), "CAP_REACQUIREALLOWED");
        caps.put(new Integer(4145), "CAP_PASSTHRU");
        caps.put(new Integer(4146), "CAP_BATTERYMINUTES");
        caps.put(new Integer(4147), "CAP_BATTERYPERCENTAGE");
        caps.put(new Integer(4148), "CAP_POWERDOWNTIME");
        caps.put(new Integer(4352), "ICAP_AUTOBRIGHT");
        caps.put(new Integer(4353), "ICAP_BRIGHTNESS");
        caps.put(new Integer(4355), "ICAP_CONTRAST");
        caps.put(new Integer(4356), "ICAP_CUSTHALFTONE");
        caps.put(new Integer(4357), "ICAP_EXPOSURETIME");
        caps.put(new Integer(4358), "ICAP_FILTER");
        caps.put(new Integer(4359), "ICAP_FLASHUSED");
        caps.put(new Integer(4360), "ICAP_GAMMA");
        caps.put(new Integer(4361), "ICAP_HALFTONES");
        caps.put(new Integer(4362), "ICAP_HIGHLIGHT");
        caps.put(new Integer(4364), "ICAP_IMAGEFILEFORMAT");
        caps.put(new Integer(4365), "ICAP_LAMPSTATE");
        caps.put(new Integer(4366), "ICAP_LIGHTSOURCE");
        caps.put(new Integer(4368), "ICAP_ORIENTATION");
        caps.put(new Integer(4369), "ICAP_PHYSICALWIDTH");
        caps.put(new Integer(4370), "ICAP_PHYSICALHEIGHT");
        caps.put(new Integer(4371), "ICAP_SHADOW");
        caps.put(new Integer(4372), "ICAP_FRAMES");
        caps.put(new Integer(4374), "ICAP_XNATIVERESOLUTION");
        caps.put(new Integer(4375), "ICAP_YNATIVERESOLUTION");
        caps.put(new Integer(4376), "ICAP_XRESOLUTION");
        caps.put(new Integer(4377), "ICAP_YRESOLUTION");
        caps.put(new Integer(4378), "ICAP_MAXFRAMES");
        caps.put(new Integer(4379), "ICAP_TILES");
        caps.put(new Integer(4380), "ICAP_BITORDER");
        caps.put(new Integer(4381), "ICAP_CCITTKFACTOR");
        caps.put(new Integer(4382), "ICAP_LIGHTPATH");
        caps.put(new Integer(4383), "ICAP_PIXELFLAVOR");
        caps.put(new Integer(4384), "ICAP_PLANARCHUNKY");
        caps.put(new Integer(4385), "ICAP_ROTATION");
        caps.put(new Integer(4386), "ICAP_SUPPORTEDSIZES");
        caps.put(new Integer(4387), "ICAP_THRESHOLD");
        caps.put(new Integer(4388), "ICAP_XSCALING");
        caps.put(new Integer(4389), "ICAP_YSCALING");
        caps.put(new Integer(4390), "ICAP_BITORDERCODES");
        caps.put(new Integer(4391), "ICAP_PIXELFLAVORCODES");
        caps.put(new Integer(4392), "ICAP_JPEGPIXELTYPE");
        caps.put(new Integer(4394), "ICAP_TIMEFILL");
        caps.put(new Integer(4395), "ICAP_BITDEPTH");
        caps.put(new Integer(4396), "ICAP_BITDEPTHREDUCTION");
        caps.put(new Integer(4397), "ICAP_UNDEFINEDIMAGESIZE");
        caps.put(new Integer(4398), "ICAP_IMAGEDATASET");
        caps.put(new Integer(4399), "ICAP_EXTIMAGEINFO");
        caps.put(new Integer(4400), "ICAP_MINIMUMHEIGHT");
        caps.put(new Integer(4401), "ICAP_MINIMUMWIDTH");
        caps.put(new Integer(4404), "ICAP_AUTODISCARDBLANKPAGES");
        caps.put(new Integer(4406), "ICAP_FLIPROTATION");
        caps.put(new Integer(4407), "ICAP_BARCODEDETECTIONENABLED");
        caps.put(new Integer(4408), "ICAP_SUPPORTEDBARCODETYPES");
        caps.put(new Integer(4409), "ICAP_BARCODEMAXSEARCHPRIORITIES");
        caps.put(new Integer(4410), "ICAP_BARCODESEARCHPRIORITIES");
        caps.put(new Integer(4411), "ICAP_BARCODESEARCHMODE");
        caps.put(new Integer(4412), "ICAP_BARCODEMAXRETRIES");
        caps.put(new Integer(4413), "ICAP_BARCODETIMEOUT");
        caps.put(new Integer(4414), "ICAP_ZOOMFACTOR");
        caps.put(new Integer(4415), "ICAP_PATCHCODEDETECTIONENABLED");
        caps.put(new Integer(4416), "ICAP_SUPPORTEDPATCHCODETYPES");
        caps.put(new Integer(4417), "ICAP_PATCHCODEMAXSEARCHPRIORITIES");
        caps.put(new Integer(4418), "ICAP_PATCHCODESEARCHPRIORITIES");
        caps.put(new Integer(4419), "ICAP_PATCHCODESEARCHMODE");
        caps.put(new Integer(4420), "ICAP_PATCHCODEMAXRETRIES");
        caps.put(new Integer(4421), "ICAP_PATCHCODETIMEOUT");
        caps.put(new Integer(4422), "ICAP_FLASHUSED2");
        caps.put(new Integer(4423), "ICAP_IMAGEFILTER");
        caps.put(new Integer(4424), "ICAP_NOISEFILTER");
        caps.put(new Integer(4425), "ICAP_OVERSCAN");
        caps.put(new Integer(4432), "ICAP_AUTOMATICBORDERDETECTION");
        caps.put(new Integer(4433), "ICAP_AUTOMATICDESKEW");
        caps.put(new Integer(4434), "ICAP_AUTOMATICROTATE");
    }

    public static class ImageFileFormat
    extends TwainCapability {
        ImageFileFormat(TwainSource twainSource) throws TwainIOException {
            super(twainSource, 4364);
        }

        public String toString() {
            return this.toString(TwainConstants.ImageFileFormatStrings);
        }
    }

    public static class XferMech
    extends TwainCapability {
        XferMech(TwainSource twainSource) throws TwainIOException {
            super(twainSource, 259);
        }

        public String toString() {
            return this.toString(TwainConstants.XferMechStrings);
        }

        public int intValue() {
            try {
                return super.intValue();
            }
            catch (Exception exception) {
                System.err.println(this.getClass().getName() + ".intValue:\n\t" + exception);
                return 0;
            }
        }
    }

    public static class Compression
    extends TwainCapability {
        Compression(TwainSource twainSource) throws TwainIOException {
            super(twainSource, 256);
        }

        public String toString() {
            return this.toString(TwainConstants.CompressionStrings);
        }
    }
}

