/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainContainer;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.jtwain;

class TwainEnumeration
extends TwainContainer {
    int count;
    int currentIndex;
    int defaultIndex;
    Vector items = new Vector();

    TwainEnumeration(int n, byte[] byArray) {
        super(n, byArray);
        this.count = jtwain.getINT32(byArray, 2);
        this.currentIndex = jtwain.getINT32(byArray, 6);
        this.defaultIndex = jtwain.getINT32(byArray, 10);
        int n2 = 14;
        for (int i = 0; i < this.count; ++i) {
            this.items.add(this.getObjectAt(byArray, n2));
            n2 += TwainConstants.typeSizes[this.type];
        }
    }

    int getType() {
        return 4;
    }

    public Object[] getItems() {
        return this.items.toArray();
    }

    byte[] getBytes() {
        int n = this.items.size();
        int n2 = 14 + n * TwainConstants.typeSizes[this.type];
        byte[] byArray = new byte[n2];
        jtwain.setINT16(byArray, 0, this.type);
        jtwain.setINT32(byArray, 2, n);
        jtwain.setINT32(byArray, 6, this.currentIndex);
        jtwain.setINT32(byArray, 10, this.defaultIndex);
        int n3 = 14;
        for (int i = 0; i < n; ++i) {
            this.setObjectAt(byArray, n3, this.items.get(i));
            n3 += TwainConstants.typeSizes[this.type];
        }
        return byArray;
    }

    public Object getCurrentValue() throws TwainIOException {
        return this.items.get(this.currentIndex);
    }

    public void setCurrentValue(Object object) throws TwainIOException {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.items.get(i);
            if (!object.equals(e)) continue;
            this.currentIndex = i;
            return;
        }
        throw new TwainIOException(this.getClass().getName() + ".setCurrentValue:\n\tCould not find " + object.toString());
    }

    public Object getDefaultValue() throws TwainIOException {
        return this.items.get(this.defaultIndex);
    }

    public void setDefaultValue(Object object) throws TwainIOException {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.items.get(i);
            if (!object.equals(e)) continue;
            this.defaultIndex = i;
            return;
        }
        throw new TwainIOException(this.getClass().getName() + ".setDefaultValue:\n\tCould not find " + object.toString());
    }

    public String toString() {
        String string = super.toString();
        string = string + "count        = " + this.count + "\n";
        string = string + "currentIndex = " + this.currentIndex + "\n";
        string = string + "defaultIndex = " + this.defaultIndex + "\n";
        Enumeration enumeration = this.items.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string = string + "items[" + n + "] = " + enumeration.nextElement() + "\n";
            ++n;
        }
        return string;
    }
}

