/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.util.Vector;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainFailureException;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainExtImageInfo
implements TwainConstants {
    TwainSource source;
    byte[] buf;
    int[] attributes;
    Vector extInfos;

    public TwainExtImageInfo(TwainSource twainSource, int n) {
        this.source = twainSource;
        this.attributes = new int[1];
        this.attributes[0] = n;
        this.initBuf();
    }

    public TwainExtImageInfo(TwainSource twainSource, int[] nArray) {
        this.source = twainSource;
        this.attributes = nArray;
        this.initBuf();
    }

    private void initBuf() {
        int n = this.attributes.length;
        this.buf = new byte[4 + n * 12];
        jtwain.setINT32(this.buf, 0, this.attributes.length);
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            jtwain.setINT16(this.buf, n2, this.attributes[i]);
            jtwain.setINT16(this.buf, n2 += 2, 0);
            jtwain.setINT16(this.buf, n2 += 2, 0);
            jtwain.setINT16(this.buf, n2 += 2, 0);
            jtwain.setINT32(this.buf, n2 += 2, 0);
            n2 += 4;
        }
    }

    public void get() throws TwainIOException {
        this.source.call(2, 267, 1, this.buf);
    }

    public Object getInfo() throws TwainIOException {
        return this.getInfo(this.attributes[0]);
    }

    public Object getInfo(int n) throws TwainIOException {
        int n2;
        int n3 = this.attributes.length;
        for (n2 = 0; n2 < n3 && this.attributes[n2] != n; ++n2) {
        }
        if (n2 == n3) {
            return null;
        }
        int n4 = 4 + n2 * 12;
        int n5 = jtwain.getINT16(this.buf, n4 + 6);
        if (n5 != 0) {
            throw new TwainFailureException(n5);
        }
        int n6 = jtwain.getINT16(this.buf, n4 + 2);
        int n7 = jtwain.getINT16(this.buf, n4 + 4);
        switch (n6) {
            case 5: {
                if (n7 != 1) break;
                return new Integer(jtwain.getINT16(this.buf, n4 + 8));
            }
        }
        System.err.println(this.getClass().getName() + ".getInfo:\n\tDon't support type = " + n6 + " yet.");
        return null;
    }

    public String toString() {
        String string = "TwainExtImageInfo\n";
        int n = this.attributes.length;
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            string = string + "InfoID = 0x" + Integer.toHexString(jtwain.getINT16(this.buf, n2)) + "\n";
            string = string + "ItemType = " + jtwain.getINT16(this.buf, n2 += 2) + "\n";
            string = string + "NumItems = " + jtwain.getINT16(this.buf, n2 += 2) + "\n";
            string = string + "CondCode = " + jtwain.getINT16(this.buf, n2 += 2) + "\n";
            string = string + "Item = " + jtwain.getINT32(this.buf, n2 += 2) + "\n";
            n2 += 4;
        }
        return string;
    }
}

