/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.util.Vector;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainResultException;
import uk.co.mmscomputing.device.twain.TwainSourceManager;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainIdentity
implements TwainConstants {
    private TwainSourceManager manager;
    protected byte[] identity;

    TwainIdentity(TwainSourceManager twainSourceManager) {
        this.manager = twainSourceManager;
        this.identity = new byte[156];
    }

    TwainIdentity(TwainSourceManager twainSourceManager, byte[] byArray) {
        this.manager = twainSourceManager;
        this.identity = byArray;
    }

    boolean isTwain20Source() {
        int n = jtwain.getINT32(this.identity, 50);
        return (n & 0x40000000) == 0x40000000;
    }

    void maskTwain20Source() {
        int n = jtwain.getINT32(this.identity, 50);
        jtwain.setINT32(this.identity, 50, n & 0xBFFFFFFF);
    }

    void getDefault() {
        try {
            this.manager.call(1, 3, 3, this.identity);
        }
        catch (TwainIOException twainIOException) {
            // empty catch block
        }
    }

    void userSelect() throws TwainIOException {
        this.manager.call(1, 3, 1027, this.identity);
    }

    void open() throws TwainIOException {
        this.manager.call(1, 3, 1025, this.identity);
    }

    void getFirst() throws TwainIOException {
        this.manager.call(1, 3, 4, this.identity);
    }

    void getNext() throws TwainIOException {
        this.manager.call(1, 3, 5, this.identity);
    }

    public int getId() {
        return jtwain.getINT32(this.identity, 0);
    }

    public int getMajorNum() {
        return jtwain.getINT16(this.identity, 4);
    }

    public int getMinorNum() {
        return jtwain.getINT16(this.identity, 6);
    }

    public int getLanguage() {
        return jtwain.getINT16(this.identity, 8);
    }

    public int getCountry() {
        return jtwain.getINT16(this.identity, 10);
    }

    public String getInfo() {
        String string = "";
        for (int i = 12; this.identity[i] != 0 && i < 46; ++i) {
            string = string + (char)this.identity[i];
        }
        return string;
    }

    public int getProtocolMajor() {
        return jtwain.getINT16(this.identity, 46);
    }

    public int getProtocolMinor() {
        return jtwain.getINT16(this.identity, 48);
    }

    public int getSupportedGroups() {
        return jtwain.getINT32(this.identity, 50);
    }

    public String getManufacturer() {
        String string = "";
        for (int i = 54; this.identity[i] != 0 && i < 88; ++i) {
            string = string + (char)this.identity[i];
        }
        return string;
    }

    public String getProductFamily() {
        String string = "";
        for (int i = 88; this.identity[i] != 0 && i < 122; ++i) {
            string = string + (char)this.identity[i];
        }
        return string;
    }

    public String getProductName() {
        String string = "";
        for (int i = 122; this.identity[i] != 0 && i < 156; ++i) {
            string = string + (char)this.identity[i];
        }
        return string;
    }

    public String toString() {
        String string = "TwainIdentity\n";
        string = string + "\tid               = 0x" + Integer.toHexString(this.getId()) + "\n";
        string = string + "\tmajorNum         = 0x" + Integer.toHexString(this.getMajorNum()) + "\n";
        string = string + "\tminorNum         = 0x" + Integer.toHexString(this.getMinorNum()) + "\n";
        string = string + "\tlanguage         = 0x" + Integer.toHexString(this.getLanguage()) + "\n";
        string = string + "\tcountry          = 0x" + Integer.toHexString(this.getCountry()) + "\n";
        string = string + "\tinfo             = " + this.getInfo() + "\n";
        string = string + "\tprotocol major   = 0x" + Integer.toHexString(this.getProtocolMajor()) + "\n";
        string = string + "\tprotocol minor   = 0x" + Integer.toHexString(this.getProtocolMinor()) + "\n";
        string = string + "\tsupported groups = 0x" + Integer.toHexString(this.getSupportedGroups()) + "\n";
        string = string + "\tmanufacturer     = " + this.getManufacturer() + "\n";
        string = string + "\tproduct family   = " + this.getProductFamily() + "\n";
        string = string + "\tproduct name     = " + this.getProductName() + "\n";
        string = string + "\ttwain 2.0 source = " + this.isTwain20Source() + "\n";
        return string;
    }

    public static TwainIdentity[] getIdentities() throws TwainIOException {
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        Vector<TwainIdentity> vector = new Vector<TwainIdentity>();
        try {
            TwainIdentity twainIdentity = new TwainIdentity(twainSourceManager);
            twainIdentity.getFirst();
            vector.add(twainIdentity);
            while (true) {
                twainIdentity = new TwainIdentity(twainSourceManager);
                twainIdentity.getNext();
                vector.add(twainIdentity);
            }
        }
        catch (TwainResultException.EndOfList endOfList) {
        }
        catch (TwainIOException twainIOException) {
            System.out.println("uk.co.mmscomputing.device.twain.TwainIdentity.getIdentities:\n\t" + twainIOException);
        }
        return vector.toArray(new TwainIdentity[0]);
    }

    public static String[] getProductNames() throws TwainIOException {
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        Vector<String> vector = new Vector<String>();
        try {
            TwainIdentity twainIdentity = new TwainIdentity(twainSourceManager);
            twainIdentity.getFirst();
            vector.add(twainIdentity.getProductName());
            while (true) {
                twainIdentity = new TwainIdentity(twainSourceManager);
                twainIdentity.getNext();
                vector.add(twainIdentity.getProductName());
            }
        }
        catch (TwainResultException.EndOfList endOfList) {
        }
        catch (TwainIOException twainIOException) {
            System.out.println("uk.co.mmscomputing.device.twain.TwainIdentity.getProductNames:\n\t" + twainIOException);
        }
        return vector.toArray(new String[0]);
    }
}

