/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainIOMetadata;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;
import uk.co.mmscomputing.util.JarImageIcon;

public class TwainPanel
extends JComponent
implements TwainConstants,
ScannerListener {
    Scanner scanner = null;
    JButton acqbutton = null;
    JButton selbutton = null;
    JCheckBox guicheckbox = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public TwainPanel(Scanner scanner, int n) throws TwainIOException {
        this.scanner = scanner;
        switch (n) {
            case 0: {
                this.acqbutton = new JButton("acquire");
                this.selbutton = new JButton("select");
                this.setLayout(new GridLayout(0, 1));
                break;
            }
            case 1: {
                this.acqbutton = new JButton("acquire");
                this.selbutton = new JButton("select");
                this.setLayout(new GridLayout(1, 0));
                break;
            }
            case 2: {
                this.acqbutton = new JButton("acquire", new JarImageIcon(this.getClass(), "16x16/scanner.png"));
                this.selbutton = new JButton("select", new JarImageIcon(this.getClass(), "16x16/list.png"));
                this.setLayout(new GridLayout(0, 1));
                break;
            }
            case 3: {
                this.acqbutton = new JButton("acquire", new JarImageIcon(this.getClass(), "16x16/scanner.png"));
                this.selbutton = new JButton("select", new JarImageIcon(this.getClass(), "16x16/list.png"));
                this.setLayout(new GridLayout(1, 0));
                break;
            }
            case 4: {
                this.acqbutton = new JButton("acquire", new JarImageIcon(this.getClass(), "32x32/scanner.png"));
                this.selbutton = new JButton("select", new JarImageIcon(this.getClass(), "32x32/list.png"));
                this.setLayout(new GridLayout(0, 1));
                break;
            }
            case 5: {
                this.acqbutton = new JButton("acquire", new JarImageIcon(this.getClass(), "32x32/scanner.png"));
                this.selbutton = new JButton("select", new JarImageIcon(this.getClass(), "32x32/list.png"));
                this.setLayout(new GridLayout(1, 0));
            }
        }
        this.acqbutton.addActionListener((ActionListener)EventHandler.create(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TwainPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this, "acquire"));
        this.add(this.acqbutton);
        this.guicheckbox = new JCheckBox("Enable GUI");
        this.guicheckbox.setSelected(true);
        this.add(this.guicheckbox);
        this.selbutton.addActionListener((ActionListener)EventHandler.create(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TwainPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this, "select"));
        this.add(this.selbutton);
        scanner.addListener(this);
        if (jtwain.getSource().isBusy()) {
            this.acqbutton.setEnabled(false);
            this.selbutton.setEnabled(false);
            this.guicheckbox.setEnabled(false);
        }
    }

    public void acquire() {
        try {
            this.scanner.acquire();
        }
        catch (ScannerIOException scannerIOException) {
            this.scanner.fireExceptionUpdate(scannerIOException);
        }
    }

    public void select() {
        try {
            this.scanner.select();
        }
        catch (ScannerIOException scannerIOException) {
            this.scanner.fireExceptionUpdate(scannerIOException);
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (scannerIOMetadata instanceof TwainIOMetadata) {
            TwainIOMetadata twainIOMetadata = (TwainIOMetadata)scannerIOMetadata;
            TwainSource twainSource = twainIOMetadata.getSource();
            if (type.equals(ScannerIOMetadata.STATECHANGE)) {
                if (twainIOMetadata.isState(3)) {
                    if (twainSource.isBusy()) {
                        this.acqbutton.setEnabled(false);
                        this.selbutton.setEnabled(false);
                        this.guicheckbox.setEnabled(false);
                    } else {
                        this.acqbutton.setEnabled(true);
                        this.selbutton.setEnabled(true);
                        this.guicheckbox.setEnabled(true);
                    }
                }
            } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
                if (twainSource.isUIControllable()) {
                    twainSource.setShowUI(this.guicheckbox.isSelected());
                } else {
                    if (!this.guicheckbox.isSelected()) {
                        System.out.println("9\bCannot hide twain source's GUI.");
                    }
                    this.guicheckbox.setSelected(true);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

