/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.device.twain.TwainContainer;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.jtwain;

class TwainRange
extends TwainContainer {
    private Object minValue;
    private Object maxValue;
    private Object stepSize;
    private Object defaultValue;
    private Object currentValue;

    TwainRange(int n, byte[] byArray) {
        super(n, byArray);
        this.minValue = this.get32BitObjectAt(byArray, 2);
        this.maxValue = this.get32BitObjectAt(byArray, 6);
        this.stepSize = this.get32BitObjectAt(byArray, 10);
        this.defaultValue = this.get32BitObjectAt(byArray, 14);
        this.currentValue = this.get32BitObjectAt(byArray, 18);
    }

    int getType() {
        return 6;
    }

    byte[] getBytes() {
        byte[] byArray = new byte[22];
        jtwain.setINT16(byArray, 0, this.type);
        this.set32BitObjectAt(byArray, 2, this.minValue);
        this.set32BitObjectAt(byArray, 6, this.maxValue);
        this.set32BitObjectAt(byArray, 10, this.stepSize);
        this.set32BitObjectAt(byArray, 14, this.defaultValue);
        this.set32BitObjectAt(byArray, 18, this.currentValue);
        return byArray;
    }

    public Object getCurrentValue() throws TwainIOException {
        return this.currentValue;
    }

    public void setCurrentValue(Object object) throws TwainIOException {
        this.currentValue = object;
    }

    public Object getDefaultValue() throws TwainIOException {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) throws TwainIOException {
        this.defaultValue = object;
    }

    public Object[] getItems() {
        Object[] objectArray = new Object[]{this.currentValue};
        return objectArray;
    }

    public String toString() {
        String string = super.toString();
        string = string + "minValue     = " + this.minValue + "\n";
        string = string + "maxValue     = " + this.maxValue + "\n";
        string = string + "stepSize     = " + this.stepSize + "\n";
        string = string + "defaultValue = " + this.defaultValue + "\n";
        string = string + "currentValue = " + this.currentValue + "\n";
        return string;
    }
}

