/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.co.mmscomputing.util.log.LogBook;

public abstract class UtilMainApp
extends JApplet {
    private Properties properties = new Properties();
    private File propertiesFile;
    private JFrame frame = null;

    public UtilMainApp() {
        this.frame = null;
    }

    public UtilMainApp(String string, String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.frame = new JFrame(string);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UtilMainApp.this.stop();
                System.exit(0);
            }
        });
        this.init();
        this.start();
    }

    protected boolean isApplet() {
        return this.frame == null;
    }

    protected void setFrameSize(JFrame jFrame, Rectangle rectangle) {
        jFrame.setSize(rectangle.width * 4 / 5, rectangle.height * 4 / 5);
    }

    protected abstract JPanel getCenterPanel(Properties var1) throws Exception;

    public void createGUI() {
        try {
            LogBook logBook = new LogBook(false);
            Runtime runtime = Runtime.getRuntime();
            System.out.println("Runtime Total Memory: " + runtime.totalMemory() / 0x100000L + " MB");
            System.out.println("Runtime Max   Memory: " + runtime.maxMemory() / 0x100000L + " MB");
            String string = System.getProperty("java.home");
            System.out.println("java directory: " + string);
            String string2 = this.getClass().getName();
            String string3 = string2.substring(0, string2.lastIndexOf(46)) + ".properties.txt";
            String string4 = System.getProperty("user.dir");
            System.out.println("current directory: " + string4);
            String string5 = System.getProperty("user.home");
            System.out.println("user directory: " + string5);
            File file = new File(string5, "mmsc");
            try {
                file.mkdirs();
                this.propertiesFile = new File(file.getAbsolutePath(), string3);
            }
            catch (Exception exception) {
                System.out.println("9\bCould not create directory:\n\t" + file.getAbsolutePath() + "\n\t" + exception);
                this.propertiesFile = new File(string3);
            }
            System.out.println("properties file: " + this.propertiesFile.getAbsolutePath());
            if (this.propertiesFile.exists()) {
                this.properties.load(new FileInputStream(this.propertiesFile));
            }
            JTabbedPane jTabbedPane = new JTabbedPane();
            String string6 = this.properties.getProperty(this.getClass().getName() + ".mainapp.title");
            if (string6 == null) {
                string6 = "MainApp";
            }
            JPanel jPanel = this.getCenterPanel(this.properties);
            jTabbedPane.addTab(string6, jPanel);
            String string7 = this.properties.getProperty(this.getClass().getName() + ".log.title");
            if (string7 == null) {
                string7 = "Log";
            }
            jTabbedPane.addTab("Log", (Component)logBook);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jTabbedPane, "Center");
            if (this.frame != null) {
                this.frame.getContentPane().add(this);
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.setFrameSize(this.frame, graphicsEnvironment.getMaximumWindowBounds());
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            }
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".createGUI:\n\tCould not create GUI\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void init() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UtilMainApp.this.createGUI();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".init:\n\tCould not create GUI\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.properties.store(new FileOutputStream(this.propertiesFile), this.propertiesFile.getAbsolutePath());
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".stop:\n\tCould not save properties\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        super.stop();
    }
}

