/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload.util;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.NamedRunnable;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.ObjectFIFO;
import org.apache.log4j.Logger;

public class ThreadPoolWorker {
    private static final Logger logger = ClientStartLogger.getLogger();
    private static int nextWorkerID = 0;
    private ObjectFIFO idleWorkers;
    private int workerID;
    private ObjectFIFO handoffBox;
    private Thread internalThread;
    private volatile boolean noStopRequested;

    public ThreadPoolWorker(ObjectFIFO idleWorkers) {
        this.idleWorkers = idleWorkers;
        this.workerID = ThreadPoolWorker.getNextWorkerID();
        this.handoffBox = new ObjectFIFO(1);
        this.noStopRequested = true;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    ThreadPoolWorker.this.runWork();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        };
        this.internalThread = new Thread(r);
        this.internalThread.setName("ThreadPoolWorker[" + this.workerID + "] internal Thread");
        this.internalThread.start();
    }

    public static synchronized int getNextWorkerID() {
        int id = nextWorkerID++;
        return id;
    }

    public void process(Runnable target) throws InterruptedException {
        this.handoffBox.add(target);
    }

    private void runWork() {
        while (this.noStopRequested) {
            try {
                this.idleWorkers.add(this);
                NamedRunnable r = (NamedRunnable)this.handoffBox.remove();
                this.runIt(r);
            }
            catch (InterruptedException x) {
                logger.error((Object)"", (Throwable)x);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIt(NamedRunnable r) {
        try {
            r.run();
        }
        catch (Exception runex) {
            logger.error((Object)"Uncaught exception fell through from run()", (Throwable)runex);
        }
        finally {
            Thread.interrupted();
        }
    }

    public void stopRequest() {
        logger.info((Object)("WorkerThread[" + this.workerID + "], stopRequest() received."));
        this.noStopRequested = false;
        this.internalThread.interrupt();
    }

    public boolean isAlive() {
        return this.internalThread.isAlive();
    }
}

