/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.util.format.Format;
import com.kingdee.bos.billdigest.util.format.Triple;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.LocalCache;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import com.kingdee.cbos.process.vm.utils.group.MessageServer;
import com.kingdee.cbos.process.vm.utils.group.MessageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class BillDigestCache {
    private static final Format NULL = new Format("");
    private static final Cache<Triple<String, String, BOSObjectType>, Format> cache = new SmartCache((Cache)new LocalCache(BillDigestCache.class, 300, 1800), (SmartCache.Loader)new SmartCache.Loader<Triple<String, String, BOSObjectType>, Format>(){

        public Format load(Triple<String, String, BOSObjectType> id) {
            String[] tmp = id.getA().split(";");
            String dataCenter = tmp[0];
            String lang = tmp[1].toLowerCase();
            Context ctx = Ctx.newShadowContext((String)dataCenter);
            String path = BillDigestCache.getTemplatePath(ctx, id.getB(), id.getC());
            try {
                String template = null;
                if (template == null) {
                    // empty if block
                }
                if (template == null) {
                    template = BillDigestCache.loadFromDB(id, ctx);
                }
                return template == null || template.length() == 0 ? NULL : new Format(template);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    });
    private static String initedCtx = "";
    private static String initedSuccessCtx = "";
    public static final String CMD = "CLEAR-BILL-DIGEST-CACHE";

    public static Format get(String dataCenter, Locale l, String purpose, BOSObjectType type) {
        Triple<String, String, BOSObjectType> key = new Triple<String, String, BOSObjectType>(dataCenter + ";" + l, purpose, type);
        Format format = (Format)cache.get(key);
        return format == NULL ? null : format;
    }

    public static void clear() {
        cache.clear();
        MessageServer.send((String)CMD, (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFile(String path) throws Exception {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        try {
            StringBuilder sb = new StringBuilder(1024);
            int c = isr.read();
            while (c >= 0) {
                sb.append((char)c);
                c = isr.read();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            isr.close();
            fis.close();
        }
    }

    private static String getTemplatePath(Context ctx, String purpose, BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(type);
        String tmp = System.getProperty("java.security.auth.login.config");
        int i = tmp.lastIndexOf("/");
        String path = tmp.substring(0, i) + "/digest/" + purpose + "/" + entity.getFullName().replace('.', '/');
        return path;
    }

    private static String loadFromDB(Triple<String, String, BOSObjectType> id, Context ctx) throws BOSException {
        String sql = "select ftemplate from T_BAS_BILLDIGESTTMP where fbostype='" + id.getC() + "' and FPURPOSE like '" + id.getB() + "%'";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
        if (list.size() > 0) {
            return (String)((Map)list.get(0)).get("ftemplate");
        }
        return null;
    }

    private static boolean init(Context ctx) {
        String f = (":" + ctx.getAIS() + ":").toLowerCase();
        if (initedCtx.indexOf(f) >= 0) {
            return initedSuccessCtx.indexOf(f) >= 0;
        }
        initedCtx = initedCtx + f;
        boolean isSuccess = false;
        try {
            String tmp = System.getProperty("java.security.auth.login.config");
            int i = tmp.lastIndexOf("properties");
            String path = tmp.substring(0, i) + "deploy/easweb.ear/eas_web.war/billdigesttools/initdata.xml";
            Class<?> clz = Class.forName("com.kingdee.bos.billdigest.tools.app.BillDigestHelper");
            Constructor<?> cst = clz.getConstructor(Context.class);
            Method m = clz.getMethod("importData", String.class, Boolean.TYPE);
            Object obj = cst.newInstance(ctx);
            m.invoke(obj, path, false);
            initedSuccessCtx = initedSuccessCtx + f;
            isSuccess = true;
        }
        catch (Exception e) {
            isSuccess = false;
        }
        return isSuccess;
    }

    static {
        MessageServer.register((String)CMD, (MessageService)new CacheClearSvc());
    }

    private static class CacheClearSvc
    implements MessageService {
        private CacheClearSvc() {
        }

        public void handle(SocketAddress host, String serverId, String msgId, String message) {
            cache.clear();
        }
    }
}

