/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.util.format.Expression;
import com.kingdee.bos.billdigest.util.format.Property;
import com.kingdee.bos.billdigest.util.format.Util;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.workflow.util.ScriptUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

class Expr
implements Property {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.util.format.Expr");
    private String[] name;
    private Expression expr;

    Expr(String name) {
        this.name = name.split("\\.", 2);
        if (Expression.isExpr(name)) {
            this.expr = new Expression(name);
        }
    }

    @Override
    public Object getFrom(Map<String, Object> ctx) {
        long startTime = 0L;
        if (log.isDebugEnabled()) {
            startTime = System.nanoTime();
        }
        Object v = this.expr != null ? this.expr.eval(ctx) : this.getByScript(ctx);
        if (log.isDebugEnabled()) {
            long t = System.nanoTime();
            log.info((Object)("BillDigest::getValue::" + this.getName() + " cost:" + (t - startTime) + "ns"));
        }
        if (v instanceof Date || v instanceof BigDecimal) {
            v = Util.toString(v);
        }
        return v;
    }

    private Object getByScript(Map<String, Object> ctx) {
        Object v = ctx.get(this.name[0]);
        if (this.name.length == 1) {
            return v;
        }
        Context bosCtx = (Context)ctx.get("ctx");
        try {
            if (v != null && this.name[1].indexOf(40) < 0) {
                Object o = ScriptUtil.evalObjectProperty((String)this.name[1], (Object)v, (Context)bosCtx);
                return o;
            }
            String script = this.name[0] + "." + this.name[1];
            Interpreter interpreter = new Interpreter(bosCtx);
            Object o = interpreter.eval(script, ctx);
            return o;
        }
        catch (Exception e) {
            return "failed: " + e;
        }
    }

    @Override
    public String getName() {
        return this.name[0] + (this.name.length == 2 ? "." + this.name[1] : "");
    }

    public String toString() {
        return "#{" + this.getName() + "}";
    }

    @Override
    public void addReference(String prefix, Collection<String> refs) {
        if (this.name.length == 2) {
            String ref = prefix == null ? this.name[1] : prefix + "." + this.name[1];
            refs.add(ref);
        }
    }

    String getRef() {
        return this.name.length == 2 ? this.name[1] : null;
    }
}

