/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.billdigest.util.format.Format;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Util {
    public static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static boolean objectToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s)) {
                return false;
            }
            return s.length() > 0;
        }
        if (value instanceof Number) {
            String s = value.toString();
            return !"0".equals(s) && !"0.0".equals(s) && !"-0.0".equals(s) && !s.startsWith("0E-");
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() > 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size() > 0;
        }
        return true;
    }

    public static void main(String[] args) {
        Util.testMap();
        Util.testLoop();
        Util.testMapLoop();
        Util.testNumber();
        Util.getOutput().println(Util.objectToBoolean(0.0));
        Util.getOutput().println(Util.objectToBoolean(-0.0));
        Util.getOutput().println(Util.objectToBoolean(0));
        Util.getOutput().println(Util.objectToBoolean(new BigDecimal("0.000000000")));
        Util.getOutput().println(Util.objectToBoolean(new BigDecimal("1.000000000")));
    }

    private static void testNumber() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("V0", 100934.056);
        Format format = new Format("#{Format.money(V0)}");
        String msg = format.translate(params);
        Util.getOutput().println(msg);
    }

    private static void testLoop() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("V0", new Object[]{"John", "Mike", "Kite"});
        Format format = new Format("#{for-each:V0->e #{index}. Hello,#{e}#{if:index<count ;\r\n}#{if:index==count .}}");
        String msg = format.translate(params);
        Util.getOutput().print(msg);
    }

    private static void testMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("a", "John");
        params.put("b", "Kite");
        params.put("c", "like");
        Format format = new Format("#{a} #{c} #{b} .");
        String msg = format.translate(params);
        Util.getOutput().println(msg);
    }

    private static void testMapLoop() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "John");
        params.put("b", "Kite");
        params.put("c", "like");
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("map", params);
        Format format = new Format("#{for-each:map->key,value #{if:index>1 , }#{key}=#{value}#{if:index==count .}}");
        String msg = format.translate(ctx);
        Util.getOutput().println();
        Util.getOutput().println(msg);
    }

    private static PrintStream getOutput() {
        return System.out;
    }

    public static Object toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String s = sdf.format((Date)object);
            if (s.startsWith("1970-01-01 ")) {
                s = s.substring(11);
            } else if (s.endsWith("00:00:00")) {
                s = s.substring(0, 10);
            }
            return s;
        }
        if (object instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)object;
            String s = d.toString();
            if (s.startsWith("0E")) {
                return "0";
            }
            for (int i = s.indexOf(46) + 3; i < s.length(); ++i) {
                if (s.charAt(i) == '0') continue;
                return s;
            }
            DecimalFormat nf = new DecimalFormat("#,##0.00");
            return nf.format(d);
        }
        return object;
    }
}

