/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.bot.engine.common.LogUtils;
import com.kingdee.eas.base.botp.util.BOTPDBlockTools;
import com.kingdee.eas.base.btp.app.BOTPConfigInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class GzCompressionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(String sourceFolder, String tarGzPath, String loggerName, String mappingName) {
        int fileNumber;
        BOTPConfigInfo botpConfigInfo = BOTPConfigInfo.getConfigInstance();
        int gzNumber = botpConfigInfo.getMaxGzFileNum();
        int gzFileNumber = GzCompressionUtils.getFileNumber(tarGzPath);
        if (gzFileNumber >= gzNumber) {
            File tarGzDir = new File(tarGzPath);
            File[] tarGzFiles = tarGzDir.listFiles();
            GzCompressionUtils.orderByField(tarGzFiles, "lastModified");
            int deleteNum = gzFileNumber - gzNumber + 1;
            for (int i = 0; i < deleteNum; ++i) {
                tarGzFiles[i].delete();
            }
        }
        if ((fileNumber = GzCompressionUtils.getFileNumber(sourceFolder)) > 0) {
            LogUtils.stop(loggerName);
            File sourceDir = new File(sourceFolder);
            File tarGzDir = new File(tarGzPath);
            if (!tarGzDir.exists() && !tarGzDir.isDirectory()) {
                tarGzDir.mkdirs();
            }
            Thread thread = Thread.currentThread();
            long currentTimeMillis = System.currentTimeMillis();
            String tarGzFileName = tarGzPath + File.separator + thread.getId() + "_" + thread.getName() + "_" + currentTimeMillis + "_" + mappingName + ".tar.gz";
            String tempInstanceHome = System.getProperty(BOTPDBlockTools.EAS_INSTANCE_HOME);
            String fileName = (tempInstanceHome + "/logs/botpTrace/" + loggerName + "/BotpTrace.log").replace("/", File.separator);
            String fileSuffix = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
            File[] dirFiles = sourceDir.listFiles();
            if (dirFiles != null && dirFiles.length > 0) {
                for (File dirFile : dirFiles) {
                    if (!dirFile.isDirectory() || !dirFile.getName().contains(loggerName)) continue;
                    FileOutputStream fos = null;
                    BufferedOutputStream bos = null;
                    DeflaterOutputStream gos = null;
                    TarArchiveOutputStream tarOs = null;
                    File target = new File(fileName + "." + fileSuffix + "." + GzCompressionUtils.getFileNumber(dirFile.getPath()));
                    File file = new File(fileName);
                    file.renameTo(target);
                    File[] files = dirFile.listFiles();
                    GzCompressionUtils.orderByField(files, "name");
                    try {
                        fos = new FileOutputStream(tarGzFileName);
                        bos = new BufferedOutputStream(fos);
                        gos = new GZIPOutputStream(bos);
                        tarOs = new TarArchiveOutputStream((OutputStream)gos);
                        tarOs.setLongFileMode(2);
                        for (File logFile : files) {
                            GzCompressionUtils.addFilesToTarGZ(logFile, tarOs);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (tarOs != null) {
                            try {
                                tarOs.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (gos != null) {
                            try {
                                gos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    dirFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilesToTarGZ(File sourceFile, TarArchiveOutputStream tarArchive) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            tarArchive.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(sourceFile, sourceFile.getName()));
            if (sourceFile.isFile()) {
                fis = new FileInputStream(sourceFile);
                bis = new BufferedInputStream(fis);
                IOUtils.copy((InputStream)bis, (OutputStream)tarArchive);
                tarArchive.closeArchiveEntry();
            } else if (sourceFile.isDirectory()) {
                tarArchive.closeArchiveEntry();
                for (File file : sourceFile.listFiles()) {
                    GzCompressionUtils.addFilesToTarGZ(file, tarArchive);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        sourceFile.delete();
    }

    public static void orderByField(File[] files, final String sortField) {
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && o2.isFile()) {
                    return -1;
                }
                if (o1.isFile() && o2.isDirectory()) {
                    return 1;
                }
                if ("name".equals(sortField)) {
                    return GzCompressionUtils.nameCompareTo(o1.getName(), o2.getName());
                }
                return GzCompressionUtils.lastModifiedCompareTo(o1.lastModified(), o2.lastModified());
            }
        });
    }

    public static int nameCompareTo(String name, String otherName) {
        int otherNum;
        String fileSuffix = name.substring(name.lastIndexOf(46) + 1);
        String otherFileSuffix = otherName.substring(otherName.lastIndexOf(46) + 1);
        if ("log".equals(fileSuffix) || "log".equals(otherFileSuffix)) {
            return -1;
        }
        int num = Integer.valueOf(fileSuffix);
        if (num >= (otherNum = Integer.valueOf(otherFileSuffix).intValue())) {
            return 1;
        }
        return -1;
    }

    public static int lastModifiedCompareTo(long lastModified, long otherLastModified) {
        long diff = lastModified - otherLastModified;
        if (diff > 0L) {
            return 1;
        }
        if (diff == 0L) {
            return 0;
        }
        return -1;
    }

    public static int getFileNumber(String fileName) {
        File[] listFiles;
        int count = 0;
        File rootDir = new File(fileName);
        if (rootDir.exists() && rootDir.isDirectory() && (listFiles = rootDir.listFiles()) != null && listFiles.length > 0) {
            count = listFiles.length;
        }
        return count;
    }
}

