/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.provider.BotFuncManager;
import com.kingdee.bos.bot.engine.sql.BotCoreExprAnalyzer;
import com.kingdee.bos.bot.engine.sql.FieldMappingType;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.dom.expr.ArrayIndexerExpr;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.ObjectCreateExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.expr.UnaryExpr;
import com.kingdee.bos.kscript.dom.expr.VectorCreateExpr;
import com.kingdee.bos.metadata.bot.exception.TODOException;
import java.util.List;

public class BotExprSyntaxAnalyzer {
    private boolean isBaseSqlMethodInvoke = false;
    private boolean isBizMethodInvoke = false;
    private boolean isMultiFunc = false;
    private boolean isNestedFunc = false;
    private boolean isComplexSyntax = false;
    private boolean isIdentifier = false;
    private BotCoreExprAnalyzer botCoreExprAnalyzer = null;

    public BotExprSyntaxAnalyzer(BotCoreExprAnalyzer botCoreExprAnalyzer) {
        this.botCoreExprAnalyzer = botCoreExprAnalyzer;
    }

    public boolean isMultiFunc() {
        return this.isMultiFunc;
    }

    protected void setMultiFunc(boolean isMultiFunc) {
        this.isMultiFunc = isMultiFunc;
    }

    public boolean isNestedFunc() {
        return this.isNestedFunc;
    }

    protected void setNestedFunc(boolean isNestedFunc) {
        this.isNestedFunc = isNestedFunc;
    }

    public boolean isComplexSyntax() {
        return this.isComplexSyntax;
    }

    protected void setComplexSyntax(boolean isComplexSyntax) {
        this.isComplexSyntax = isComplexSyntax;
    }

    public void analyzeScriptCodeExpr(CodeExpr expr) throws BOSException, KScriptException {
        this.innerAnalyzeScriptCodeExpr(expr, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void innerAnalyzeScriptCodeExpr(CodeExpr expr, boolean bBizMethodInvokeState) throws BOSException, KScriptException {
        if (expr == null) {
            return;
        }
        if (expr instanceof MethodInvokeExpr) {
            String methodName = ((MethodInvokeExpr)expr).methodName;
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            List paramList = methodInvokeExpr.paramList;
            if (this.isBaseSqlFunction(methodName)) {
                this.isBaseSqlMethodInvoke = true;
                for (int i = 0; i < paramList.size(); ++i) {
                    CodeExpr paramExpr = (CodeExpr)paramList.get(i);
                    this.innerAnalyzeScriptCodeExpr(paramExpr, bBizMethodInvokeState);
                }
                return;
            } else {
                if (!this.isBizFunction(methodName)) throw new BOSException("The method <" + methodName + "> is unsupported!,  expr=" + expr.toString());
                if (bBizMethodInvokeState) {
                    this.isNestedFunc = true;
                } else if (this.isBizMethodInvoke) {
                    this.isMultiFunc = true;
                } else {
                    this.isBizMethodInvoke = true;
                }
                for (int i = 0; i < paramList.size(); ++i) {
                    CodeExpr paramExpr = (CodeExpr)paramList.get(i);
                    this.innerAnalyzeScriptCodeExpr(paramExpr, true);
                }
            }
            return;
        } else {
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                return;
            }
            if (expr instanceof IdentifierExpr) {
                return;
            }
            if (expr instanceof PropertyExpr) {
                return;
            }
            if (expr instanceof UnaryExpr) {
                UnaryExpr unaryExpr = (UnaryExpr)expr;
                this.innerAnalyzeScriptCodeExpr(unaryExpr.expr, bBizMethodInvokeState);
                return;
            } else if (expr instanceof BinaryOpExpr) {
                BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
                this.innerAnalyzeScriptCodeExpr(binaryOpExpr.left, bBizMethodInvokeState);
                this.innerAnalyzeScriptCodeExpr(binaryOpExpr.right, bBizMethodInvokeState);
                return;
            } else if (expr instanceof ObjectCreateExpr) {
                ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
                for (CodeExpr pramExpr : objCreateExpr.paramList) {
                    this.innerAnalyzeScriptCodeExpr(pramExpr, bBizMethodInvokeState);
                }
                return;
            } else if (expr instanceof ArrayIndexerExpr) {
                this.isComplexSyntax = true;
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                this.innerAnalyzeScriptCodeExpr(arrayIndexerExpr.targetObjExpr, bBizMethodInvokeState);
                this.innerAnalyzeScriptCodeExpr(arrayIndexerExpr.indexExpr, bBizMethodInvokeState);
                return;
            } else {
                if (!(expr instanceof VectorCreateExpr)) throw new TODOException();
                this.isComplexSyntax = true;
                VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                    CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                    this.innerAnalyzeScriptCodeExpr(pramExpr, bBizMethodInvokeState);
                }
            }
        }
    }

    protected boolean isBaseSqlFunction(String methodName) {
        BotFuncManager funcManager = this.botCoreExprAnalyzer.getFuncManager();
        return funcManager.isBaseSqlFunction(methodName);
    }

    protected boolean isBizFunction(String methodName) {
        BotFuncManager funcManager = this.botCoreExprAnalyzer.getFuncManager();
        return funcManager.isBizFunction(methodName);
    }

    public FieldMappingType getExprByMappingType() {
        FieldMappingType type = FieldMappingType.newInstance();
        if (this.isComplexSyntax) {
            type.setType(13);
        } else if (this.isNestedFunc) {
            type.setType(11);
        } else if (this.isMultiFunc) {
            type.setType(13);
        } else if (this.isBizMethodInvoke) {
            type.setType(4);
        } else {
            type.setType(2);
        }
        type.setIdentifier(this.isIdentifier);
        return type;
    }
}

