/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.jdom2.Element;

public class BotpMappingExportTransformer {
    static void processChangeMappingFormat(BOTMappingInfo botMappingInfo, Element ele) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader(null);
        MappingUtil.initMappingEntity(botMappingInfo, loader);
        List childs = ele.getContent();
        for (int i = 0; i < childs.size(); ++i) {
            Element tmpEle;
            Element eleSub = (Element)childs.get(i);
            eleSub.removeAttribute("id");
            if (eleSub.getName().equalsIgnoreCase("rules")) {
                List childRules = eleSub.getContent();
                for (int j = 0; j < childRules.size(); ++j) {
                    Element eleRuleInfo = (Element)childRules.get(j);
                    BotpMappingExportTransformer.innerProcessChangeMappingRules(botMappingInfo, eleRuleInfo);
                }
                continue;
            }
            if (eleSub.getName().equalsIgnoreCase("aggregates")) {
                List childAggregates = eleSub.getContent();
                for (int j = 0; j < childAggregates.size(); ++j) {
                    Element eleAggregates = (Element)childAggregates.get(j);
                    BotpMappingExportTransformer.innerProcessChangeMappingAggregates(botMappingInfo, eleAggregates);
                }
                continue;
            }
            if (eleSub.getName().equalsIgnoreCase("BOTExtMappingInfo")) {
                BotpMappingExportTransformer.innerProcessChangeMappingExt(botMappingInfo, eleSub, "filter");
                BotpMappingExportTransformer.innerProcessChangeMappingExt(botMappingInfo, eleSub, "dataFilter");
                eleSub.removeAttribute("isEffected");
                eleSub.removeAttribute("transMode");
                eleSub.removeAttribute("isTemplate");
                eleSub.removeAttribute("errorProcessOption");
                continue;
            }
            if (eleSub.getName().equalsIgnoreCase("BOTRevRuleInfo")) {
                if (eleSub.getContent() == null || eleSub.getContent().size() <= 0) continue;
                tmpEle = (Element)eleSub.getContent().get(0);
                List childRev = tmpEle.getContent();
                for (int j = 0; j < childRev.size(); ++j) {
                    Element eleRev = (Element)childRev.get(j);
                    BotpMappingExportTransformer.innerProcessChangeMappingRev(botMappingInfo, eleRev);
                }
                continue;
            }
            if (!eleSub.getName().equalsIgnoreCase("BOTDelRevRuleInfo") || eleSub.getContent() == null || eleSub.getContent().size() <= 0) continue;
            tmpEle = (Element)eleSub.getContent().get(0);
            List childRev = tmpEle.getContent();
            List childDelRev = tmpEle.getContent();
            for (int j = 0; j < childRev.size(); ++j) {
                Element eleDelRev = (Element)childDelRev.get(j);
                BotpMappingExportTransformer.innerProcessChangeMappingDelRev(botMappingInfo, eleDelRev);
            }
        }
        ele.removeAttribute("id");
        ele.removeAttribute("description");
        ele.removeAttribute("description_l2");
    }

    private static void innerProcessChangeMappingRules(BOTMappingInfo botMappingInfo, Element ele) {
        List childRules = ele.getContent();
        for (int j = 0; j < childRules.size(); ++j) {
            int m;
            Element eleSub = (Element)childRules.get(j);
            if (eleSub.getName().equalsIgnoreCase("ruleSegments")) {
                List childSegment = eleSub.getContent();
                for (m = 0; m < childSegment.size(); ++m) {
                    Element eleSegment = (Element)childSegment.get(m);
                    BotpMappingExportTransformer.innerProcessChangeMappingSegments(botMappingInfo, eleSegment);
                }
                continue;
            }
            if (!eleSub.getName().equalsIgnoreCase("groups")) continue;
            List childGroups = eleSub.getContent();
            for (m = 0; m < childGroups.size(); ++m) {
                Element eleGroup = (Element)childGroups.get(m);
                BotpMappingExportTransformer.innerProcessChangeMappingGroups(botMappingInfo, eleGroup);
            }
        }
        ele.removeAttribute("id");
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(srcEntity, ele, "srcDetailEntryName");
    }

    private static void innerProcessChangeMappingExt(BOTMappingInfo botMappingInfo, Element ele, String filterName) {
        ele.removeAttribute("id");
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        try {
            StringBuffer buff = new StringBuffer();
            String strFilter = ele.getAttributeValue(filterName);
            if (StringUtils.isEmpty((String)strFilter)) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo(strFilter);
            FilterInfo filter = view.getFilter();
            BotpMappingExportTransformer.replaceEntityViewFilterValue(srcEntity, filter, buff);
            FilterCollection entryfilters = view.getEntryFilters();
            for (int i = 0; i < entryfilters.size(); ++i) {
                FilterInfo entryFilter = entryfilters.get(i);
                BotpMappingExportTransformer.replaceEntityViewFilterValue(srcEntity, entryFilter, buff);
            }
            String newStrFilter = buff.toString();
            ele.setAttribute(filterName, newStrFilter);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    private static void replaceEntityViewFilterValue(EntityObjectInfo entity, FilterInfo filter, StringBuffer buff) {
        if (filter == null || filter.getFilterItems() == null) {
            return;
        }
        FilterItemCollection items = filter.getFilterItems();
        String entryName = filter.getEntryName();
        String oldFilterValue = filter.toString();
        if (StringUtils.isEmpty((String)entryName)) {
            for (int i = 0; i < items.size(); ++i) {
                FilterItemInfo item = items.get(i);
                String oldPropName = item.getPropertyName();
                String newPropName = BotpMappingExportTransformer.getPropAliasByEntity(entity, oldPropName);
                oldFilterValue = oldFilterValue.replaceAll(oldPropName, newPropName);
            }
        } else {
            EntityObjectInfo subEntity = BotpMappingExportTransformer.getSubEntityByName(entity, entryName);
            for (int i = 0; i < items.size(); ++i) {
                FilterItemInfo item = items.get(i);
                String oldPropName = item.getPropertyName();
                String newPropName = BotpMappingExportTransformer.getPropAliasByEntity(subEntity, oldPropName);
                oldFilterValue = oldFilterValue.replaceAll(oldPropName, newPropName);
            }
            String newEntryName = BotpMappingExportTransformer.getPropAliasByEntity(entity, entryName);
            oldFilterValue = oldFilterValue.replaceAll(entryName, newEntryName);
        }
        if (buff.length() > 0) {
            buff.append(" AND ");
        }
        buff.append(oldFilterValue);
    }

    private static void innerProcessChangeMappingSegments(BOTMappingInfo botMappingInfo, Element ele) {
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(destEntity, ele, "destPropertyName");
        String newVal = ele.getAttributeValue("alias");
        if (newVal != null) {
            ele.setAttribute("srcPropertyName", newVal);
        } else {
            ele.setAttribute("srcPropertyName", "");
        }
        ele.removeAttribute("alias");
        ele.removeAttribute("id");
        ele.removeAttribute("isRegInRelation");
        ele.removeAttribute("RefObjectId");
        ele.removeAttribute("canModify");
        ele.removeAttribute("alias_l2");
        ele.removeAttribute("alias_l3");
        if (ele.getContent() != null && ele.getContent().size() > 0) {
            Element eleRegSub = (Element)ele.getContent().get(0);
            BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(srcEntity, eleRegSub, "srcPropertyName");
        }
    }

    private static void innerProcessChangeMappingGroups(BOTMappingInfo botMappingInfo, Element ele) {
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(destEntity, ele, "groupingProperty");
        ele.removeAttribute("id");
    }

    private static void innerProcessChangeMappingAggregates(BOTMappingInfo botMappingInfo, Element ele) {
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(destEntity, ele, "propertyName");
        ele.removeAttribute("id");
    }

    private static void innerProcessChangeMappingRev(BOTMappingInfo botMappingInfo, Element ele) {
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(srcEntity, ele, "destPropertyName");
        ele.removeAttribute("id");
    }

    private static void innerProcessChangeMappingDelRev(BOTMappingInfo botMappingInfo, Element ele) {
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        BotpMappingExportTransformer.innerReplaceElementPropValueByEntity(srcEntity, ele, "destPropertyName");
        ele.removeAttribute("id");
    }

    private static void innerReplaceElementPropValueByEntity(EntityObjectInfo entity, Element ele, String attrName) {
        boolean jj = false;
        String oldValue = ele.getAttributeValue(attrName);
        String newValue = BotpMappingExportTransformer.getPropAliasByEntity(entity, oldValue);
        String strEntityName = entity.getAlias() + ".";
        ele.setAttribute(attrName, strEntityName + newValue);
    }

    private static EntityObjectInfo getSubEntityByName(EntityObjectInfo entity, String subEntityName) {
        IObjectValue objProp = entity.getInheritedNoDuplicatedProperties().getObject((Object)subEntityName);
        if (objProp != null && objProp instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkInfo = (LinkPropertyInfo)objProp;
            RelationshipInfo relation = linkInfo.getRelationship();
            EntityObjectInfo suppEntity = relation.getSupplierObject();
            return suppEntity;
        }
        return entity;
    }

    private static String getPropAliasByEntity(EntityObjectInfo entity, String propName) {
        String alias = "";
        EntityObjectInfo currEntity = entity;
        if (!StringUtils.isEmpty((String)propName)) {
            for (String name : propName.split("\\.")) {
                IObjectValue objProp = currEntity.getInheritedNoDuplicatedProperties().getObject((Object)name);
                if (StringUtils.isEmpty((String)name) || name.equalsIgnoreCase("__src") || name.equalsIgnoreCase("__dest") || objProp == null) continue;
                if (!StringUtils.isEmpty((String)alias)) {
                    alias = alias + ".";
                }
                if (objProp instanceof OwnPropertyInfo) {
                    alias = alias + ((OwnPropertyInfo)objProp).getAlias();
                    continue;
                }
                if (!(objProp instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkInfo = (LinkPropertyInfo)objProp;
                alias = alias + linkInfo.getAlias();
                currEntity = BotpMappingExportTransformer.getSubEntityByName(currEntity, name);
            }
        }
        return alias;
    }
}

