/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTRuleFilterTools {
    private static Logger logger = Logger.getLogger(BOTRuleFilterTools.class);
    private static final String BOTP_IS_SHOWRULES_WITHFILTER = "BOTP_IS_SHOWRULES_WITHFILTER";

    public static IObjectCollection getMappingCollectionByRuleFilter(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext, String[] srcBillIDs, String[] entrieNames, List entriesKeys, SelectorItemCollection botpSelectors) throws BOSException, BOTPException {
        String numberFlag;
        Object object;
        String orglongNumber = null;
        BOTMappingCollection newBotMappingCols = new BOTMappingCollection();
        String transmitCuId = null;
        if (transmitContext == null) {
            transmitCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        } else {
            transmitCuId = (String)transmitContext.get("TRANSMITCU_ID");
            if (StringUtils.isEmpty((String)transmitCuId)) {
                Object transmitCu = transmitContext.get("TRANSMITCU");
                transmitCuId = transmitCu != null && transmitCu instanceof CtrlUnitInfo ? ((CtrlUnitInfo)transmitCu).getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            }
        }
        String[] orgIDs = null;
        if (!BOTPTools.isCtrlUintAuthor(ctx)) {
            orgIDs = new String[]{transmitCuId, "00000000-0000-0000-0000-000000000000CCE7AED4"};
        } else {
            try {
                CtrlUnitInfo orgCu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo("select id,longNumber where id ='" + transmitCuId + "'");
                orglongNumber = orgCu.getLongNumber().toString();
                Object[] orgNumbers = orglongNumber.split("!");
                orgIDs = new String[orgNumbers.length];
                FilterInfo filterInfo = new FilterInfo();
                String strNumberLists = StringUtils.arrayToString((Object[])orgNumbers, (String)",");
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strNumberLists, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                entityViewInfo.setFilter(filterInfo);
                SorterItemCollection sic = new SorterItemCollection();
                SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
                sortInfo.setSortType(SortType.DESCEND);
                sic.add(sortInfo);
                entityViewInfo.setSorter(sic);
                CtrlUnitCollection cucol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
                for (int i = 0; i < orgIDs.length; ++i) {
                    orgIDs[i] = cucol.get(i).getId().toString();
                }
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        Boolean isPreview = false;
        if (transmitContext != null && (object = transmitContext.get("isPreview")) != null) {
            isPreview = (Boolean)object;
            transmitContext.remove("isPreview");
        }
        BOTMappingCollection retBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < orgIDs.length; ++i) {
            newBotMappingCols = (BOTMappingCollection)BOTRuleFilterTools.getMappingByCUAfterCheck(ctx, srcBillType, targetBosType, defineSys, orgIDs[i], srcBillIDs, entrieNames, entriesKeys, botpSelectors, isPreview);
            if (newBotMappingCols.size() <= 0) continue;
            if (BOTRuleFilterTools.hasSuperCtrlUnit(ctx)) {
                for (int j = 0; j < newBotMappingCols.size(); ++j) {
                    retBotMappingCols.add(newBotMappingCols.get(j));
                }
                continue;
            }
            return newBotMappingCols;
        }
        DefineSysEnum defineSysObj = (DefineSysEnum)((Object)ctx.get((Object)"defineSysFlag"));
        if (DefineSysEnum.DAP.equals((Object)defineSysObj) && ctx.get((Object)"existSome") != null && "true".equals((String)ctx.get((Object)"existSome"))) {
            String notConformBillNumber = (String)ctx.get((Object)"existNumber");
            ctx.remove((Object)"existSome");
            ctx.remove((Object)"existNumber");
            if (retBotMappingCols.size() == 0) {
                throw new BOTPException(BOTPException.HASSOMENOCONFORMMAPPING, new Object[]{notConformBillNumber});
            }
        }
        if ("1".equals(numberFlag = (String)ctx.get((Object)"numberFlag")) && retBotMappingCols.size() == 0) {
            throw new BOTPException(BOTPException.NOCONFORMMAPPING);
        }
        return retBotMappingCols;
    }

    public static boolean hasSuperCtrlUnit(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"BOTP_HAS_SUPER_CTRLUNIT");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static BOTMappingCollection checkBotMapping(Context ctx, String[] srcBillIDs, String[] entrieNames, List entriesKeys, BOTMappingCollection newBotMappingCols, BOTMappingCollection botMappingCols, boolean isPreview) throws BOSException, BOTPException {
        BOTMappingCollection checkBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < botMappingCols.size(); ++i) {
            BOTMappingInfo mappingInfo = botMappingCols.get(i);
            if (isPreview && BOTRuleFilterTools.isExistBOTRuleFilter4Pre(mappingInfo)) {
                checkBotMappingCols.add(mappingInfo);
                continue;
            }
            if (!isPreview && BOTRuleFilterTools.isExistBOTRuleFilter(mappingInfo)) {
                checkBotMappingCols.add(mappingInfo);
                continue;
            }
            newBotMappingCols.add(mappingInfo);
        }
        if (checkBotMappingCols.size() > 0) {
            String currId = srcBillIDs[0];
            BOSUuid uuid = BOSUuid.read((String)currId);
            BOSObjectType bosType = uuid.getType();
            HashMap<String, Object> entriesKeysMap = new HashMap<String, Object>();
            if (entriesKeys != null && entriesKeys.size() > 0) {
                for (int k = 0; k < entriesKeys.size(); ++k) {
                    entriesKeysMap.put(entriesKeys.get(k).toString(), null);
                }
            }
            DefineSysEnum defineSysObj = (DefineSysEnum)((Object)ctx.get((Object)"defineSysFlag"));
            for (int i = 0; i < checkBotMappingCols.size(); ++i) {
                BOTMappingInfo mappingInfo = checkBotMappingCols.get(i);
                if (!isPreview && !BOTRuleFilterTools.checkIsErrorBotpRuleFilterByStep(ctx, bosType, srcBillIDs, entrieNames, entriesKeysMap, mappingInfo)) {
                    newBotMappingCols.add(mappingInfo);
                } else if (isPreview && !BOTRuleFilterTools.checkIsErrorBotpRuleFilterByStep4Pre(ctx, bosType, srcBillIDs, entrieNames, entriesKeysMap, mappingInfo)) {
                    newBotMappingCols.add(mappingInfo);
                }
                String botpExceptionFlag = (String)ctx.get((Object)"botpExceptionFlag");
                if (!DefineSysEnum.DAP.equals((Object)defineSysObj) || !"0".equals(botpExceptionFlag)) continue;
                String notConformBillNumber = (String)ctx.get((Object)"notConformNumber");
                if (ctx.get((Object)"existSome") != null) continue;
                ctx.put((Object)"existSome", (Object)"true");
                ctx.put((Object)"existNumber", (Object)notConformBillNumber);
            }
        }
        return newBotMappingCols;
    }

    public static EntityViewInfo getRuleFilter(String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException {
        HashMap result = new HashMap();
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BOTRuleFilterTools.getBOTRuleFilterByMapping(mappingInfo);
        FilterInfo filterInfo = evi.getFilter();
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return null;
        }
        evi.getSelector().add("id");
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i = 0; i < count; ++i) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        ArrayList<String> billIdList = new ArrayList<String>();
        int count = srcBillIDs.length;
        for (int i = 0; i < count; ++i) {
            billIdList.add(srcBillIDs[i]);
        }
        FilterInfo newHeadFilterInfo = BOTRuleFilterTools.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        String e = evi.toString();
        return evi;
    }

    public static EntityViewInfo getRuleFilter4Pre(String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException {
        HashMap result = new HashMap();
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BOTRuleFilterTools.getBOTRuleFilterByMapping4Pre(mappingInfo);
        FilterInfo filterInfo = evi.getFilter();
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return null;
        }
        evi.getSelector().add("id");
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i = 0; i < count; ++i) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        ArrayList<String> billIdList = new ArrayList<String>();
        int count = srcBillIDs.length;
        for (int i = 0; i < count; ++i) {
            billIdList.add(srcBillIDs[i]);
        }
        FilterInfo newHeadFilterInfo = BOTRuleFilterTools.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        String e = evi.toString();
        return evi;
    }

    public static EntityViewInfo getBOTRuleFilterByMapping(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    public static EntityViewInfo getBOTRuleFilterByMapping4Pre(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter4Pre()) && StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            if (!StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter4Pre())) {
                try {
                    entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 2);
                }
                catch (BOSException exc) {
                    throw new BOSException(exc.getMessage(), (Throwable)exc);
                }
            }
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    public static boolean isExistBOTRuleFilter(BOTMappingInfo mappingInfo) throws BOSException {
        String strFilter = mappingInfo.getExtRule().getFilter();
        if (StringUtils.isEmpty((String)strFilter)) {
            return false;
        }
        EntityViewInfo view = null;
        try {
            view = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
        }
        catch (BOSException exc) {
            throw new BOSException(exc.getMessage(), (Throwable)exc);
        }
        FilterInfo filterInfo = view.getFilter();
        return filterInfo != null && filterInfo.getFilterItems().size() != 0 || view.getEntryFilters() != null && view.getEntryFilters().size() != 0;
    }

    public static boolean isExistBOTRuleFilter4Pre(BOTMappingInfo mappingInfo) throws BOSException {
        String strFilter = mappingInfo.getExtRule().getFilter4Pre();
        if (StringUtils.isEmpty((String)strFilter) && StringUtils.isEmpty((String)(strFilter = mappingInfo.getExtRule().getFilter()))) {
            return false;
        }
        EntityViewInfo view = null;
        try {
            view = !StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter4Pre()) ? BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 2) : BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
        }
        catch (BOSException exc) {
            throw new BOSException(exc.getMessage(), (Throwable)exc);
        }
        FilterInfo filterInfo = view.getFilter();
        return filterInfo != null && filterInfo.getFilterItems().size() != 0 || view.getEntryFilters() != null && view.getEntryFilters().size() != 0;
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        if (idList.size() <= 0) {
            return filterInfo;
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public static void checkMappingInfoByRuleFilter(Context ctx, IObjectCollection srcBillColl, BOTMappingInfo mappingInfo) throws BOSException, EASBizException {
        if (srcBillColl == null || srcBillColl.size() <= 0) {
            return;
        }
        String[] srcBillIDs = BOTRuleFilterTools.getBillIDs(srcBillColl);
        BOTRuleFilterTools.validateByRuleFilter(ctx, srcBillColl.getObject(0).getBOSType(), srcBillIDs, mappingInfo);
    }

    private static String[] getBillIDs(IObjectCollection billColl) {
        int count = billColl.size();
        String[] idList = new String[count];
        for (int i = 0; i < count; ++i) {
            Object value = billColl.getObject(i).get("id");
            if (value instanceof String) {
                idList[i] = (String)value;
                continue;
            }
            if (!(value instanceof BOSUuid)) continue;
            idList[i] = ((BOSUuid)value).toString();
        }
        return idList;
    }

    public static void validateByRuleFilter(Context ctx, BOSObjectType bosType, String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException, EASBizException {
        if (BOTRuleFilterTools.checkIsErrorBotpRuleFilterByStep(ctx, bosType, srcBillIDs, null, null, mappingInfo)) {
            throw new BTPException(BTPException.FAILBYFILTER);
        }
    }

    private static boolean checkIsErrorBotpRuleFilterByStep(Context ctx, BOSObjectType bosType, String[] srcBillIDs, String[] entrieNames, Map entriesKeysMap, BOTMappingInfo mappingInfo) throws BOSException {
        int i;
        ctx.remove((Object)"botpExceptionFlag");
        ctx.remove((Object)"notConformNumber");
        int iStep = 800;
        int iTotal = srcBillIDs.length;
        int iMax = iTotal % iStep == 0 ? iTotal / iStep : iTotal / iStep + 1;
        boolean bAllEmptyViewFilter = true;
        CoreBillBaseCollection realObjectCols = null;
        int resultSize = 0;
        EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping(mappingInfo);
        boolean hasEntryFilter = false;
        if (view.getEntryFilters() != null && view.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
        }
        for (int i2 = 0; i2 < iMax; ++i2) {
            int iTempTotal = iStep;
            if (i2 == iMax - 1 && iMax * iStep != iTotal) {
                iTempTotal = iTotal % iStep;
            }
            int iStart = i2 * iStep;
            int iEnd = iStart + iTempTotal;
            String[] newIDs = new String[iTempTotal];
            for (int j = 0; j < iTempTotal; ++j) {
                newIDs[j] = srcBillIDs[iStart + j];
            }
            EntityViewInfo stepView = BOTRuleFilterTools.getRuleFilter(newIDs, mappingInfo);
            if (stepView == null) continue;
            bAllEmptyViewFilter = false;
            stepView.setBaseOnSelector(true);
            CoreBillBaseCollection filteredCols = BOTRuleFilterTools.getSrcBillCollection(ctx, bosType.toString(), stepView);
            if (filteredCols == null || filteredCols.size() <= 0) continue;
            if (realObjectCols == null) {
                realObjectCols = filteredCols;
                continue;
            }
            resultSize += filteredCols.size();
            realObjectCols.addObjectCollection((IObjectCollection)filteredCols);
        }
        if (bAllEmptyViewFilter) {
            return false;
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return true;
        }
        if (entriesKeysMap != null && entrieNames != null && entriesKeysMap.size() > 0 && entrieNames[0] != null) {
            BOTRuleFilterTools.removeUnSelect(entriesKeysMap, realObjectCols, entrieNames[0]);
        }
        if (hasEntryFilter) {
            int n = view.getEntryFilters().size();
            for (int j = 0; j < n; ++j) {
                String entryName = view.getEntryFilters().get(j).getEntryName();
                for (i = realObjectCols.size() - 1; i >= 0; --i) {
                    IObjectValue filteredInfo = realObjectCols.getObject(i);
                    Object objColl = filteredInfo.get(entryName);
                    if (objColl != null && objColl instanceof IObjectCollection && ((IObjectCollection)objColl).size() > 0) continue;
                    realObjectCols.removeObject(i);
                }
            }
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return true;
        }
        if (realObjectCols.size() != srcBillIDs.length) {
            List<String> srcIdList = Arrays.asList(srcBillIDs);
            ArrayList<String> arrayList = new ArrayList<String>(srcIdList);
            EntityViewInfo stepView = new EntityViewInfo();
            stepView.getSelector().add("number");
            stepView.setBaseOnSelector(true);
            for (i = 0; i < realObjectCols.size(); ++i) {
                CoreBillBaseInfo coreBillBaseInfo = realObjectCols.get(i);
                String id = coreBillBaseInfo.get("id").toString();
                arrayList.remove(id);
            }
            FilterInfo filterInfo = new FilterInfo();
            String strIdLists = StringUtils.arrayToString((Object[])arrayList.toArray(), (String)",");
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
            stepView.setFilter(filterInfo);
            CoreBillBaseCollection srcBillList = BOTRuleFilterTools.getSrcBillCollection(ctx, bosType.toString(), stepView);
            StringBuilder numString = new StringBuilder();
            if (srcBillList != null) {
                for (int i3 = 0; i3 < srcBillList.size(); ++i3) {
                    CoreBillBaseInfo coreBillBaseInfo = srcBillList.get(i3);
                    String id = coreBillBaseInfo.get("id").toString();
                    String number = coreBillBaseInfo.get("number").toString();
                    if (i3 == srcBillList.size() - 1) {
                        numString.append(number + "#" + id);
                        continue;
                    }
                    numString.append(number + "#" + id + "\u3001");
                }
            }
            ctx.put((Object)"botpExceptionFlag", (Object)"0");
            ctx.put((Object)"notConformNumber", (Object)numString.toString());
            return true;
        }
        return false;
    }

    private static boolean checkIsErrorBotpRuleFilterByStep4Pre(Context ctx, BOSObjectType bosType, String[] srcBillIDs, String[] entrieNames, Map entriesKeysMap, BOTMappingInfo mappingInfo) throws BOSException {
        int i;
        ctx.remove((Object)"botpExceptionFlag");
        ctx.remove((Object)"notConformNumber");
        int iStep = 800;
        int iTotal = srcBillIDs.length;
        int iMax = iTotal % iStep == 0 ? iTotal / iStep : iTotal / iStep + 1;
        boolean bAllEmptyViewFilter = true;
        CoreBillBaseCollection realObjectCols = null;
        int resultSize = 0;
        EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping4Pre(mappingInfo);
        boolean hasEntryFilter = false;
        if (view.getEntryFilters() != null && view.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
        }
        for (int i2 = 0; i2 < iMax; ++i2) {
            int iTempTotal = iStep;
            if (i2 == iMax - 1 && iMax * iStep != iTotal) {
                iTempTotal = iTotal % iStep;
            }
            int iStart = i2 * iStep;
            int iEnd = iStart + iTempTotal;
            String[] newIDs = new String[iTempTotal];
            for (int j = 0; j < iTempTotal; ++j) {
                newIDs[j] = srcBillIDs[iStart + j];
            }
            EntityViewInfo stepView = BOTRuleFilterTools.getRuleFilter4Pre(newIDs, mappingInfo);
            if (stepView == null) continue;
            bAllEmptyViewFilter = false;
            stepView.setBaseOnSelector(true);
            CoreBillBaseCollection filteredCols = BOTRuleFilterTools.getSrcBillCollection(ctx, bosType.toString(), stepView);
            if (filteredCols == null || filteredCols.size() <= 0) continue;
            if (realObjectCols == null) {
                realObjectCols = filteredCols;
                continue;
            }
            resultSize += filteredCols.size();
            realObjectCols.addObjectCollection((IObjectCollection)filteredCols);
        }
        if (bAllEmptyViewFilter) {
            return false;
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return true;
        }
        if (entriesKeysMap != null && entrieNames != null && entriesKeysMap.size() > 0 && entrieNames[0] != null) {
            BOTRuleFilterTools.removeUnSelect(entriesKeysMap, realObjectCols, entrieNames[0]);
        }
        if (hasEntryFilter) {
            int n = view.getEntryFilters().size();
            for (int j = 0; j < n; ++j) {
                String entryName = view.getEntryFilters().get(j).getEntryName();
                for (i = realObjectCols.size() - 1; i >= 0; --i) {
                    IObjectValue filteredInfo = realObjectCols.getObject(i);
                    Object objColl = filteredInfo.get(entryName);
                    if (objColl != null && objColl instanceof IObjectCollection && ((IObjectCollection)objColl).size() > 0) continue;
                    realObjectCols.removeObject(i);
                }
            }
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return true;
        }
        if (realObjectCols.size() != srcBillIDs.length) {
            List<String> srcIdList = Arrays.asList(srcBillIDs);
            ArrayList<String> arrayList = new ArrayList<String>(srcIdList);
            EntityViewInfo stepView = new EntityViewInfo();
            stepView.getSelector().add("number");
            stepView.setBaseOnSelector(true);
            for (i = 0; i < realObjectCols.size(); ++i) {
                CoreBillBaseInfo coreBillBaseInfo = realObjectCols.get(i);
                String id = coreBillBaseInfo.get("id").toString();
                arrayList.remove(id);
            }
            FilterInfo filterInfo = new FilterInfo();
            String strIdLists = StringUtils.arrayToString((Object[])arrayList.toArray(), (String)",");
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
            stepView.setFilter(filterInfo);
            CoreBillBaseCollection srcBillList = BOTRuleFilterTools.getSrcBillCollection(ctx, bosType.toString(), stepView);
            StringBuilder numString = new StringBuilder();
            if (srcBillList != null) {
                for (int i3 = 0; i3 < srcBillList.size(); ++i3) {
                    CoreBillBaseInfo coreBillBaseInfo = srcBillList.get(i3);
                    String number = coreBillBaseInfo.get("number").toString();
                    if (i3 == srcBillList.size() - 1) {
                        numString.append(number);
                        continue;
                    }
                    numString.append(number + "\u3001");
                }
            }
            ctx.put((Object)"botpExceptionFlag", (Object)"0");
            ctx.put((Object)"notConformNumber", (Object)numString.toString());
            return true;
        }
        return false;
    }

    private static void removeUnSelect(Map entriesKeyMap, CoreBillBaseCollection sourceBillCollection, String entryName) {
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bills = sourceBillCollection.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                if (entriesKeyMap.containsKey(cInfo.get("id").toString())) continue;
                iters.remove();
            }
        }
    }

    protected static CoreBillBaseCollection getSrcBillCollection(Context ctx, String srcBillType, EntityViewInfo evi) throws BOSException {
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    public static boolean isShowBOTPWithRuleFilter(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)BOTP_IS_SHOWRULES_WITHFILTER);
            return !"FALSE".equalsIgnoreCase(value);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static IObjectCollection getMappingByCUAfterCheck(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, String transmitID, String[] srcBillIDs, String[] entrieNames, List entriesKeys, SelectorItemCollection botpSelectors, boolean isPreview) throws BOTPException, BOSException {
        BOTMappingCollection newBotMappingCols = new BOTMappingCollection();
        BOTMappingCollection botMappingCols = BOTMappingHelper.getMappingForSelectByCU(ctx, srcBillType, targetBosType, defineSys, transmitID);
        if (!BOTRuleFilterTools.isShowBOTPWithRuleFilter(ctx)) {
            return botMappingCols;
        }
        if (botMappingCols == null || botMappingCols.size() <= 0 || srcBillIDs == null || srcBillIDs.length <= 0) {
            return botMappingCols;
        }
        ctx.put((Object)"defineSysFlag", (Object)defineSys);
        newBotMappingCols = BOTRuleFilterTools.checkBotMapping(ctx, srcBillIDs, entrieNames, entriesKeys, newBotMappingCols, botMappingCols, isPreview);
        ctx.put((Object)"numberFlag", (Object)"1");
        return newBotMappingCols;
    }
}

