/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.app.BOTPConfigInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTBillCache {
    private static final Logger logger = Logger.getLogger((String)BOTBillCache.class.getName());
    private final Map cache = new HashMap();
    private final LinkedList cacheQueue;
    private final Map sizeMap = new HashMap();
    private Context ctx;
    private static String DEFAULT_ENTRYNAME = "entries";
    private static Integer entryNumber = new Integer(0);
    private static int queueMax = 0;
    private static Map entryName = new HashMap();
    private static ThreadLocal threadCtx = new ThreadLocal(){

        protected Object initialValue() {
            return new BOTBillCache();
        }
    };

    private BOTBillCache() {
        this.cacheQueue = new LinkedList();
    }

    private void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public static BOTBillCache getInstance(Context ctx) {
        BOTBillCache botCache = (BOTBillCache)threadCtx.get();
        botCache.setContext(ctx);
        queueMax = BOTPConfigInfo.getConfigInstance().getMaxCacheNum();
        return botCache;
    }

    public IObjectValue get(String objId) throws DataAccessException {
        return (IObjectValue)this.cache.get(objId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object objId, Object obj) {
        if (objId == null || this.cache.containsKey(objId)) {
            return;
        }
        BOSObjectType type = BOSUuid.getBOSObjectType((String)objId.toString(), (boolean)true);
        int size = this.getEntryNumber(type, obj);
        if (size > queueMax) {
            return;
        }
        Integer n = entryNumber;
        synchronized (n) {
            if (entryNumber <= queueMax - size) {
                this.innerPutObject(objId.toString(), obj, size);
            } else {
                this.innerPutObject(objId, obj, size);
                while (entryNumber > queueMax && this.cacheQueue.size() > 0) {
                    Object removedKey = this.cacheQueue.removeFirst();
                    this.removeCache(removedKey);
                }
            }
        }
    }

    private synchronized void innerPutObject(Object objId, Object obj, int size) {
        this.cache.put(objId, obj);
        this.cacheQueue.add(objId);
        this.sizeMap.put(objId, new Integer(size));
        entryNumber = new Integer(entryNumber + size);
    }

    private synchronized void removeCache(Object removedKey) {
        Object tempObj = this.cache.get(removedKey);
        if (tempObj != null && this.sizeMap.get(((IObjectValue)tempObj).get("id").toString()) != null) {
            String key = ((IObjectValue)tempObj).get("id").toString();
            this.cache.remove(key);
            this.cacheQueue.remove(key);
            Integer size = (Integer)this.sizeMap.get(key);
            this.sizeMap.remove(key);
            entryNumber = new Integer(entryNumber - size);
        } else {
            logger.error((Object)"cache and cacheQueue are not synchronized!");
            this.removeAllCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCache() {
        Integer n = entryNumber;
        synchronized (n) {
            logger.error((Object)("entryNumber:" + entryNumber + "queueMax" + queueMax));
            for (Map.Entry m : this.sizeMap.entrySet()) {
                Integer size = (Integer)m.getValue();
                entryNumber = new Integer(entryNumber - size);
            }
            this.sizeMap.clear();
            this.cacheQueue.clear();
            this.cache.clear();
        }
    }

    private int getEntryNumber(BOSObjectType bosType, Object obj) {
        if (obj instanceof CoreBillEntryBaseInfo) {
            return 1;
        }
        if (!(obj instanceof CoreBillBaseInfo)) {
            logger.error((Object)"obj type error for BOTBillCache!!");
        }
        String name = null;
        name = DEFAULT_ENTRYNAME;
        if (((CoreBillBaseInfo)obj).get(name) == null || !(((CoreBillBaseInfo)obj).get(name) instanceof IObjectCollection)) {
            return 1;
        }
        int size = 0;
        IObjectCollection billBaseEntries = (IObjectCollection)((CoreBillBaseInfo)obj).get(name.toString());
        if (billBaseEntries != null) {
            size = billBaseEntries.size();
        }
        if (size == 0) {
            return 1;
        }
        return size;
    }

    private boolean checkIsEntryLink(LinkPropertyInfo property, EntityObjectInfo parentEntity) {
        RelationshipInfo relation = property.getRelationship();
        return relation.getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"));
    }

    public int getMaxEntryNum() {
        return entryNumber * 100 / BOTPConfigInfo.getConfigInstance().getMaxCacheNum();
    }
}

