/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BOTPConfigInfo {
    private static final Logger logger = Logger.getLogger(BOTPConfigInfo.class);
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.properties.dir";
    public static final String CONFIG_FILE_NAME = "BotpConfig.xml";
    private boolean isOpenBatchPreCache = false;
    private boolean isMemCacheOpen = false;
    private boolean isMappingCacheOpen = false;
    private boolean isCreateFromInOrder = false;
    private int maxCacheNum = 1000;
    private boolean isThrowAllException = true;
    private String DAPServerUrl;
    private String port;
    private String DAPServerUrl2;
    private String port2;
    private String DAPAccess;
    private String DAPDcName;
    private String DAPDcName2;
    private String DAPLocalDcName;
    private String DAPLanguage;
    private boolean isUseMutex = true;
    private boolean isLockSrcTable = true;
    private int maxGzFileNum = 20;
    private static BOTPConfigInfo botpConfigInfo = null;
    private static String BOTPPREBATCHCACHE = "isOpenBatchPreCache";
    private static String BOTPCACHELIMIT = "maxCacheNum";
    private static String BOTPMemCache = "isMemCacheOpen";
    private static String BOTPMappingCache = "isMappingCacheOpen";
    private static String ISCREATEFROMINORDER = "isCreateFromInOrder";
    private static String DAPSERVERURL = "DAPServerUrl";
    private static String PORT = "port";
    private static String DAPSERVERURL2 = "DAPServerUrl2";
    private static String PORT2 = "port2";
    private static String DAPACCESS = "DAPAccess";
    private static String DAPDCNAME = "DAPDcName";
    private static String DAPDCNAME2 = "DAPDcName2";
    private static String DAPDLOCALDCNAME = "DAPLocalDcName";
    private static String DAPLANGUAGE = "DAPlanguage";
    private static String ISTHROWALLEXCEPTION = "isThrowAllException";
    private static String ISLOCKSRCTABLE = "isLockSrcTable";
    private static String BOTPGZFILELIMIT = "maxGzFileNum";

    private BOTPConfigInfo() {
    }

    public static synchronized BOTPConfigInfo getConfigInstance() {
        if (botpConfigInfo == null) {
            botpConfigInfo = new BOTPConfigInfo();
            botpConfigInfo.loadConfig();
        }
        return botpConfigInfo;
    }

    public boolean isOpenBatchPreCache() {
        return this.isOpenBatchPreCache;
    }

    public int getMaxCacheNum() {
        return this.maxCacheNum;
    }

    public int getMaxGzFileNum() {
        return this.maxGzFileNum;
    }

    public void reload() {
        botpConfigInfo.loadConfig();
    }

    public void setOpenBatchPreCache(boolean isOpenBatchPreCache) {
        this.isOpenBatchPreCache = isOpenBatchPreCache;
    }

    public void setMaxCacheNum(int maxCacheNum) {
        this.maxCacheNum = maxCacheNum;
    }

    public void setMaxGzFileNum(int maxGzFileNum) {
        this.maxGzFileNum = maxGzFileNum;
    }

    public boolean isMappingCacheOpen() {
        return this.isMappingCacheOpen;
    }

    public void setMappingCacheOpen(boolean isMappingCacheOpen) {
        this.isMappingCacheOpen = isMappingCacheOpen;
    }

    public boolean isCreateFromInOrder() {
        return this.isCreateFromInOrder;
    }

    public void setCreateFromInOrder(boolean isCreateFromInOrder) {
        this.isCreateFromInOrder = isCreateFromInOrder;
    }

    public boolean isMemCacheOpen() {
        return this.isMemCacheOpen;
    }

    public void setMemCacheOpen(boolean isMemCacheOpen) {
        this.isMemCacheOpen = isMemCacheOpen;
    }

    public boolean isThrowAllException() {
        return this.isThrowAllException;
    }

    public void setThrowAllException(boolean isThrowAllException) {
        this.isThrowAllException = isThrowAllException;
    }

    public String getDAPServerUrl() {
        return this.DAPServerUrl;
    }

    public String getPort() {
        return this.port;
    }

    public String getDAPServerUrl2() {
        return this.DAPServerUrl2;
    }

    public String getPort2() {
        return this.port2;
    }

    public String getDAPAccess() {
        return this.DAPAccess;
    }

    public String getDAPDcName() {
        return this.DAPDcName;
    }

    public String getDAPDcName2() {
        return this.DAPDcName2;
    }

    public String getDAPLocalDcName() {
        return this.DAPLocalDcName;
    }

    public String getDAPLanguage() {
        return this.DAPLanguage;
    }

    public boolean isUseMutex() {
        return this.isUseMutex;
    }

    public void setUseMutex(boolean isUseMutex) {
        this.isUseMutex = isUseMutex;
    }

    public boolean isLockSrcTable() {
        return this.isLockSrcTable;
    }

    public void setLockSrcTable(boolean isLockSrcTable) {
        this.isLockSrcTable = isLockSrcTable;
    }

    private void loadConfig() {
        String configPath = System.getProperty(PROPERTIES_DIR_ENV_NAME);
        File configFile = new File(configPath, CONFIG_FILE_NAME);
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(false);
        try {
            org.jdom2.Document doc = builder.build(configFile);
            Element root = doc.getRootElement();
            if (root != null) {
                String openBatchPreCache = root.getAttributeValue(BOTPPREBATCHCACHE);
                String cacheMax = root.getAttributeValue(BOTPCACHELIMIT);
                String openMemCache = root.getAttributeValue(BOTPMemCache);
                String openMappingCache = root.getAttributeValue(BOTPMappingCache);
                String createFromInOrder = root.getAttributeValue(ISCREATEFROMINORDER);
                String isThrowAllException = root.getAttributeValue(ISTHROWALLEXCEPTION);
                String DAPServerUrl = root.getAttributeValue(DAPSERVERURL);
                String port = root.getAttributeValue(PORT);
                String DAPServerUrl2 = root.getAttributeValue(DAPSERVERURL2);
                String port2 = root.getAttributeValue(PORT2);
                String DAPAccess = root.getAttributeValue(DAPACCESS);
                String DAPDcName = root.getAttributeValue(DAPDCNAME);
                String DAPDcName2 = root.getAttributeValue(DAPDCNAME2);
                String DAPLocalDcName = root.getAttributeValue(DAPDLOCALDCNAME);
                String DAPLanguage = root.getAttributeValue(DAPLANGUAGE);
                String isLockSrcTable = root.getAttributeValue(ISLOCKSRCTABLE);
                String fileMax = root.getAttributeValue(BOTPGZFILELIMIT);
                if (openBatchPreCache != null) {
                    this.isOpenBatchPreCache = Boolean.valueOf(openBatchPreCache);
                }
                if (cacheMax != null) {
                    this.maxCacheNum = Integer.parseInt(cacheMax);
                }
                if (openMemCache != null) {
                    this.isMemCacheOpen = Boolean.valueOf(openMemCache);
                }
                if (openMappingCache != null) {
                    this.isMappingCacheOpen = Boolean.valueOf(openMappingCache);
                }
                if (createFromInOrder != null) {
                    this.isCreateFromInOrder = Boolean.valueOf(createFromInOrder);
                }
                if (isThrowAllException != null) {
                    this.isThrowAllException = Boolean.valueOf(isThrowAllException);
                }
                if (DAPServerUrl != null) {
                    this.DAPServerUrl = DAPServerUrl;
                }
                if (port != null) {
                    this.port = port;
                }
                if (DAPServerUrl2 != null) {
                    this.DAPServerUrl2 = DAPServerUrl2;
                }
                if (port2 != null) {
                    this.port2 = port2;
                }
                if (DAPAccess != null) {
                    this.DAPAccess = DAPAccess;
                }
                if (DAPDcName != null) {
                    this.DAPDcName = DAPDcName;
                }
                if (DAPDcName2 != null) {
                    this.DAPDcName2 = DAPDcName2;
                }
                if (DAPLocalDcName != null) {
                    this.DAPLocalDcName = DAPLocalDcName;
                }
                if (DAPLanguage != null) {
                    this.DAPLanguage = DAPLanguage;
                }
                if (isLockSrcTable != null) {
                    this.isLockSrcTable = Boolean.valueOf(isLockSrcTable);
                }
                if (fileMax != null) {
                    this.maxGzFileNum = Integer.parseInt(fileMax);
                }
            }
        }
        catch (FileNotFoundException e1) {
            this.createFile();
        }
        catch (Exception e) {
            return;
        }
    }

    public void updateFile() {
        String configPath = System.getProperty(PROPERTIES_DIR_ENV_NAME);
        String refinedFileName = configPath + "/" + CONFIG_FILE_NAME;
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("botCacheConfig");
            root.setAttribute(BOTPPREBATCHCACHE, Boolean.toString(this.isOpenBatchPreCache));
            root.setAttribute(BOTPCACHELIMIT, Integer.toString(this.maxCacheNum));
            root.setAttribute(BOTPMemCache, Boolean.toString(this.isMemCacheOpen));
            root.setAttribute(BOTPMappingCache, Boolean.toString(this.isMappingCacheOpen));
            root.setAttribute(ISCREATEFROMINORDER, Boolean.toString(this.isCreateFromInOrder));
            root.setAttribute(ISTHROWALLEXCEPTION, Boolean.toString(this.isThrowAllException));
            root.setAttribute(ISLOCKSRCTABLE, Boolean.toString(this.isLockSrcTable));
            root.setAttribute(BOTPGZFILELIMIT, Integer.toString(this.maxGzFileNum));
            org.jdom2.Document doc = new org.jdom2.Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.PRESERVE);
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile() {
        String configPath = System.getProperty(PROPERTIES_DIR_ENV_NAME);
        String refinedFileName = configPath + "/" + CONFIG_FILE_NAME;
        Document doc = DocumentFactory.getInstance().createDocument();
        doc.setName(CONFIG_FILE_NAME);
        org.dom4j.Element root = doc.addElement("botCacheConfig");
        root.addAttribute(BOTPPREBATCHCACHE, Boolean.toString(this.isOpenBatchPreCache));
        root.addAttribute(BOTPCACHELIMIT, Integer.toString(this.maxCacheNum));
        root.addAttribute(BOTPMemCache, Boolean.toString(this.isMemCacheOpen));
        root.addAttribute(BOTPMappingCache, Boolean.toString(this.isMappingCacheOpen));
        root.addAttribute(ISCREATEFROMINORDER, Boolean.toString(this.isCreateFromInOrder));
        root.addAttribute(ISTHROWALLEXCEPTION, Boolean.toString(this.isThrowAllException));
        root.addAttribute(ISLOCKSRCTABLE, Boolean.toString(this.isLockSrcTable));
        root.addAttribute(BOTPGZFILELIMIT, Integer.toString(this.maxGzFileNum));
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        FileOutputStream refinedFile = null;
        Writer writer = null;
        XMLWriter xmlWriter = null;
        try {
            refinedFile = new FileOutputStream(refinedFileName);
            writer = new OutputStreamWriter((OutputStream)refinedFile, "UTF-8");
            xmlWriter = new XMLWriter(writer, format);
            xmlWriter.write(doc);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            return;
        }
        finally {
            try {
                xmlWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                refinedFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

