/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.ormapping.contrast.ValueAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogDetailUtils {
    private static final String resource = "com.kingdee.eas.base.log.common.LogResource";
    private static Logger logger = Logger.getLogger(LogDetailUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractAndWriteLog(Context ctx, String flogid, Map<String, Object> detail) {
        PreparedStatement stmt;
        Connection cn;
        block11: {
            cn = null;
            stmt = null;
            Object mt = null;
            String detailSQL = "insert into t_log_detail (fid,flogid,faddmap,fupdatemap,fdeletemap) values (?,?,?,?,?) ";
            String selectSQL = "select * from t_log_app where FInstanceDetail is not null ";
            cn = LogDetailUtils.getConnection(ctx);
            stmt = cn.prepareStatement(detailSQL);
            stmt.setString(1, BOSUuid.create((String)"4507FB23").toString());
            stmt.setString(2, flogid);
            if (detail != null) break block11;
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
            return;
        }
        try {
            Map addnewMap = (Map)detail.get("addMap");
            Map updateMap = (Map)detail.get("updateMap");
            Map deleteMap = (Map)detail.get("deleteMap");
            if (addnewMap != null && addnewMap.size() > 0) {
                stmt.setBytes(3, LogDetailUtils.extractAdd(ctx, addnewMap).getBytes("UTF-8"));
            } else {
                stmt.setBytes(3, null);
            }
            if (updateMap != null && updateMap.size() > 0) {
                stmt.setBytes(4, LogDetailUtils.extractUpdate(ctx, updateMap).getBytes("UTF-8"));
            } else {
                stmt.setBytes(4, null);
            }
            if (deleteMap != null && deleteMap.size() > 0) {
                stmt.setBytes(5, LogDetailUtils.extractDel(ctx, deleteMap).getBytes("UTF-8"));
            } else {
                stmt.setBytes(5, null);
            }
            stmt.execute();
        }
        catch (Throwable th) {
            try {
                logger.error((Object)th.getMessage(), th);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private static String extractAdd(Context ctx, Map addnewMap) {
        StringBuffer sb = new StringBuffer(EASCommonResource.getString((String)resource, (String)"addPro", (Locale)ctx.getLocale()));
        sb.append("\n");
        for (Map.Entry entry : addnewMap.entrySet()) {
            sb.append(EASCommonResource.getString((String)resource, (String)"property", (Locale)ctx.getLocale())).append((String)entry.getKey());
            sb.append("\t");
            sb.append(EASCommonResource.getString((String)resource, (String)"value", (Locale)ctx.getLocale())).append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String extractUpdate(Context ctx, Map updateMap) {
        StringBuffer sb = new StringBuffer(EASCommonResource.getString((String)resource, (String)"updatePro", (Locale)ctx.getLocale()));
        sb.append("\n");
        Iterator it = updateMap.entrySet().iterator();
        String pairStr = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(EASCommonResource.getString((String)resource, (String)"updatePro", (Locale)ctx.getLocale())).append((String)entry.getKey());
            sb.append("\t");
            pairStr = entry.getValue().toString();
            if (entry.getValue() instanceof ValueAccess) {
                sb.append(pairStr);
                sb.append("\n");
                continue;
            }
            sb.append(EASCommonResource.getString((String)resource, (String)"value", (Locale)ctx.getLocale())).append(pairStr.substring(0, pairStr.indexOf("newVal")));
            sb.append(EASCommonResource.getString((String)resource, (String)"updateTo", (Locale)ctx.getLocale())).append(pairStr.substring(pairStr.indexOf("newVal")));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String extractDel(Context ctx, Map deleteMap) {
        StringBuffer sb = new StringBuffer(EASCommonResource.getString((String)resource, (String)"deletePro", (Locale)ctx.getLocale()));
        sb.append("\n");
        for (Map.Entry entry : deleteMap.entrySet()) {
            sb.append(EASCommonResource.getString((String)resource, (String)"property", (Locale)ctx.getLocale())).append((String)entry.getKey());
            sb.append("\t");
            sb.append(EASCommonResource.getString((String)resource, (String)"oriValue", (Locale)ctx.getLocale())).append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

