/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import java.util.HashMap;

public class LogQueue {
    public static final int MAXIMUM_CAPACITY = 1024;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static LogQueue instance;
    private HashMap[] logDatas = new HashMap[16];
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    private LogQueue() {
    }

    public static LogQueue getInstance() {
        if (instance == null) {
            instance = new LogQueue();
        }
        return instance;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized void enqueue(HashMap logData) {
        if (this.size == this.logDatas.length) {
            this.reSize();
        }
        this.logDatas[this.tail] = logData;
        this.tail = (this.tail + 1) % this.logDatas.length;
        ++this.size;
        if (this.size != 0) {
            this.notifyAll();
        }
    }

    public synchronized HashMap dequeue() throws InterruptedException {
        while (this.size == 0) {
            this.wait();
        }
        HashMap logData = this.logDatas[this.head];
        this.head = (this.head + 1) % this.logDatas.length;
        --this.size;
        return logData;
    }

    private void reSize() {
        int oldCapacity = this.logDatas.length;
        HashMap[] oldArray = this.logDatas;
        int newCapacity = oldCapacity << 1;
        HashMap[] newArray = new HashMap[newCapacity];
        int i = this.head;
        for (int j = 0; j < this.size; ++j) {
            newArray[j] = oldArray[i];
            i = (i + 1) % oldCapacity;
        }
        this.logDatas = newArray;
        this.head = 0;
        this.tail = this.size;
    }
}

