/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.FactorsControlType;
import com.kingdee.eas.base.risk.FactorsFieldEntryCollection;
import com.kingdee.eas.base.risk.FactorsFieldEntryInfo;
import com.kingdee.eas.base.risk.FactorsRuleEntryCollection;
import com.kingdee.eas.base.risk.FactorsRuleEntryInfo;
import com.kingdee.eas.base.risk.FixedValueFactory;
import com.kingdee.eas.base.risk.FixedValueInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskFactorsInfo;
import com.kingdee.eas.base.risk.app.AbstractRiskFactorsControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class RiskFactorsControllerBean
extends AbstractRiskFactorsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskFactorsControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RiskFactorsInfo factors = (RiskFactorsInfo)model;
        this.checkNumberDup(ctx, factors);
        FactorsControlType controlType = factors.getControlType();
        FactorsFieldEntryCollection factorsFieldEntry = factors.getFactorsFieldEntry();
        for (int i = 0; i < factorsFieldEntry.size(); ++i) {
            FactorsFieldEntryInfo factorsFieldInfo = factorsFieldEntry.get(i);
            FixedValueInfo fixedValue = factorsFieldInfo.getFixedValue();
            if ("Rule".equals(controlType.getValue())) {
                if (StringUtils.isEmpty((String)factorsFieldInfo.getFieldName()) || StringUtils.isEmpty((String)factorsFieldInfo.getFieldNumber())) {
                    factorsFieldEntry.remove(factorsFieldInfo);
                    --i;
                    continue;
                }
                if (fixedValue != null) {
                    FixedValueFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(fixedValue.getId()));
                    factorsFieldInfo.setFixedValue(null);
                }
                factorsFieldInfo.setExplains(null);
                continue;
            }
            if (!"Fixed".equals(controlType.getValue())) continue;
            if (factorsFieldInfo.getFixedValue() == null) {
                throw new RiskException(RiskException.FIXEDVALUEISNULL, new Object[]{i + 1});
            }
            FixedValueInfo fixedValueInfo = FixedValueFactory.getLocalInstance(ctx).getFixedValueInfo((IObjectPK)new ObjectUuidPK(factorsFieldInfo.getFixedValue().getId()));
            if (StringUtils.isEmpty((String)fixedValueInfo.getValue())) {
                throw new RiskException(RiskException.FIXEDVALUEISNULL, new Object[]{i + 1});
            }
            FactorsRuleEntryCollection factorsRuleEntry = factors.getFactorsRuleEntry();
            factorsRuleEntry.clear();
            if (!StringUtils.isEmpty((String)factorsFieldInfo.getFieldName()) && !StringUtils.isEmpty((String)factorsFieldInfo.getFieldNumber())) continue;
            throw new RiskException(RiskException.FACTORSFIELDISNULL, new Object[]{i + 1});
        }
        if ("Rule".equals(controlType.getValue())) {
            FactorsRuleEntryCollection factorsRuleEntry = factors.getFactorsRuleEntry();
            String compare = null;
            int size = factorsRuleEntry.size();
            for (int i = 0; i < size; ++i) {
                FactorsRuleEntryInfo ruleEntryInfo = factorsRuleEntry.get(i);
                if (StringUtils.isEmpty((String)ruleEntryInfo.getCompareField()) || StringUtils.isEmpty((String)ruleEntryInfo.getCompFieldName())) {
                    throw new RiskException(RiskException.COMPAREFIELDISNULL, new Object[]{i + 1});
                }
                compare = ruleEntryInfo.getCompare().getValue();
                if ("is null".equals(compare) && "isnot_null".equals(compare) || !StringUtils.isEmpty((String)ruleEntryInfo.getCompareValue()) && !StringUtils.isEmpty((String)ruleEntryInfo.getCompValName())) continue;
                throw new RiskException(RiskException.COMPAREVALUEISNULL, new Object[]{i + 1});
            }
        }
        return super._save(ctx, model);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (ref != null) {
            DataBaseInfo dataBase = null;
            try {
                dataBase = this.getDataBaseInfo(ctx, pk);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            logger.error((Object)(ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName()));
            throw new ObjectReferedException((Object)ref, (Throwable)((Object)new RiskException(RiskException.BIZ_REFENCED, new Object[]{dataBase.getNumber()})));
        }
    }
}

