/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.common;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.service.functions.aggregate.AvgFunction;
import com.kingdee.eas.base.risk.service.functions.aggregate.CountFunction;
import com.kingdee.eas.base.risk.service.functions.aggregate.MaxFunction;
import com.kingdee.eas.base.risk.service.functions.aggregate.MinFunction;
import com.kingdee.eas.base.risk.service.functions.aggregate.SumFunction;
import com.kingdee.eas.base.risk.service.functions.date.AppointDate;
import com.kingdee.eas.base.risk.service.functions.date.CurrentDateBefore;
import com.kingdee.eas.base.risk.service.functions.math.AbsFunction;
import com.kingdee.eas.base.risk.service.functions.math.Log10Function;
import com.kingdee.eas.base.risk.service.functions.string.LengthFunction;
import com.kingdee.eas.base.risk.service.functions.string.SplitFunction;
import java.util.Map;

public class AviatorUtils {
    public static Object execute(Context ctx, String expression, Map<String, Object> map) {
        boolean cachedExpr = AviatorUtils.cached(ctx);
        Expression compile = AviatorEvaluator.compile((String)expression, (boolean)cachedExpr);
        Object execute = compile.execute(map);
        return execute;
    }

    public static boolean cached(Context ctx) {
        String cache = RiskConfigUtils.getCache(ctx, "expressCached");
        boolean cachedExpr = "true".equalsIgnoreCase(cache);
        return cachedExpr;
    }

    public static Object execute(Context ctx, String expression) {
        boolean cachedExpr = AviatorUtils.cached(ctx);
        Expression compile = AviatorEvaluator.compile((String)expression, (boolean)cachedExpr);
        Object execute = compile.execute();
        return execute;
    }

    static {
        AviatorEvaluator.addFunction((AviatorFunction)new SumFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new CountFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new AvgFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new MaxFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new MinFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new LengthFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new SplitFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new AbsFunction());
        AviatorEvaluator.addFunction((AviatorFunction)new Log10Function());
        AviatorEvaluator.addFunction((AviatorFunction)new CurrentDateBefore());
        AviatorEvaluator.addFunction((AviatorFunction)new AppointDate());
    }
}

