/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.eas.base.risk.OutPutType;
import com.kingdee.eas.base.risk.ParamEntryInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ForcedParamConvertUtil {
    private static Logger logger = Logger.getLogger(ForcedParamConvertUtil.class);

    public static String convertToBillId(Context ctx, ParamEntryInfo paramEntryInfo, Object arg) throws RiskException {
        String script = paramEntryInfo.getConvertScript();
        if (StringUtils.isEmpty((CharSequence)script)) {
            return arg.toString();
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(paramEntryInfo.getParamName(), arg);
            Object eval = ForcedParamConvertUtil.eval(ctx, script, map, true);
            if (eval != null) {
                return eval.toString();
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to billId error] " + e.getMessage()));
        }
        throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to billId error]"));
    }

    public static Object eval(Context ctx, String script, Map map, boolean igoreNull) throws ParserException, InterpreterException {
        Interpreter interpreter = new Interpreter(ctx);
        interpreter.setProperyExprOwnerNullIgore(igoreNull);
        return interpreter.eval(script, map);
    }

    public static List<String> convertToBillIds(Context ctx, ParamEntryInfo paramEntryInfo, Object arg) throws RiskException {
        String script = paramEntryInfo.getConvertScript();
        if (StringUtils.isEmpty((CharSequence)script)) {
            return ForcedParamConvertUtil.getReturnList(ctx, arg, paramEntryInfo.getOutPutType());
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(paramEntryInfo.getParamName(), arg);
            Object rtnVal = ForcedParamConvertUtil.eval(ctx, script, map, true);
            return ForcedParamConvertUtil.getReturnList(ctx, rtnVal, paramEntryInfo.getOutPutType());
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to billIds error] " + e.getMessage()));
        }
    }

    private static List<String> getReturnList(Context ctx, Object rtnVal, OutPutType outPutType) throws RiskException {
        ArrayList<String> returnList = new ArrayList();
        if (OutPutType.String_arr.equals((Object)outPutType) || OutPutType.IObjectPK_arr.equals((Object)outPutType)) {
            Object[] strArr;
            for (Object billId : strArr = (Object[])rtnVal) {
                returnList.add(billId.toString());
            }
        } else if (OutPutType.List_String.equals((Object)outPutType)) {
            returnList = (List)rtnVal;
        } else {
            if (OutPutType.Set_String.equals((Object)outPutType)) {
                Set set = (Set)rtnVal;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    returnList.add((String)iterator.next());
                }
                return returnList;
            }
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[getReturnList OutPutType error]"));
        }
        return returnList;
    }

    public static IObjectValue convertToModel(Context ctx, ParamEntryInfo paramEntryInfo, Object arg) throws RiskException {
        String script = paramEntryInfo.getConvertScript();
        if (StringUtils.isEmpty((CharSequence)script)) {
            return (IObjectValue)arg;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(paramEntryInfo.getParamName(), arg);
            Object rtnVal = ForcedParamConvertUtil.eval(ctx, script, map, true);
            if (rtnVal != null) {
                return (IObjectValue)rtnVal;
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to model error] " + e.getMessage()));
        }
        throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to model error]"));
    }

    public static List<IObjectValue> convertToModelList(Context ctx, ParamEntryInfo paramEntryInfo, Object arg) throws RiskException {
        String script = paramEntryInfo.getConvertScript();
        if (StringUtils.isEmpty((CharSequence)script)) {
            return ForcedParamConvertUtil.getReturnColl(ctx, arg, paramEntryInfo.getOutPutType());
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(paramEntryInfo.getParamName(), arg);
            Object rtnVal = ForcedParamConvertUtil.eval(ctx, script, map, true);
            if (rtnVal != null) {
                return ForcedParamConvertUtil.getReturnColl(ctx, rtnVal, paramEntryInfo.getOutPutType());
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to model error] " + e.getMessage()));
        }
        throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[convert to model error]"));
    }

    private static List<IObjectValue> getReturnColl(Context ctx, Object arg, OutPutType outPutType) throws RiskException {
        ArrayList<IObjectValue> list = new ArrayList();
        if (OutPutType.List_IObjectValue.equals((Object)outPutType)) {
            list = (List)arg;
        } else if (OutPutType.Set_IObjectValue.equals((Object)outPutType)) {
            Set set = (Set)arg;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                list.add((IObjectValue)iterator.next());
            }
        } else if (OutPutType.IObjectCollection.equals((Object)outPutType)) {
            IObjectCollection coll = (IObjectCollection)arg;
            for (int i = 0; i < coll.size(); ++i) {
                list.add(coll.getObject(i));
            }
        } else {
            throw new RiskException(new NumericExceptionSubItem("00", "Risk Exception[getReturnColl OutPutType error]"));
        }
        return list;
    }
}

