/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.QueryCacheHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.app.AbstractOrgUictControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgUictControllerBean
extends AbstractOrgUictControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.app.OrgUictControllerBean");

    protected void _addBatch(Context ctx, List orgIdList, String configureId, String bizUnitPK, String cu, boolean use, boolean defaultCfg) throws BOSException, EASBizException {
        this.insertOrgUictList(ctx, orgIdList, configureId, bizUnitPK, cu, use, defaultCfg);
    }

    protected List _getAssignOrgId(Context ctx, String configureID) throws BOSException, EASBizException {
        return this.getOrgCollectionByCfgID(ctx, configureID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _updateDefaultCfg(Context ctx, String orgID, String cfgID, String bizUnitPK, boolean defaultCfg) throws BOSException, EASBizException {
        block10: {
            if (StringUtils.isEmpty((String)orgID)) {
                orgID = "";
            }
            String updateSql = "update T_UCT_OrgUict set fdefault = ? where forgid = ? and fbizunitpk = ?";
            Connection con = null;
            PreparedStatement state = null;
            try {
                con = this.getConnection(ctx);
                boolean isExist = this.isExist(con, orgID, cfgID);
                if (!isExist) {
                    ArrayList<String> orgList = new ArrayList<String>();
                    orgList.add(orgID);
                    this.insertOrgUictList(ctx, orgList, cfgID, bizUnitPK, "", false, false);
                }
                if (defaultCfg) {
                    state = con.prepareStatement(updateSql);
                    state.setBoolean(1, false);
                    state.setString(2, orgID);
                    state.setString(3, bizUnitPK);
                    state.executeUpdate();
                }
                updateSql = defaultCfg ? "update T_UCT_OrgUict set fdefault = ?,fuse = 1 where forgid = ? and fconfigureid = ?" : "update T_UCT_OrgUict set fdefault = ? where forgid = ? and fconfigureid = ?";
                state = con.prepareStatement(updateSql);
                state.setBoolean(1, defaultCfg);
                state.setString(2, orgID);
                state.setString(3, cfgID);
                state.executeUpdate();
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLException se) {
                logger.error((Object)"OrgUictControllerBean._updateDefaultCfg fail", (Throwable)se);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"OrgUictControllerBean._updateDefaultCfg fail", (Throwable)sde);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(state, (Connection)con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _updateUse(Context ctx, String orgID, String cfgID, String bizUnitPK, boolean use) throws BOSException, EASBizException {
        block10: {
            if (StringUtils.isEmpty((String)orgID)) {
                orgID = "";
            }
            String updateSql = "update T_UCT_OrgUict set fuse = ? where forgid = ? and fconfigureid = ?";
            Connection con = null;
            PreparedStatement state = null;
            QueryCacheHelper.clearAllSqlCache();
            try {
                con = this.getConnection(ctx);
                boolean isExist = this.isExist(con, orgID, cfgID);
                if (!isExist) {
                    ArrayList<String> orgList = new ArrayList<String>();
                    orgList.add(orgID);
                    this.insertOrgUictList(ctx, orgList, cfgID, bizUnitPK, "", use, false);
                } else {
                    state = con.prepareStatement(updateSql);
                    state.setBoolean(1, use);
                    state.setString(2, orgID);
                    state.setString(3, cfgID);
                    state.executeUpdate();
                }
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLException se) {
                logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)se);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)sde);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(state, (Connection)con);
            }
        }
    }

    private boolean isExist(Connection con, String orgID, String cfgID) throws SQLException {
        if (StringUtils.isEmpty((String)orgID)) {
            orgID = "";
        }
        String existSql = "select * from T_UCT_OrgUict where forgid = ? and fconfigureid = ?";
        PreparedStatement state = con.prepareStatement(existSql);
        state.setString(1, orgID);
        state.setString(2, cfgID);
        ResultSet rs = state.executeQuery();
        return rs.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteAsCfgID(Context ctx, String cfgID, String bizUnitPK) throws BOSException, EASBizException {
        String delSql = "delete from T_UCT_OrgUict where fconfigureid = ?";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(delSql);
            state.setString(1, cfgID);
            state.execute();
            delSql = "delete from T_UCT_UserOrgUict where fconfigureid = ?";
            state = con.prepareStatement(delSql);
            state.setString(1, cfgID);
            state.execute();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"OrgUictControllerBean._deleteAsCfgID fail", (Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntityRef(Context ctx, String cfgID) throws BOSException, EASBizException {
        String delSql = "delete from T_UCT_EntyRef where FConfigureID = ?";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(delSql);
            state.setString(1, cfgID);
            state.execute();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"OrgUictControllerBean.deleteEntityRef fail", (Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    protected List _getEditUICfgId(Context ctx, String orgID, String pk) throws BOSException, EASBizException {
        return this.getOrgConfigureIDs(ctx, orgID, "FUIOBJECTPK", pk);
    }

    protected List _getListUICfgId(Context ctx, String orgID, String pk) throws BOSException, EASBizException {
        return this.getOrgConfigureIDs(ctx, orgID, "FLISTUIOBJECTPK", pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List getOrgConfigureIDs(Context ctx, String orgID, String type, String pk) throws BOSException {
        PreparedStatement state;
        Connection con;
        ArrayList<String> list;
        block12: {
            list = new ArrayList<String>(3);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT \"CONFIGURE\".FID AS \"CONFIGURE.ID\"");
            sql.append(" ,\"ORGUICT\".FDEFAULT AS \"ORGUICT.DEFAULT\"");
            sql.append(" FROM T_UCT_OrgUict AS \"ORGUICT\"");
            sql.append(" INNER JOIN T_UCT_BizConfigure AS \"CONFIGURE\"");
            sql.append(" ON \"ORGUICT\".FConfigureID = \"CONFIGURE\".FID");
            sql.append(" WHERE \"CONFIGURE\"." + type + " = ?");
            sql.append(" AND \"ORGUICT\".FUSE = ?");
            if (!StringUtils.isEmpty((String)orgID)) {
                sql.append(" AND \"ORGUICT\".FORGID = ?");
            }
            con = null;
            state = null;
            try {
                ResultSet rs;
                con = this.getConnection(ctx);
                state = con.prepareStatement(sql.toString());
                state.setString(1, pk);
                state.setBoolean(2, true);
                if (!StringUtils.isEmpty((String)orgID)) {
                    state.setString(3, orgID);
                }
                if ((rs = state.executeQuery()) == null) break block12;
                String cfgID = null;
                int i = 0;
                while (rs.next()) {
                    if (i == 0) {
                        cfgID = rs.getString(1);
                    } else if (rs.getBoolean(2)) {
                        cfgID = rs.getString(1);
                    }
                    ++i;
                }
                if (StringUtils.isEmpty(cfgID)) break block12;
                list.add(cfgID);
            }
            catch (SQLException se) {
                logger.error((Object)"OrgUictControllerBean._getCfgId fail", (Throwable)se);
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"OrgUictControllerBean._getCfgId fail", (Throwable)sde);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(state, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _synAssign(Context ctx, String cfgID) throws BOSException, EASBizException {
        PreparedStatement state;
        Connection con;
        block6: {
            String existSql = "select * from t_uct_bizconfigure where fid = ?";
            con = null;
            state = null;
            try {
                con = this.getConnection(ctx);
                state = con.prepareStatement(existSql);
                state.setString(1, cfgID);
                ResultSet rs = state.executeQuery();
                if (rs.next()) break block6;
                this._deleteAsCfgID(ctx, cfgID, "");
                this.deleteEntityRef(ctx, cfgID);
            }
            catch (SQLException se) {
                logger.error((Object)"OrgUictControllerBean._getCfgId fail", (Throwable)se);
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"OrgUictControllerBean._getCfgId fail", (Throwable)sde);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(state, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrgUictList(Context ctx, List orgIdList, String configureId, String bizUnitPK, String cu, boolean use, boolean defaultCfg) throws SQLDataException {
        String orgIds = ToolUtils.aryToStr((List)orgIdList, (boolean)true);
        BOSObjectType objectType = this.getBOSType();
        String selectSql = "select forgid,fconfigureid from T_UCT_OrgUict where forgid in (" + orgIds + ") and fconfigureid in ('" + configureId + "')";
        String insertSql = "insert into T_UCT_OrgUict (fid,forgid,fconfigureid,fctrlunitid,fuse,fdefault,fbizunitpk) values(?,?,?,?,?,?,?)";
        Connection con = null;
        PreparedStatement state = null;
        ArrayList<OC> exists = new ArrayList<OC>();
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(selectSql);
            ResultSet rs = state.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    exists.add(new OC(rs.getString(1), rs.getString(2)));
                }
            }
            state = con.prepareStatement(insertSql);
            for (int j = orgIdList.size() - 1; j >= 0; --j) {
                String orgid = orgIdList.get(j).toString();
                OC oc = new OC(orgid, configureId);
                if (exists.contains(oc)) continue;
                String id = BOSUuid.create((BOSObjectType)objectType).toString();
                state.setString(1, id);
                state.setString(2, orgid);
                state.setString(3, configureId);
                state.setString(4, cu);
                state.setBoolean(5, true);
                state.setBoolean(6, false);
                state.setString(7, bizUnitPK);
                state.addBatch();
            }
            state.executeBatch();
            StringBuffer delSql = new StringBuffer();
            if (StringUtils.isEmpty((String)orgIds) || orgIds.equals("''")) {
                delSql.append("delete from T_UCT_OrgUict where fconfigureid in ('").append(configureId).append("')");
            } else {
                delSql.append("delete from T_UCT_OrgUict where forgid not in (").append(orgIds).append(") and fconfigureid in ('").append(configureId).append("')");
            }
            SQLUtils.execute((Connection)con, (String)delSql.toString());
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"OrgUictControllerBean.insertUserOrgUictList fail", (Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List getOrgCollectionByCfgID(Context ctx, String configureID) {
        PreparedStatement state;
        Connection con;
        ArrayList<String> list;
        block7: {
            list = new ArrayList<String>(3);
            String sql = "SELECT ORGUICT.FORGID FROM T_UCT_OrgUict AS ORGUICT WHERE ORGUICT.FCONFIGUREID = ?";
            con = null;
            state = null;
            try {
                con = this.getConnection(ctx);
                state = con.prepareStatement(sql);
                state.setString(1, configureID);
                ResultSet rs = state.executeQuery();
                if (rs == null) break block7;
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException se) {
                logger.error((Object)"OrgUictControllerBean.getOrgCollectionByCfgID fail", (Throwable)se);
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"OrgUictControllerBean.getOrgCollectionByCfgID fail", (Throwable)sde);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(state, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteAll(Context ctx) throws BOSException {
        String deleteSql = "delete from T_UCT_OrgUict";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(deleteSql);
            state.execute();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"OrgUictControllerBean._deleteAll fail", (Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    protected IObjectValue _getEditUIBizConfig(Context ctx, String userId, String userOrg, String orgID, String editUIPK) throws BOSException {
        CoreBaseCollection listUIcfgCol;
        List cfgID = this.getUserConfigureIDs(ctx, userId, userOrg, "FUIOBJECTPK", editUIPK);
        if (cfgID != null && cfgID.size() > 0 && (listUIcfgCol = BizConfigureFactory.getLocalInstance(ctx).getCollection("WHERE ID = '" + cfgID.get(0).toString() + "'")) != null && listUIcfgCol.size() > 0) {
            return listUIcfgCol.getObject(0);
        }
        cfgID = this.getOrgConfigureIDs(ctx, orgID, "FUIOBJECTPK", editUIPK);
        if (cfgID != null && cfgID.size() > 0 && (listUIcfgCol = BizConfigureFactory.getLocalInstance(ctx).getCollection("WHERE ID = '" + cfgID.get(0).toString() + "'")) != null && listUIcfgCol.size() > 0) {
            return listUIcfgCol.getObject(0);
        }
        return null;
    }

    protected IObjectValue _getListUIBizConfig(Context ctx, String userId, String userOrg, String orgID, String listUIPK) throws BOSException {
        CoreBaseCollection listUIcfgCol;
        List cfgID = this.getUserConfigureIDs(ctx, userId, userOrg, "FLISTUIOBJECTPK", listUIPK);
        if (cfgID != null && cfgID.size() > 0 && (listUIcfgCol = BizConfigureFactory.getLocalInstance(ctx).getCollection("WHERE ID = '" + cfgID.get(0).toString() + "'")) != null && listUIcfgCol.size() > 0) {
            return listUIcfgCol.getObject(0);
        }
        cfgID = this.getOrgConfigureIDs(ctx, orgID, "FLISTUIOBJECTPK", listUIPK);
        if (cfgID != null && cfgID.size() > 0 && (listUIcfgCol = BizConfigureFactory.getLocalInstance(ctx).getCollection("WHERE ID = '" + cfgID.get(0).toString() + "'")) != null && listUIcfgCol.size() > 0) {
            return listUIcfgCol.getObject(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List getUserConfigureIDs(Context ctx, String userId, String orgId, String type, String pk) {
        PreparedStatement state;
        Connection con;
        ArrayList<String> list;
        block8: {
            if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)pk)) {
                return null;
            }
            list = new ArrayList<String>(3);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT \"CONFIGURE\".FID AS \"CONFIGURE.ID\"");
            sql.append(" FROM T_UCT_UserOrgUict AS \"USERORGUICT\"");
            sql.append(" INNER JOIN T_UCT_BizConfigure AS \"CONFIGURE\"");
            sql.append(" ON \"USERORGUICT\".FConfigureID = \"CONFIGURE\".FID");
            sql.append(" WHERE \"USERORGUICT\".FUSERID = ?");
            sql.append(" AND \"USERORGUICT\".FORGID = ?");
            sql.append(" AND \"CONFIGURE\"." + type + " = ?");
            con = null;
            state = null;
            try {
                con = this.getConnection(ctx);
                state = con.prepareStatement(sql.toString());
                state.setString(1, userId);
                state.setString(2, orgId);
                state.setString(3, pk);
                ResultSet rs = state.executeQuery();
                if (rs == null) break block8;
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException se) {
                logger.error((Object)"UserOrgUictControllerBean.getConfigureCollection fail", (Throwable)se);
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
            catch (SQLDataException sde) {
                logger.error((Object)"UserOrgUictControllerBean.getConfigureCollection fail", (Throwable)sde);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(state, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)state, (Connection)con);
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _cancelAll(Context ctx, String cfgid) throws BOSException {
        String updateSql = "update T_UCT_OrgUict set fuse = ? ";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(updateSql);
            state.setBoolean(1, false);
            state.executeUpdate();
        }
        catch (SQLException se) {
            logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)se);
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        catch (SQLDataException sde) {
            logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)sde);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(state, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _startAll(Context ctx, String cfgid) throws BOSException {
        String updateSql = "update T_UCT_OrgUict set fuse = ? ";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(updateSql);
            state.setBoolean(1, true);
            state.executeUpdate();
        }
        catch (SQLException se) {
            logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)se);
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        catch (SQLDataException sde) {
            logger.error((Object)"OrgUictControllerBean._updateUse fail", (Throwable)sde);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(state, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    private class OC {
        private String ORGID = "";
        private String CFGID = "";

        public OC(String orgid, String cfgid) {
            if (orgid != null) {
                this.ORGID = orgid;
            }
            if (cfgid != null) {
                this.CFGID = cfgid;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof OC)) {
                return false;
            }
            OC that = (OC)obj;
            return this.ORGID.equals(that.ORGID) && this.CFGID.equals(that.CFGID);
        }
    }
}

