/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.LicenseType;
import com.kingdee.eas.base.uiframe.MainFunctionInfo;
import com.kingdee.eas.base.uiframe.MenuEditException;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.TempMainMenuItemInfo;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MainMenuQuickHelper {
    protected static final Logger logger = Logger.getLogger(MainMenuQuickHelper.class);
    private static List extReportList = null;
    private String extRptClassNames = null;
    private List reptlist = null;
    private String rptIds = null;
    private static final String[] extReportMenu = new String[]{"com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI", "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI"};
    private List otherList = null;
    private static volatile boolean errorWhenInitOtherList = false;
    private List otherPerlist = null;
    private String otherClassNames = null;
    private String otherIds = null;

    public IRowSet getAllMenu(Context ctx) throws BOSException, EASBizException {
        CustomCacheService cacheService = new CustomCacheService("login.all_menu");
        Object obj = cacheService.get("allMenuRowSet");
        if (obj == null) {
            String controlPolicy = "";
            try {
                controlPolicy = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getControlPolicy();
            }
            catch (LicenseException e) {
                logger.error((Object)e);
            }
            StringBuilder sqlstr = new StringBuilder();
            sqlstr.append("SELECT FID,FName_L1,FName_L2,FName_L3,FLongNumber,FImagePath,FVisible,");
            sqlstr.append("ffunction,FIsLeaf,FParent,FEnabled,FOrder,FUiClassName,FUiClassParam,");
            sqlstr.append("FUiOprt,FOpenMethod,FMenuType,FShortcutCode,FNumber ");
            sqlstr.append("FROM T_PM_MainMenuItem ");
            try {
                EASCloudEnum easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
                LicenseType licenseTypeVisiable = null;
                LicenseType licenseTypeMop = null;
                if (easCloudEnum != null) {
                    if (EASCloudEnum.CLOUD_PUBLIC.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.PublicCloudVisible;
                        licenseTypeMop = LicenseType.PublicCloudMonopolize;
                    } else if (EASCloudEnum.CLOUD_PRIVATE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.PrivateCloudVisible;
                        licenseTypeMop = LicenseType.PrivateCloudMonopolize;
                    } else if (EASCloudEnum.CLOUD_HYBRID.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.HyBridCloudVisible;
                        licenseTypeMop = LicenseType.HyBridCloudMonopolize;
                    }
                    sqlstr.append(" WHERE (FLicenseType =").append(0);
                    if (licenseTypeMop != null) {
                        sqlstr.append(" or FLicenseType =").append(licenseTypeMop.getValue());
                    }
                    if (licenseTypeVisiable != null) {
                        sqlstr.append(" or FLicenseType >=").append(licenseTypeVisiable.getValue()).append(")");
                    }
                }
            }
            catch (LicenseException e) {
                throw new BOSException((Throwable)e);
            }
            sqlstr.append(" ORDER BY FLongNumber");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlstr.toString());
            cacheService.put("allMenuRowSet", (Object)rows);
            return rows;
        }
        IRowSet rs = (IRowSet)obj;
        try {
            rs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return rs;
    }

    public List getAllMenuList(Context ctx) throws BOSException, EASBizException {
        CustomCacheService cacheService = new CustomCacheService("login.all_menu");
        Object obj = cacheService.get("allMenuRowSet");
        if (obj == null) {
            StringBuilder sqlstr = new StringBuilder();
            sqlstr.append("SELECT FID,FName_L1,FName_L2,FName_L3,FLongNumber,FImagePath,FVisible,");
            sqlstr.append("ffunction,FIsLeaf,FParent,FEnabled,FOrder,FUiClassName,FUiClassParam,");
            sqlstr.append("FUiOprt,FOpenMethod,FMenuType,FShortcutCode,FNumber ");
            sqlstr.append("FROM T_PM_MainMenuItem ");
            try {
                EASCloudEnum easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
                LicenseType licenseTypeVisiable = null;
                LicenseType licenseTypeMop = null;
                if (easCloudEnum != null) {
                    if (EASCloudEnum.CLOUD_PUBLIC.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.PublicCloudVisible;
                        licenseTypeMop = LicenseType.PublicCloudMonopolize;
                    } else if (EASCloudEnum.CLOUD_PRIVATE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.PrivateCloudVisible;
                        licenseTypeMop = LicenseType.PrivateCloudMonopolize;
                    } else if (EASCloudEnum.CLOUD_HYBRID.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                        licenseTypeVisiable = LicenseType.HyBridCloudVisible;
                        licenseTypeMop = LicenseType.HyBridCloudMonopolize;
                    }
                    sqlstr.append(" WHERE (FLicenseType =").append(0);
                    if (licenseTypeMop != null) {
                        sqlstr.append(" or FLicenseType =").append(licenseTypeMop.getValue());
                    }
                    if (licenseTypeVisiable != null) {
                        sqlstr.append(" or FLicenseType >=").append(licenseTypeVisiable.getValue()).append(")");
                    }
                }
            }
            catch (LicenseException e) {
                throw new BOSException((Throwable)e);
            }
            sqlstr.append(" ORDER BY FLongNumber");
            System.out.println("***xjw***getAllMenuList:sqlstr=" + sqlstr.toString());
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlstr.toString());
            ArrayList<TempMainMenuItemInfo> list = new ArrayList<TempMainMenuItemInfo>();
            try {
                while (rows.next()) {
                    TempMainMenuItemInfo mainMenuItemInformation = this.createMainMenuItemInfo(ctx.getLocale(), rows);
                    list.add(mainMenuItemInformation);
                }
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            cacheService.put("allMenuRowSet", list);
            return list;
        }
        List rs = (List)obj;
        return rs;
    }

    private MainMenuItemInfo create(Locale local, IRowSet rowset) throws UuidException, SQLException {
        MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
        menuItemInfo.setId(BOSUuid.read((String)rowset.getString("fid")));
        menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
        menuItemInfo.setName(rowset.getString("FName_L1"), BOSLocaleUtil.EAS_LOCALES[0]);
        menuItemInfo.setName(rowset.getString("FName_L2"), BOSLocaleUtil.EAS_LOCALES[1]);
        menuItemInfo.setName(rowset.getString("FName_L3"), BOSLocaleUtil.EAS_LOCALES[2]);
        menuItemInfo.setOrder(rowset.getString("FOrder"));
        menuItemInfo.setImagePath(rowset.getString("FImagePath"));
        menuItemInfo.setIsLeaf(rowset.getBoolean("FIsLeaf"));
        menuItemInfo.setVisible(rowset.getBoolean("FVisible"));
        menuItemInfo.setEnabled(rowset.getBoolean("FEnabled"));
        menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
        menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
        menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
        menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
        menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
        menuItemInfo.setNumber(rowset.getString("FNumber"));
        return menuItemInfo;
    }

    private MainMenuItemInfo create(Locale local, TempMainMenuItemInfo tempMainMenuItemInfo) throws UuidException, SQLException {
        MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
        menuItemInfo.setId(BOSUuid.read((String)tempMainMenuItemInfo.getId()));
        menuItemInfo.setLongNumber(tempMainMenuItemInfo.getLongNumber());
        menuItemInfo.setName(tempMainMenuItemInfo.getName_L1(), BOSLocaleUtil.EAS_LOCALES[0]);
        menuItemInfo.setName(tempMainMenuItemInfo.getName_L2(), BOSLocaleUtil.EAS_LOCALES[1]);
        menuItemInfo.setName(tempMainMenuItemInfo.getName_L3(), BOSLocaleUtil.EAS_LOCALES[2]);
        menuItemInfo.setOrder(tempMainMenuItemInfo.getOrder());
        menuItemInfo.setImagePath(tempMainMenuItemInfo.getImagePath());
        menuItemInfo.setIsLeaf(tempMainMenuItemInfo.getIsLeaf().booleanValue());
        menuItemInfo.setVisible(tempMainMenuItemInfo.getVisible().booleanValue());
        menuItemInfo.setEnabled(tempMainMenuItemInfo.getEnabled().booleanValue());
        menuItemInfo.setUiClassName(tempMainMenuItemInfo.getUiClassName());
        menuItemInfo.setUiClassParam(tempMainMenuItemInfo.getUiClassParam());
        menuItemInfo.setUiOprt(tempMainMenuItemInfo.getUiOprt());
        menuItemInfo.setOpenMethod(OpenMethod.getEnum(tempMainMenuItemInfo.getOpenMethod()));
        menuItemInfo.setShortcutCode(tempMainMenuItemInfo.getShortcutCode());
        menuItemInfo.setNumber(tempMainMenuItemInfo.getNumber());
        return menuItemInfo;
    }

    private TempMainMenuItemInfo createMainMenuItemInfo(Locale local, IRowSet rowset) throws UuidException, SQLException {
        TempMainMenuItemInfo menuItemInformation = new TempMainMenuItemInfo();
        menuItemInformation.setId(rowset.getString("FID"));
        menuItemInformation.setName_L1(rowset.getString("FName_L1"));
        menuItemInformation.setName_L2(rowset.getString("FName_L2"));
        menuItemInformation.setName_L3(rowset.getString("FName_L3"));
        menuItemInformation.setLongNumber(rowset.getString("FLongNumber"));
        menuItemInformation.setImagePath(rowset.getString("FImagePath"));
        menuItemInformation.setVisible(rowset.getBoolean("FVisible"));
        menuItemInformation.setFunction(rowset.getString("FFunction"));
        menuItemInformation.setIsLeaf(rowset.getBoolean("FIsLeaf"));
        menuItemInformation.setParent(rowset.getString("FParent"));
        menuItemInformation.setEnabled(rowset.getBoolean("FEnabled"));
        menuItemInformation.setOrder(rowset.getString("FOrder"));
        menuItemInformation.setUiClassName(rowset.getString("FUiClassName"));
        menuItemInformation.setUiClassParam(rowset.getString("FUiClassParam"));
        menuItemInformation.setUiOprt(rowset.getString("FUiOprt"));
        menuItemInformation.setOpenMethod(rowset.getString("FOpenMethod"));
        menuItemInformation.setMenuType(rowset.getString("FMenuType"));
        menuItemInformation.setShortcutCode(rowset.getString("FShortcutCode"));
        menuItemInformation.setNumber(rowset.getString("FNumber"));
        return menuItemInformation;
    }

    private synchronized void initExtReportList() {
        if (extReportList != null) {
            return;
        }
        String className = "com.kingdee.eas.rpts.ctrlreport.app.ExtReportForMenu";
        try {
            Class<?> c = Class.forName(className);
            Method staticMethod = c.getDeclaredMethod("getExtReports", new Class[0]);
            Object o = staticMethod.invoke(c, new Object[0]);
            String[] b = (String[])o;
            extReportList = Arrays.asList(b);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
            extReportList = Arrays.asList(extReportMenu);
        }
        catch (NoSuchMethodException ne) {
            logger.error((Object)"", (Throwable)ne);
            extReportList = Arrays.asList(extReportMenu);
        }
        catch (InvocationTargetException ie) {
            logger.error((Object)"", (Throwable)ie);
            extReportList = Arrays.asList(extReportMenu);
        }
        catch (IllegalAccessException iae) {
            logger.error((Object)"", (Throwable)iae);
            extReportList = Arrays.asList(extReportMenu);
        }
    }

    private void initOtherList() {
        if (this.otherList != null || errorWhenInitOtherList) {
            return;
        }
        String className = "com.kingdee.bos.qing.web.publish.perm.QingAnalysisMenuEntrance";
        try {
            Class<?> c = Class.forName(className);
            Method staticMethod = c.getDeclaredMethod("getQingURL", new Class[0]);
            Object o = staticMethod.invoke(c, new Object[0]);
            String[] b = (String[])o;
            this.otherList = Arrays.asList(b);
        }
        catch (Exception e) {
            errorWhenInitOtherList = true;
            logger.error((Object)"initOtherList():error-----------------------", (Throwable)e);
        }
    }

    private String getExtRptClassNames() {
        if (this.extRptClassNames != null) {
            return this.extRptClassNames;
        }
        if (extReportList == null) {
            this.initExtReportList();
        }
        this.extRptClassNames = extReportList != null && extReportList.size() > 0 ? ToolUtils.aryToStr((List)extReportList, (boolean)true) : "";
        return this.extRptClassNames;
    }

    private String getRptIds(Context ctx) {
        if (this.rptIds != null) {
            return this.rptIds;
        }
        if (this.reptlist == null) {
            this.reptlist = UIFrameUtils.getPermissionReportMenuids(ctx);
        }
        this.rptIds = this.reptlist == null ? "" : (this.reptlist.size() == 0 ? "'NO_SUIT'" : ToolUtils.aryToStr((List)this.reptlist, (boolean)true));
        return this.rptIds;
    }

    public boolean isExtReportMenu(String uiClassName) {
        boolean boo = false;
        if (extReportList == null) {
            this.initExtReportList();
        }
        if (extReportList != null && extReportList.indexOf(uiClassName) != -1) {
            boo = true;
        }
        return boo;
    }

    public boolean hasExtReportPermission(Context ctx, String menuId) {
        if (this.reptlist == null) {
            this.reptlist = UIFrameUtils.getPermissionReportMenuids(ctx);
        }
        if (this.reptlist == null) {
            return true;
        }
        return this.reptlist.contains(menuId);
    }

    public boolean isOtherMenu(String uiClassName) {
        boolean boo = false;
        if (this.otherList == null) {
            this.initOtherList();
        }
        if (this.otherList != null && this.otherList.indexOf(uiClassName) != -1) {
            boo = true;
        }
        return boo;
    }

    public boolean hasOtherPermission(Context ctx, String menuId) {
        if (this.otherPerlist == null) {
            this.otherPerlist = UIFrameUtils.getPermissionOtherMenuids(ctx);
        }
        if (this.otherPerlist == null) {
            return true;
        }
        return this.otherPerlist.contains(menuId);
    }

    private ArrayList getUserPermisssionItemList(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        String permissionSql = iPerm.getFunctionPermissionsByMenu();
        logger.error((Object)("permissionSql: " + permissionSql));
        StringBuffer sqlBuf = new StringBuffer("SELECT A.FPermItemID FROM (");
        sqlBuf.append(permissionSql);
        sqlBuf.append(") A WHERE EXISTS ( SELECT 1 FROM T_PM_MAINMENUITEM WHERE A.FPermItemID = FFunction) ");
        logger.error((Object)("add exists: " + sqlBuf.toString()));
        long t1 = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement ps = null;
        ArrayList<String> permList = null;
        ResultSet rows = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlBuf.toString());
            logger.error((Object)("getUserPermisssionItemList DbUtil.executeQuery cost: " + (System.currentTimeMillis() - t1)));
            rows = ps.executeQuery();
            permList = new ArrayList<String>();
            while (rows.next()) {
                permList.add(rows.getString(1));
            }
            logger.error((Object)("getUserPermisssionItemList cost: " + (System.currentTimeMillis() - t1)));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rows, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtil.cleanup((ResultSet)rows, (Statement)ps, (Connection)conn);
        return permList;
    }

    public MainFunctionInfo getInitMenuData(Context ctx) throws BOSException, EASBizException {
        return this.getInitMenuData(ctx, false);
    }

    public MainFunctionInfo getInitMenuData(Context ctx, boolean isGetWebMenu) throws BOSException, EASBizException {
        try {
            MainFunctionInfo fInfo = new MainFunctionInfo();
            MainMenuItemCollection cols = new MainMenuItemCollection();
            MainMenuItemInfo info = null;
            HashMap<String, MainMenuItemInfo> idMap = new HashMap<String, MainMenuItemInfo>();
            HashMap<String, MainMenuItemInfo> topMenuMap = new HashMap<String, MainMenuItemInfo>();
            List tempMainMenuItemList = this.getAllMenuList(ctx);
            ArrayList permList = this.getUserPermisssionItemList(ctx);
            HashMap subItemMap = new HashMap();
            boolean isTopMenu = false;
            String parentMenuId = null;
            String obj = null;
            String ffunction = null;
            if (tempMainMenuItemList != null) {
                for (int i = 0; i < tempMainMenuItemList.size(); ++i) {
                    TempMainMenuItemInfo tempMainMenuItemInfo = (TempMainMenuItemInfo)tempMainMenuItemList.get(i);
                    if (this.isExtReportMenu(tempMainMenuItemInfo.getUiClassName()) && !this.hasExtReportPermission(ctx, tempMainMenuItemInfo.getId()) || this.isOtherMenu(tempMainMenuItemInfo.getUiClassName()) && !this.hasOtherPermission(ctx, tempMainMenuItemInfo.getId()) || !MainMenuQuickHelper.isNeedType(isGetWebMenu, obj = tempMainMenuItemInfo.getMenuType()) || !StringUtils.isEmpty((String)(ffunction = tempMainMenuItemInfo.getFunction())) && !permList.contains(ffunction.toString())) continue;
                    info = this.create(ctx.getLocale(), tempMainMenuItemInfo);
                    parentMenuId = tempMainMenuItemInfo.getParent();
                    isTopMenu = false;
                    if (StringUtils.isEmpty((String)parentMenuId)) {
                        isTopMenu = true;
                    }
                    if (isTopMenu) {
                        topMenuMap.put(info.getLongNumber(), info);
                    } else {
                        if (!idMap.containsKey(parentMenuId)) continue;
                        info.setParent((MainMenuItemInfo)idMap.get(parentMenuId));
                    }
                    this.insertIntoTopLevelMenu(info, topMenuMap, cols);
                    if (!info.isIsLeaf()) {
                        idMap.put(info.getId().toString(), info);
                    }
                    this.add2TopMenuSubList(info, subItemMap, topMenuMap);
                }
            }
            fInfo.setTopLeverMenuCollection(cols);
            fInfo.setSubItemMap(subItemMap);
            return fInfo;
        }
        catch (SQLException sqle) {
            logger.error((Object)("database exception " + UIFrameUtils.getRes("res_1") + sqle.getMessage()));
            throw new MenuEditException(MenuEditException.GETINITMENUDATAEXCEPTION, sqle);
        }
    }

    public MainFunctionInfo getInitMenuAllData(Context ctx) throws BOSException, EASBizException {
        try {
            MainFunctionInfo fInfo = new MainFunctionInfo();
            MainMenuItemCollection cols = new MainMenuItemCollection();
            MainMenuItemInfo info = null;
            HashMap<String, MainMenuItemInfo> idMap = new HashMap<String, MainMenuItemInfo>();
            HashMap<String, MainMenuItemInfo> topMenuMap = new HashMap<String, MainMenuItemInfo>();
            List tempMainMenuItemList = this.getAllMenuList(ctx);
            ArrayList permList = this.getUserPermisssionItemList(ctx);
            HashMap subItemMap = new HashMap();
            boolean isTopMenu = false;
            String parentMenuId = null;
            String ffunction = null;
            if (tempMainMenuItemList != null) {
                for (int i = 0; i < tempMainMenuItemList.size(); ++i) {
                    TempMainMenuItemInfo tempMainMenuItemInfo = (TempMainMenuItemInfo)tempMainMenuItemList.get(i);
                    if (this.isExtReportMenu(tempMainMenuItemInfo.getUiClassName()) && !this.hasExtReportPermission(ctx, tempMainMenuItemInfo.getId()) || this.isOtherMenu(tempMainMenuItemInfo.getUiClassName()) && !this.hasOtherPermission(ctx, tempMainMenuItemInfo.getId()) || !StringUtils.isEmpty((String)(ffunction = tempMainMenuItemInfo.getFunction())) && !permList.contains(ffunction.toString())) continue;
                    info = this.create(ctx.getLocale(), tempMainMenuItemInfo);
                    parentMenuId = tempMainMenuItemInfo.getParent();
                    isTopMenu = false;
                    if (StringUtils.isEmpty((String)parentMenuId)) {
                        isTopMenu = true;
                    }
                    if (isTopMenu) {
                        topMenuMap.put(info.getLongNumber(), info);
                    } else {
                        if (!idMap.containsKey(parentMenuId)) continue;
                        info.setParent((MainMenuItemInfo)idMap.get(parentMenuId));
                    }
                    this.insertIntoTopLevelMenu(info, topMenuMap, cols);
                    if (!info.isIsLeaf()) {
                        idMap.put(info.getId().toString(), info);
                    }
                    this.add2TopMenuSubList(info, subItemMap, topMenuMap);
                }
            }
            fInfo.setSubItemMap(subItemMap);
            return fInfo;
        }
        catch (SQLException sqle) {
            logger.error((Object)("database exception " + UIFrameUtils.getRes("res_1") + sqle.getMessage()));
            throw new MenuEditException(MenuEditException.GETINITMENUDATAEXCEPTION, sqle);
        }
    }

    public MainFunctionInfo getSubItemMapWithoutEmptyBranch(Context ctx, boolean isGetWebMenu) throws BOSException, EASBizException {
        MainFunctionInfo initMenuData = this.getInitMenuData(ctx, isGetWebMenu);
        HashMap subItemMap = initMenuData.getSubItemMap();
        subItemMap = this.getSubItemMapWithoutEmptyBranch(subItemMap);
        initMenuData.setSubItemMap(subItemMap);
        return initMenuData;
    }

    private HashMap getSubItemMapWithoutEmptyBranch(Map subItemMap) {
        Map leafSubItemMap = this.getLeafSubItemMap(subItemMap);
        HashMap ret = new HashMap();
        Iterator keyItr = subItemMap.keySet().iterator();
        List allMainMenuList = null;
        List leafMainMenuList = null;
        ArrayList<MainMenuItemInfo> mainMenuListWithoutEmptyBranch = null;
        while (keyItr.hasNext()) {
            String topLongNumber = (String)keyItr.next();
            allMainMenuList = (List)subItemMap.get(topLongNumber);
            leafMainMenuList = (List)leafSubItemMap.get(topLongNumber);
            mainMenuListWithoutEmptyBranch = new ArrayList<MainMenuItemInfo>();
            ret.put(topLongNumber, new ArrayList());
            if (leafMainMenuList == null || leafMainMenuList.size() < 1) continue;
            int size = allMainMenuList.size();
            block1: for (int i = 0; i < size; ++i) {
                MainMenuItemInfo info = (MainMenuItemInfo)allMainMenuList.get(i);
                String longNumber = info.getLongNumber();
                int size1 = leafMainMenuList.size();
                for (int j = 0; j < size1; ++j) {
                    MainMenuItemInfo leaf = (MainMenuItemInfo)leafMainMenuList.get(j);
                    String leafLongNumber = leaf.getLongNumber();
                    if (!leafLongNumber.startsWith(longNumber + "!") && !StringUtils.equals((String)longNumber, (String)leafLongNumber)) continue;
                    mainMenuListWithoutEmptyBranch.add(info);
                    continue block1;
                }
            }
            ret.put(topLongNumber, mainMenuListWithoutEmptyBranch);
        }
        return ret;
    }

    private Map getLeafSubItemMap(Map subItemMap) {
        Iterator keyItr = subItemMap.keySet().iterator();
        ArrayList<MainMenuItemInfo> leafMainMenuList = null;
        HashMap ret = new HashMap();
        while (keyItr.hasNext()) {
            String topLongNumber = (String)keyItr.next();
            List allSubMainMenuList = (List)subItemMap.get(topLongNumber);
            leafMainMenuList = new ArrayList<MainMenuItemInfo>();
            int size = allSubMainMenuList.size();
            for (int i = 0; i < size; ++i) {
                MainMenuItemInfo info = (MainMenuItemInfo)allSubMainMenuList.get(i);
                if (!info.isIsLeaf()) continue;
                leafMainMenuList.add(info);
            }
            ret.put(topLongNumber, leafMainMenuList);
        }
        return ret;
    }

    private static boolean isNeedType(boolean isGetWebMenu, Object menuTypeObj) {
        if (isGetWebMenu) {
            return "5".equals(StringUtils.cnulls((Object)menuTypeObj));
        }
        String menuType = StringUtils.cnulls((Object)menuTypeObj);
        if (StringUtils.isEmpty((String)menuType)) {
            return true;
        }
        return "10".equals(menuType);
    }

    private void add2TopMenuSubList(MainMenuItemInfo info, Map subItemMap, Map topMenuMap) {
        String topLongNumber = this.findTopLongNumber(info.getLongNumber(), topMenuMap.keySet());
        if (!StringUtils.isEmpty((String)topLongNumber)) {
            ArrayList subList = new ArrayList();
            if (subItemMap.keySet().contains(topLongNumber)) {
                subList = (ArrayList)subItemMap.get(topLongNumber);
            }
            subList.add(info);
            subItemMap.put(topLongNumber, subList);
        } else {
            logger.debug((Object)("menu data error , not found top Menu, cur menu info is:" + info.getName() + " longnumber is:" + info.getLongNumber()));
        }
    }

    private void insertIntoTopLevelMenu(MainMenuItemInfo info, Map topMenuMap, MainMenuItemCollection cols) {
        HashSet<String> alreadyAddTopMenu = new HashSet<String>();
        for (int i = 0; i < cols.size(); ++i) {
            alreadyAddTopMenu.add(cols.get(i).getLongNumber());
        }
        String findLongNumber = this.findTopLongNumber(info.getLongNumber(), alreadyAddTopMenu);
        if (!StringUtils.isEmpty((String)findLongNumber)) {
            return;
        }
        findLongNumber = this.findTopLongNumber(info.getLongNumber(), topMenuMap.keySet());
        if (!StringUtils.isEmpty((String)findLongNumber) && !info.isIsLeaf() && info.isVisible()) {
            this.insertIntoTopLevelBySort(cols, (MainMenuItemInfo)topMenuMap.get(findLongNumber));
        }
    }

    private void insertIntoTopLevelBySort(MainMenuItemCollection cols, MainMenuItemInfo newTopMenu) {
        boolean haveInsert;
        if (cols.isEmpty()) {
            cols.add(newTopMenu);
            return;
        }
        for (int i = 0; i < cols.size() && !(haveInsert = this.insertNode(newTopMenu, cols, i)); ++i) {
        }
    }

    private boolean insertNode(MainMenuItemInfo newTopMenu, MainMenuItemCollection cols, int i) {
        boolean retValue = false;
        MainMenuItemInfo curItemInfo = cols.get(i);
        if (this.compareto(newTopMenu, curItemInfo) < 0) {
            if (i == 0) {
                cols.addObject(0, (IObjectValue)newTopMenu);
            } else {
                cols.insertObject(i - 1, (IObjectValue)newTopMenu);
            }
            return true;
        }
        if (i + 1 == cols.size()) {
            cols.add(newTopMenu);
            return true;
        }
        return retValue;
    }

    private int compareto(MainMenuItemInfo sourceItem, MainMenuItemInfo targetItem) {
        String sourceOrder = sourceItem.getOrder();
        String targetOrder = targetItem.getOrder();
        sourceOrder = sourceOrder == null ? "000" : sourceOrder;
        targetOrder = targetOrder == null ? "000" : targetOrder;
        return sourceOrder.compareTo(targetOrder);
    }

    private String findTopLongNumber(String longNumber, Set menuSet) {
        String topLongNumber2 = "";
        for (String topLongNumber2 : menuSet) {
            if (longNumber == null || topLongNumber2 == null || !longNumber.startsWith(topLongNumber2)) continue;
            return topLongNumber2;
        }
        return "";
    }

    protected Map<String, List<MainMenuItemInfo>> getChildMenuByParent(Context ctx, String parentId) throws BOSException, EASBizException {
        HashMap<String, List<MainMenuItemInfo>> result = new HashMap<String, List<MainMenuItemInfo>>();
        String sql = null;
        MainMenuItemInfo parentInfo = null;
        if (StringUtils.isEmpty((String)parentId)) {
            sql = this.getQuerySQL(ctx, true);
            logger.error((Object)("sql is : " + sql));
            long t2 = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            long t3 = System.currentTimeMillis();
            logger.error((Object)("DbUtil.executeQuery topmenu cost: " + (t3 - t2)));
            List<MainMenuItemInfo> subNodes = this.buildMenuInfo(ctx, rs);
            logger.error((Object)("subNodes size: " + subNodes.size()));
            result.put("topMenu", subNodes);
            return result;
        }
        sql = this.getQuerySQL(ctx, false);
        logger.error((Object)("sql is : " + sql));
        do {
            Object[] param = new Object[]{parentId};
            long t5 = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            long t6 = System.currentTimeMillis();
            logger.error((Object)("DbUtil.executeQuery cost: " + (t6 - t5) + " parentId: " + parentId));
            List<MainMenuItemInfo> subNodes = this.buildMenuInfo(ctx, rs);
            result.put(parentId, subNodes);
            if (subNodes.size() <= 0) break;
            parentInfo = subNodes.get(0);
            parentId = parentInfo.getId().toString();
        } while (!parentInfo.isIsLeaf());
        return result;
    }

    public Map<String, List<MainMenuItemInfo>> getChildMenuByParent(Context ctx, String parentId, List reptlist) throws BOSException, EASBizException {
        this.reptlist = reptlist;
        HashMap<String, List<MainMenuItemInfo>> result = new HashMap<String, List<MainMenuItemInfo>>();
        String sql = null;
        MainMenuItemInfo parentInfo = null;
        if (StringUtils.isEmpty((String)parentId)) {
            sql = this.getQuerySQL(ctx, true);
            logger.error((Object)("sql is : " + sql));
            long t2 = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            long t3 = System.currentTimeMillis();
            logger.error((Object)("DbUtil.executeQuery topmenu cost: " + (t3 - t2)));
            List<MainMenuItemInfo> subNodes = this.buildMenuInfo(ctx, rs);
            logger.error((Object)("subNodes size: " + subNodes.size()));
            result.put("topMenu", subNodes);
            return result;
        }
        sql = this.getQuerySQL(ctx, false);
        logger.error((Object)("sql is : " + sql));
        do {
            Object[] param = new Object[]{parentId};
            long t5 = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            long t6 = System.currentTimeMillis();
            logger.error((Object)("DbUtil.executeQuery cost: " + (t6 - t5) + " parentId: " + parentId));
            List<MainMenuItemInfo> subNodes = this.buildMenuInfo(ctx, rs);
            result.put(parentId, subNodes);
            if (subNodes.size() <= 0) break;
            parentInfo = subNodes.get(0);
            parentId = parentInfo.getId().toString();
        } while (!parentInfo.isIsLeaf());
        return result;
    }

    private String getQuerySQL(Context ctx, boolean isTopMenu) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        String permissionSql = iPerm.getFunctionPermissionsByMenu().replaceAll(" distinct ", " ");
        Object dbType = ctx.get((Object)"dbType");
        if (dbType != null && dbType.toString().toUpperCase().indexOf("DB2") != -1) {
            permissionSql = permissionSql.replaceAll("UNION all", "UNION");
        }
        StringBuffer sql = new StringBuffer("SELECT ").append(this.getSelectors(ctx)).append(" FROM T_PM_MAINMENUITEM MAIN1 ").append(" WHERE MAIN1.FPARENT ").append(isTopMenu ? "IS NULL " : "= ? ").append(isTopMenu ? " AND MAIN1.FIsLeaf = 0 " : "").append(" AND EXISTS ").append(" \t(SELECT 1 ").append("      \tFROM T_PM_MAINMENUITEM MAIN2 ").append("   \t\tWHERE MAIN2.FUICLASSNAME IS NOT NULL ");
        if (dbType != null && dbType.toString().equalsIgnoreCase("postgresql")) {
            sql.append("           AND MAIN2.FUICLASSNAME <> '' ");
        }
        sql.append("           AND MAIN2.FUICLASSNAME <> ' ' ").append("         \tAND MAIN2.FEnabled = 1 ").append("         \tAND MAIN2.FVisible = 1 ").append("         \tAND MAIN2.FIsLeaf = 1 ").append("       \tAND (MAIN2.FMenuType = 10 OR MAIN2.FMENUTYPE IS NULL) ");
        try {
            EASCloudEnum easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
            LicenseType licenseTypeVisiable = null;
            LicenseType licenseTypeMop = null;
            if (easCloudEnum != null) {
                if (EASCloudEnum.CLOUD_PUBLIC.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PublicCloudVisible;
                    licenseTypeMop = LicenseType.PublicCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_PRIVATE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PrivateCloudVisible;
                    licenseTypeMop = LicenseType.PrivateCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_HYBRID.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.HyBridCloudVisible;
                    licenseTypeMop = LicenseType.HyBridCloudMonopolize;
                }
                if (licenseTypeVisiable != null && licenseTypeMop != null) {
                    sql.append(" AND (MAIN2.FLicenseType =").append(0).append(" or MAIN2.FLicenseType =").append(licenseTypeMop.getValue()).append(" or MAIN2.FLicenseType >=").append(licenseTypeVisiable.getValue()).append(")");
                }
            }
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        if (dbType != null && dbType.toString().toUpperCase().indexOf("DB2") != -1) {
            sql.append(" AND CHARINDEX(MAIN1.FLONGNUMBER||'!', MAIN2.FLONGNUMBER||'!') > 0 ");
        } else {
            sql.append("       \tAND MAIN2.FLONGNUMBER||'!' LIKE ").append("           CONCAT (MAIN1.FLONGNUMBER, '!%') ");
        }
        sql.append("           AND ( \t\t\t\t\tEXISTS(SELECT 1 FROM (" + permissionSql + ") A WHERE MAIN2.FFUNCTION = A.FPermItemID \t\t\t\t\t) OR MAIN2.FFUNCTION IS NULL OR MAIN2.FFUNCTION = ' ' OR MAIN2.FFUNCTION = '') ").append(this.handleExtRpt(ctx)).append(this.handleOther(ctx)).append(this.handleAdministrator(ctx)).append(" \t) order by ").append(isTopMenu ? "MAIN1.FORDER, " : "").append("MAIN1.flongnumber");
        return sql.toString();
    }

    private String handleAdministrator(Context ctx) {
        StringBuilder builder = new StringBuilder();
        boolean superCUAdmin = Administrator.isSuperCUAdmin((IObjectPK)ctx.getCaller());
        if (!superCUAdmin) {
            builder.append(" AND (MAIN2.FUiClassName NOT IN (").append("'com.kingdee.eas.base.apply.client.SelfReqTypeListUI'").append(")) ");
        }
        return builder.toString();
    }

    private String handleExtRpt(Context ctx) {
        String rptIds;
        String extClassName = this.getExtRptClassNames();
        if (!StringUtils.isEmpty((String)extClassName) && !StringUtils.isEmpty((String)(rptIds = this.getRptIds(ctx)))) {
            return new StringBuffer().append(" AND (MAIN2.FUiClassName NOT IN (").append(extClassName).append(") OR MAIN2.FID IN (").append(rptIds).append("))").toString();
        }
        return "";
    }

    private String handleOther(Context ctx) {
        String otherIds;
        String otherClassName = this.getOtherClassNames();
        if (!StringUtils.isEmpty((String)otherClassName) && !StringUtils.isEmpty((String)(otherIds = this.getOtherIds(ctx)))) {
            return new StringBuffer().append(" AND (MAIN2.FUiClassName NOT IN (").append(otherClassName).append(") OR MAIN2.FID IN (").append(otherIds).append("))").toString();
        }
        return "";
    }

    private String getOtherClassNames() {
        if (this.otherClassNames != null) {
            return this.otherClassNames;
        }
        if (this.otherList == null) {
            this.initOtherList();
        }
        this.otherClassNames = this.otherList != null && this.otherList.size() > 0 ? ToolUtils.aryToStr((List)this.otherList, (boolean)true) : "";
        return this.otherClassNames;
    }

    private String getOtherIds(Context ctx) {
        if (this.otherIds != null) {
            return this.otherIds;
        }
        if (this.otherPerlist == null) {
            this.otherPerlist = UIFrameUtils.getPermissionOtherMenuids(ctx);
        }
        this.otherIds = this.otherPerlist == null ? "" : (this.otherPerlist.size() == 0 ? "'NO_SUIT'" : ToolUtils.aryToStr((List)this.otherPerlist, (boolean)true));
        return this.otherIds;
    }

    private List<MainMenuItemInfo> buildMenuInfo(Context ctx, IRowSet rs) throws BOSException {
        ArrayList<MainMenuItemInfo> result = new ArrayList<MainMenuItemInfo>();
        try {
            while (rs.next()) {
                MainMenuItemInfo info = new MainMenuItemInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setName(rs.getString(2));
                info.setLongNumber(rs.getString(3));
                info.setIsLeaf(rs.getBoolean(4));
                info.setShortcutCode(rs.getString(5));
                info.setOpenMethod(OpenMethod.getEnum(rs.getInt(6)));
                info.setUiClassName(rs.getString(7));
                info.setImagePath(rs.getString(8));
                if (!StringUtils.isEmpty((String)rs.getString(9))) {
                    PermItemInfo itemInfo = new PermItemInfo();
                    itemInfo.setId(BOSUuid.read((String)rs.getString(9)));
                    info.setFunction(itemInfo);
                }
                info.setEnabled(rs.getBoolean(10));
                info.setNumber(rs.getString(11));
                info.setUiClassParam(rs.getString(12));
                info.setUiOprt(rs.getString(13));
                result.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getSelectors(Context ctx) {
        return "FID, FName_" + ctx.getLocale() + ", FLongNumber, FIsLeaf, FShortCutCode, FOpenMethod, FUiClassName, FImagePath, FFunction,FEnabled,FNumber,FUiClassParam,FUiOprt ";
    }
}

